/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.dir.FrameDialogWrapper;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.config.GitVersion;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitShowExternalLogAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(GitShowExternalLogAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/log/GitShowExternalLogAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && GitVcs.getInstance(e.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/log/GitShowExternalLogAction", "actionPerformed"));
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        final GitVcs vcs = (GitVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)GitVcs.getInstance(project))));
        final List<VirtualFile> roots = GitShowExternalLogAction.getGitRootsFromUser(project);
        if (roots.isEmpty()) {
            return;
        }
        if (project.isDefault() || !ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss()) {
            ProgressManager.getInstance().run((Task)new ShowLogInDialogTask(project, roots, vcs));
            return;
        }
        final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        Runnable showContent = new Runnable(){

            @Override
            public void run() {
                ContentManager cm = window.getContentManager();
                if (GitShowExternalLogAction.checkIfProjectLogMatches(project, vcs, cm, roots) || GitShowExternalLogAction.checkIfAlreadyOpened(cm, roots)) {
                    return;
                }
                String tabName = GitShowExternalLogAction.calcTabName(cm, roots);
                MyContentComponent component = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, tabName);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, tabName, false);
                content.setDisposer(component.myDisposable);
                content.setDescription("Log for " + StringUtil.join((Collection)roots, (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return file.getPath();
                    }
                }, (String)"\n"));
                content.setCloseable(true);
                cm.addContent(content);
                cm.setSelectedContent(content);
            }
        };
        if (!window.isVisible()) {
            window.activate(showContent, true);
        } else {
            showContent.run();
        }
    }

    @NotNull
    private static MyContentComponent createManagerAndContent(@NotNull Project project, final @NotNull GitVcs vcs, final @NotNull List<VirtualFile> roots, @Nullable String tabName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowExternalLogAction", "createManagerAndContent"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/log/GitShowExternalLogAction", "createManagerAndContent"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction", "createManagerAndContent"));
        }
        final GitRepositoryManager repositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        GitPlatformFacade facade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        for (VirtualFile root : roots) {
            repositoryManager.addExternalRepository(root, GitRepositoryImpl.getFullInstance(root, project, facade, (Disposable)project));
        }
        VcsLogManager manager = new VcsLogManager(project, (VcsLogSettings)ServiceManager.getService((Project)project, VcsLogSettings.class), (VcsLogUiProperties)ServiceManager.getService((Project)project, VcsLogUiProperties.class));
        List vcsRoots = ContainerUtil.map(roots, (Function)new Function<VirtualFile, VcsRoot>(){

            public VcsRoot fun(VirtualFile root) {
                return new VcsRoot((AbstractVcs)vcs, root);
            }
        });
        MyContentComponent myContentComponent = new MyContentComponent(manager.initContent((Collection)vcsRoots, tabName), roots, new Disposable(){

            public void dispose() {
                for (VirtualFile root : roots) {
                    repositoryManager.removeExternalRepository(root);
                }
            }
        });
        if (myContentComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction", "createManagerAndContent"));
        }
        return myContentComponent;
    }

    @NotNull
    private static String calcTabName(@NotNull ContentManager cm, @NotNull List<VirtualFile> roots) {
        if (cm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cm", "git4idea/log/GitShowExternalLogAction", "calcTabName"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction", "calcTabName"));
        }
        String name = "Log (" + roots.get(0).getName();
        if (roots.size() > 1) {
            name = name + "+";
        }
        String candidate = name = name + ")";
        int cnt = 1;
        while (GitShowExternalLogAction.hasContentsWithName(cm, candidate)) {
            candidate = name + "-" + cnt;
            ++cnt;
        }
        String string = candidate;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction", "calcTabName"));
        }
        return string;
    }

    private static boolean hasContentsWithName(@NotNull ContentManager cm, final @NotNull String candidate) {
        if (cm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cm", "git4idea/log/GitShowExternalLogAction", "hasContentsWithName"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "git4idea/log/GitShowExternalLogAction", "hasContentsWithName"));
        }
        return ContainerUtil.exists((Object[])cm.getContents(), (Condition)new Condition<Content>(){

            public boolean value(Content content) {
                return content.getDisplayName().equals(candidate);
            }
        });
    }

    @NotNull
    private static List<VirtualFile> getGitRootsFromUser(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowExternalLogAction", "getGitRootsFromUser"));
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFiles.length == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction", "getGitRootsFromUser"));
            }
            return list;
        }
        ArrayList correctRoots = ContainerUtil.newArrayList();
        for (VirtualFile vf : virtualFiles) {
            if (!GitUtil.isGitRoot(new File(vf.getPath()))) continue;
            correctRoots.add(vf);
        }
        ArrayList arrayList = correctRoots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction", "getGitRootsFromUser"));
        }
        return arrayList;
    }

    private static boolean checkIfProjectLogMatches(@NotNull Project project, @NotNull GitVcs vcs, @NotNull ContentManager cm, @NotNull List<VirtualFile> requestedRoots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowExternalLogAction", "checkIfProjectLogMatches"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/log/GitShowExternalLogAction", "checkIfProjectLogMatches"));
        }
        if (cm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cm", "git4idea/log/GitShowExternalLogAction", "checkIfProjectLogMatches"));
        }
        if (requestedRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedRoots", "git4idea/log/GitShowExternalLogAction", "checkIfProjectLogMatches"));
        }
        VirtualFile[] projectRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (Comparing.haveEqualElements(requestedRoots, Arrays.asList(projectRoots))) {
            Content[] contents;
            for (Content content : contents = cm.getContents()) {
                if (!"Log".equals(content.getDisplayName())) continue;
                cm.setSelectedContent(content);
                return true;
            }
        }
        return false;
    }

    private static boolean checkIfAlreadyOpened(@NotNull ContentManager cm, @NotNull Collection<VirtualFile> roots) {
        if (cm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cm", "git4idea/log/GitShowExternalLogAction", "checkIfAlreadyOpened"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction", "checkIfAlreadyOpened"));
        }
        for (Content content : cm.getContents()) {
            JComponent component = content.getComponent();
            if (!(component instanceof MyContentComponent) || !Comparing.haveEqualElements(roots, (Collection)((MyContentComponent)component).myRoots)) continue;
            cm.setSelectedContent(content);
            return true;
        }
        return false;
    }

    private static class MyDialog
    extends FrameDialogWrapper {
        @NotNull
        private final MyContentComponent myContent;
        @NotNull
        private final Project myProject;

        private MyDialog(@NotNull Project project, @NotNull GitVcs vcs, @NotNull List<VirtualFile> roots) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowExternalLogAction$MyDialog", "<init>"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/log/GitShowExternalLogAction$MyDialog", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction$MyDialog", "<init>"));
            }
            this.myProject = project;
            this.myContent = GitShowExternalLogAction.createManagerAndContent(project, vcs, roots, null);
        }

        @NotNull
        protected FrameDialogWrapper.Mode getMode() {
            FrameDialogWrapper.Mode mode = FrameDialogWrapper.Mode.FRAME;
            if (mode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction$MyDialog", "getMode"));
            }
            return mode;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction$MyDialog", "getProject"));
            }
            return project;
        }

        @Nullable
        protected String getTitle() {
            return "Git Log";
        }

        @NotNull
        protected JComponent getPanel() {
            MyContentComponent myContentComponent = this.myContent;
            if (myContentComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitShowExternalLogAction$MyDialog", "getPanel"));
            }
            return myContentComponent;
        }

        @Nullable
        protected JComponent getPreferredFocusedComponent() {
            return this.myContent;
        }

        @Nullable
        protected Disposable getDisposable() {
            return this.myContent.myDisposable;
        }
    }

    private static class ShowLogInDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<VirtualFile> myRoots;
        @NotNull
        private final GitVcs myVcs;
        private GitVersion myVersion;

        private ShowLogInDialogTask(@NotNull Project project, @NotNull List<VirtualFile> roots, @NotNull GitVcs vcs) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask", "<init>"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask", "<init>"));
            }
            super(project, "Loading Git Log...", true, BackgroundFromStartOption.getInstance());
            this.myProject = project;
            this.myRoots = roots;
            this.myVcs = vcs;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/log/GitShowExternalLogAction$ShowLogInDialogTask", "run"));
            }
            this.myVersion = this.myVcs.getVersion();
            if (this.myVersion.isNull()) {
                this.myVcs.checkVersion();
                this.myVersion = this.myVcs.getVersion();
            }
        }

        public void onSuccess() {
            if (!this.myVersion.isNull() && !this.myProject.isDisposed()) {
                new MyDialog(this.myProject, this.myVcs, this.myRoots).show();
            }
        }
    }

    private static class MyContentComponent
    extends JPanel {
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final Disposable myDisposable;

        MyContentComponent(@NotNull JComponent actualComponent, @NotNull Collection<VirtualFile> roots, @NotNull Disposable disposable) {
            if (actualComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualComponent", "git4idea/log/GitShowExternalLogAction$MyContentComponent", "<init>"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/log/GitShowExternalLogAction$MyContentComponent", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "git4idea/log/GitShowExternalLogAction$MyContentComponent", "<init>"));
            }
            super(new BorderLayout());
            this.myDisposable = disposable;
            this.myRoots = roots;
            this.add(actualComponent);
        }
    }
}

