/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InheritorsHolder;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaNoVariantsDelegator;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.BetterPrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GrMainCompletionProvider;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovySmartCompletionContributor;
import org.jetbrains.plugins.groovy.lang.completion.MapArgumentCompletionProvider;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyNoVariantsDelegator
extends CompletionContributor {
    private static boolean suggestMetaAnnotations(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{GrCodeReferenceElement.class, GrAnnotation.class, GrModifierList.class, GrAnnotationTypeDefinition.class})).accepts((Object)position);
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        boolean empty;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/GroovyNoVariantsDelegator", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/GroovyNoVariantsDelegator", "fillCompletionVariants"));
        }
        LinkedHashSet plainResults = result.runRemainingContributors(parameters, true);
        boolean bl = empty = JavaNoVariantsDelegator.containsOnlyPackages((LinkedHashSet)plainResults) || GroovyNoVariantsDelegator.suggestMetaAnnotations(parameters);
        if (!empty && parameters.getInvocationCount() == 0) {
            result.restartCompletionWhenNothingMatches();
        }
        if (empty) {
            GroovyNoVariantsDelegator.delegate(parameters, result);
        } else if (Registry.is((String)"ide.completion.show.better.matching.classes") && parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName((CompletionResultSet)result) && GrMainCompletionProvider.isClassNamePossible(parameters.getPosition()) && !MapArgumentCompletionProvider.isMapKeyCompletion(parameters) && !GroovySmartCompletionContributor.AFTER_NEW.accepts((Object)parameters.getPosition())) {
            result = result.withPrefixMatcher((PrefixMatcher)new BetterPrefixMatcher(result.getPrefixMatcher(), BetterPrefixMatcher.getBestMatchingDegree((LinkedHashSet)plainResults)));
            GroovyNoVariantsDelegator.suggestNonImportedClasses(parameters, result);
        }
    }

    private static void delegate(CompletionParameters parameters, CompletionResultSet result) {
        if (parameters.getCompletionType() == CompletionType.BASIC) {
            if (parameters.getInvocationCount() <= 1 && JavaCompletionContributor.mayStartClassName((CompletionResultSet)result) && GrMainCompletionProvider.isClassNamePossible(parameters.getPosition()) && !MapArgumentCompletionProvider.isMapKeyCompletion(parameters)) {
                GroovyNoVariantsDelegator.suggestNonImportedClasses(parameters, result);
            }
            GroovyNoVariantsDelegator.suggestChainedCalls(parameters, result);
        }
    }

    private static void suggestNonImportedClasses(CompletionParameters parameters, final CompletionResultSet result) {
        GrMainCompletionProvider.addAllClasses(parameters, new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)element.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
                if (classElement != null) {
                    classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                }
                result.addElement(element);
            }
        }, new InheritorsHolder(parameters.getPosition(), result), result.getPrefixMatcher());
    }

    private static void suggestChainedCalls(CompletionParameters parameters, CompletionResultSet result) {
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (!(parent instanceof GrReferenceElement)) {
            return;
        }
        PsiElement qualifier = ((GrReferenceElement)parent).getQualifier();
        if (!(qualifier instanceof GrReferenceElement) || ((GrReferenceElement)qualifier).getQualifier() != null) {
            return;
        }
        PsiElement target = ((GrReferenceElement)qualifier).resolve();
        if (target != null && !(target instanceof PsiPackage)) {
            return;
        }
        String fullPrefix = position.getContainingFile().getText().substring(parent.getTextRange().getStartOffset(), parameters.getOffset());
        final CompletionResultSet qualifiedCollector = result.withPrefixMatcher(fullPrefix);
        InheritorsHolder inheritors = new InheritorsHolder(position, result);
        for (final LookupElement base : GroovyNoVariantsDelegator.suggestQualifierItems(parameters, (GrReferenceElement)qualifier, inheritors)) {
            PsiType type = JavaCompletionUtil.getLookupElementType((LookupElement)base);
            if (type == null || PsiType.VOID.equals((Object)type)) continue;
            GrReferenceElement ref = GroovyNoVariantsDelegator.createMockReference(position, type, base);
            PsiElement refName = ref.getReferenceNameElement();
            assert (refName != null);
            CompletionParameters newParams = parameters.withPosition(refName, refName.getTextRange().getStartOffset());
            GrMainCompletionProvider.completeReference(newParams, ref, inheritors, result.getPrefixMatcher(), new Consumer<LookupElement>(){

                public void consume(LookupElement element) {
                    qualifiedCollector.addElement((LookupElement)new JavaChainLookupElement(base, element){

                        protected boolean shouldParenthesizeQualifier(PsiFile file, int startOffset, int endOffset) {
                            return false;
                        }
                    });
                }
            });
        }
    }

    private static GrReferenceElement createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/groovy/lang/completion/GroovyNoVariantsDelegator", "createMockReference"));
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            return factory.createReferenceExpressionFromText(((PsiClass)qualifierItem.getObject()).getQualifiedName() + ".xxx", place);
        }
        return factory.createReferenceExpressionFromText("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable((PsiElement)place, (PsiType)qualifierType));
    }

    private static Set<LookupElement> suggestQualifierItems(CompletionParameters _parameters, GrReferenceElement qualifier, InheritorsHolder inheritors) {
        CompletionParameters parameters = _parameters.withPosition(qualifier.getReferenceNameElement(), qualifier.getTextRange().getEndOffset());
        String referenceName = qualifier.getReferenceName();
        if (referenceName == null) {
            return Collections.emptySet();
        }
        CamelHumpMatcher qMatcher = new CamelHumpMatcher(referenceName);
        LinkedHashSet<LookupElement> variants = new LinkedHashSet<LookupElement>();
        GrMainCompletionProvider.completeReference(parameters, qualifier, inheritors, (PrefixMatcher)qMatcher, new Consumer<LookupElement>((PrefixMatcher)qMatcher, variants){
            final /* synthetic */ PrefixMatcher val$qMatcher;
            final /* synthetic */ Set val$variants;
            {
                this.val$qMatcher = prefixMatcher;
                this.val$variants = set;
            }

            public void consume(LookupElement element) {
                if (this.val$qMatcher.prefixMatches(element)) {
                    this.val$variants.add(element);
                }
            }
        });
        for (PsiClass aClass : PsiShortNamesCache.getInstance((Project)qualifier.getProject()).getClassesByName(referenceName, qualifier.getResolveScope())) {
            variants.add(GroovyCompletionUtil.createClassLookupItem(aClass));
        }
        if (variants.isEmpty()) {
            GrMainCompletionProvider.addAllClasses(parameters, new Consumer<LookupElement>((PrefixMatcher)qMatcher, variants){
                final /* synthetic */ PrefixMatcher val$qMatcher;
                final /* synthetic */ Set val$variants;
                {
                    this.val$qMatcher = prefixMatcher;
                    this.val$variants = set;
                }

                public void consume(LookupElement element) {
                    if (this.val$qMatcher.prefixMatches(element)) {
                        this.val$variants.add(element);
                    }
                }
            }, inheritors, (PrefixMatcher)qMatcher);
        }
        return variants;
    }
}

