/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.highlighter.DefaultHighlighter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.NamedArgumentInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class MapArgumentCompletionProvider
extends CompletionProvider<CompletionParameters> {
    public static final ElementPattern<PsiElement> IN_ARGUMENT_LIST_OF_CALL = PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(GrReferenceExpression.class).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(GrArgumentList.class), PlatformPatterns.psiElement(GrListOrMap.class)})));
    public static final ElementPattern<PsiElement> IN_LABEL = PlatformPatterns.psiElement((IElementType)GroovyTokenTypes.mIDENT).withParent(GrArgumentLabel.class);

    private MapArgumentCompletionProvider() {
    }

    public static void register(CompletionContributor contributor) {
        MapArgumentCompletionProvider instance = new MapArgumentCompletionProvider();
        contributor.extend(CompletionType.BASIC, IN_ARGUMENT_LIST_OF_CALL, (CompletionProvider)instance);
        contributor.extend(CompletionType.BASIC, IN_LABEL, (CompletionProvider)instance);
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        Map<String, NamedArgumentDescriptor> map;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider", "addCompletions"));
        }
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters);
        if (mapOrArgumentList == null) {
            return;
        }
        if (MapArgumentCompletionProvider.isMapKeyCompletion(parameters)) {
            result.stopHere();
        }
        if ((map = MapArgumentCompletionProvider.calcNamedArgumentsForCall(mapOrArgumentList)) == null) {
            return;
        }
        if (map.isEmpty()) {
            map = MapArgumentCompletionProvider.findOtherNamedArgumentsInFile(mapOrArgumentList);
        }
        for (GrNamedArgument argument : MapArgumentCompletionProvider.getSiblingNamedArguments(mapOrArgumentList)) {
            map.remove(argument.getLabelName());
        }
        for (Map.Entry<String, NamedArgumentDescriptor> entry : map.entrySet()) {
            LookupElementBuilder lookup = LookupElementBuilder.create((Object)entry.getValue(), (String)entry.getKey()).withInsertHandler((InsertHandler)NamedArgumentInsertHandler.INSTANCE).withTailText(":");
            if (entry.getValue().getPriority() == NamedArgumentDescriptor.Priority.UNLIKELY) {
                lookup.withItemTextForeground(DefaultHighlighter.MAP_KEY_COLOR);
            } else {
                lookup = lookup.withIcon(JetgroovyIcons.Groovy.DynamicProperty);
            }
            result.addElement((LookupElement)lookup);
        }
    }

    public static boolean isMapKeyCompletion(CompletionParameters parameters) {
        PsiElement mapOrArgumentList = MapArgumentCompletionProvider.findMapOrArgumentList(parameters);
        return mapOrArgumentList instanceof GrListOrMap && ((GrListOrMap)mapOrArgumentList).getNamedArguments().length > 0;
    }

    @Nullable
    private static PsiElement findMapOrArgumentList(CompletionParameters parameters) {
        PsiElement parent = parameters.getPosition().getParent();
        if (parent instanceof GrReferenceExpression) {
            if (((GrReferenceExpression)parent).getQualifier() != null) {
                return null;
            }
            return parent.getParent();
        }
        if (parent == null || parent.getParent() == null) {
            return null;
        }
        return parent.getParent().getParent();
    }

    private static Map<String, NamedArgumentDescriptor> findOtherNamedArgumentsInFile(PsiElement mapOrArgumentList) {
        final HashMap<String, NamedArgumentDescriptor> map = new HashMap<String, NamedArgumentDescriptor>();
        mapOrArgumentList.getContainingFile().accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                String name;
                if (element instanceof GrArgumentLabel && GroovyNamesUtil.isIdentifier(name = ((GrArgumentLabel)element).getName())) {
                    map.put(name, NamedArgumentDescriptor.SIMPLE_UNLIKELY);
                }
                super.visitElement(element);
            }
        });
        return map;
    }

    private static GrNamedArgument[] getSiblingNamedArguments(PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList instanceof GrListOrMap) {
            return ((GrListOrMap)mapOrArgumentList).getNamedArguments();
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList && argumentList.getParent() instanceof GrCall) {
            return PsiUtil.getFirstMapNamedArguments((GrCall)argumentList.getParent());
        }
        return GrNamedArgument.EMPTY_ARRAY;
    }

    @Nullable
    private static Map<String, NamedArgumentDescriptor> calcNamedArgumentsForCall(@NotNull PsiElement mapOrArgumentList) {
        PsiElement argumentList;
        if (mapOrArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapOrArgumentList", "org/jetbrains/plugins/groovy/lang/completion/MapArgumentCompletionProvider", "calcNamedArgumentsForCall"));
        }
        PsiElement psiElement = argumentList = mapOrArgumentList instanceof GrArgumentList ? mapOrArgumentList : mapOrArgumentList.getParent();
        if (argumentList instanceof GrArgumentList) {
            if (mapOrArgumentList instanceof GrListOrMap && (((GrArgumentList)argumentList).getNamedArguments().length > 0 || ((GrArgumentList)argumentList).getExpressionArgumentIndex((GrListOrMap)mapOrArgumentList) > 0)) {
                return Collections.emptyMap();
            }
            if (argumentList.getParent() instanceof GrCall) {
                return GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders((GrCall)argumentList.getParent(), null, true);
            }
        }
        return Collections.emptyMap();
    }
}

