/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.gradle.initialization.BuildCancellationToken;

public class DefaultBuildCancellationToken
implements BuildCancellationToken {
    private final Object lock = new Object();
    private boolean cancelled;
    private Queue<Runnable> callbacks = new LinkedList<Runnable>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancellationRequested() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCallback(Runnable cancellationHandler) {
        boolean returnValue;
        Object object = this.lock;
        synchronized (object) {
            returnValue = this.cancelled;
            if (!this.cancelled) {
                this.callbacks.add(cancellationHandler);
            }
        }
        if (returnValue) {
            cancellationHandler.run();
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(Runnable cancellationHandler) {
        Object object = this.lock;
        synchronized (object) {
            this.callbacks.remove(cancellationHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancel() {
        ArrayList<Runnable> toCall = new ArrayList<Runnable>();
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            Runnable runnable = this.callbacks.poll();
            while (runnable != null) {
                toCall.add(runnable);
                runnable = this.callbacks.poll();
            }
        }
        Exception failure = null;
        for (Runnable callback : toCall) {
            try {
                callback.run();
            }
            catch (Exception ex) {
                if (failure != null) {
                    Throwable lastEx = ex;
                    while (lastEx.getCause() != null) {
                        lastEx = lastEx.getCause();
                    }
                    lastEx.initCause(failure);
                }
                failure = ex;
            }
        }
        if (failure != null) {
            throw new RuntimeException(failure);
        }
    }
}

