/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JLabel myProjectFormatLabel;
    private JComboBox myProjectFormatComboBox;
    private ProjectFormatPanel myProjectFormatPanel;
    private JCheckBox mySeparateModulesDirCheckBox;
    private TextFieldWithBrowseButton mySeparateModulesDirChooser;
    private JCheckBox myImportAutomaticallyBox;
    private JCheckBox myCreateModulesForAggregators;
    private JCheckBox myCreateGroupsCheckBox;
    private JComboBox myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myKeepSourceFoldersCheckBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;
    private JPanel myAdditionalSettingsPanel;
    private JComboBox myGeneratedSourcesComboBox;
    private JCheckBox myExcludeTargetFolderCheckBox;
    private JTextField myDependencyTypes;

    public MavenImportingSettingsForm(boolean isImportStep, boolean isCreatingNewProject) {
        this.$$$setupUI$$$();
        this.mySearchRecursivelyCheckBox.setVisible(isImportStep);
        this.myProjectFormatLabel.setVisible(isImportStep && isCreatingNewProject);
        this.myProjectFormatComboBox.setVisible(isImportStep && isCreatingNewProject);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.updateControls();
            }
        };
        this.mySeparateModulesDirCheckBox.addActionListener(listener);
        this.mySeparateModulesDirChooser.addBrowseFolderListener(ProjectBundle.message("maven.import.title.module.dir", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
        this.myGeneratedSourcesComboBox.setModel(new EnumComboBoxModel(MavenImportingSettings.GeneratedSourcesFolder.class));
        this.myGeneratedSourcesComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof MavenImportingSettings.GeneratedSourcesFolder) {
                    this.setText(((MavenImportingSettings.GeneratedSourcesFolder)((Object)value)).title);
                }
            }
        });
        LabelTextReplacingUtil.replaceText((JComponent)this.myPanel);
    }

    private void createUIComponents() {
        this.myProjectFormatPanel = new ProjectFormatPanel();
        this.myProjectFormatComboBox = this.myProjectFormatPanel.getStorageFormatComboBox();
    }

    private void updateControls() {
        boolean useSeparateDir = this.mySeparateModulesDirCheckBox.isSelected();
        this.mySeparateModulesDirChooser.setEnabled(useSeparateDir);
        if (useSeparateDir && StringUtil.isEmptyOrSpaces((String)this.mySeparateModulesDirChooser.getText())) {
            this.mySeparateModulesDirChooser.setText(FileUtil.toSystemDependentName((String)this.getDefaultModuleDir()));
        }
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(MavenImportingSettings data) {
        data.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        data.setDedicatedModuleDir(this.mySeparateModulesDirCheckBox.isSelected() ? this.mySeparateModulesDirChooser.getText() : "");
        data.setImportAutomatically(this.myImportAutomaticallyBox.isSelected());
        data.setCreateModulesForAggregators(this.myCreateModulesForAggregators.isSelected());
        data.setCreateModuleGroups(this.myCreateGroupsCheckBox.isSelected());
        data.setKeepSourceFolders(this.myKeepSourceFoldersCheckBox.isSelected());
        data.setExcludeTargetFolder(this.myExcludeTargetFolderCheckBox.isSelected());
        data.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data.setGeneratedSourcesFolder((MavenImportingSettings.GeneratedSourcesFolder)((Object)this.myGeneratedSourcesComboBox.getSelectedItem()));
        data.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
        data.setDependencyTypes(this.myDependencyTypes.getText());
    }

    public void setData(MavenImportingSettings data) {
        this.mySearchRecursivelyCheckBox.setSelected(data.isLookForNested());
        this.mySeparateModulesDirCheckBox.setSelected(!StringUtil.isEmptyOrSpaces((String)data.getDedicatedModuleDir()));
        this.mySeparateModulesDirChooser.setText(data.getDedicatedModuleDir());
        this.myImportAutomaticallyBox.setSelected(data.isImportAutomatically());
        this.myCreateModulesForAggregators.setSelected(data.isCreateModulesForAggregators());
        this.myCreateGroupsCheckBox.setSelected(data.isCreateModuleGroups());
        this.myKeepSourceFoldersCheckBox.setSelected(data.isKeepSourceFolders());
        this.myExcludeTargetFolderCheckBox.setSelected(data.isExcludeTargetFolder());
        this.myUseMavenOutputCheckBox.setSelected(data.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data.getUpdateFoldersOnImportPhase());
        this.myGeneratedSourcesComboBox.setSelectedItem((Object)data.getGeneratedSourcesFolder());
        this.myDownloadSourcesCheckBox.setSelected(data.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data.isDownloadDocsAutomatically());
        this.myDependencyTypes.setText(data.getDependencyTypes());
        this.updateControls();
    }

    public boolean isModified(MavenImportingSettings settings) {
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    public void updateData(WizardContext wizardContext) {
        this.myProjectFormatPanel.updateData(wizardContext);
    }

    public JPanel getAdditionalSettingsPanel() {
        return this.myAdditionalSettingsPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(19, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateModulesForAggregators = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Create $FULLNAME$ modules for aggregator projects (with 'pom' packaging)");
        jCheckBox10.setMnemonic('M');
        jCheckBox10.setDisplayedMnemonicIndex(18);
        jPanel2.add((Component)jCheckBox10, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateGroupsCheckBox = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Create module groups for multi-module Maven projects");
        jCheckBox9.setMnemonic('G');
        jCheckBox9.setDisplayedMnemonicIndex(14);
        jPanel2.add((Component)jCheckBox9, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySearchRecursivelyCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Search for projects recursively");
        jCheckBox8.setMnemonic('S');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Use Maven output directories");
        jCheckBox7.setMnemonic('O');
        jCheckBox7.setDisplayedMnemonicIndex(10);
        jCheckBox7.setToolTipText("IDEA compiler will use output directory defined in maven model (target/classes by default) ");
        jPanel2.add((Component)jCheckBox7, new GridConstraints(9, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("<html>IDEA needs to execute one of the listed phases in order to discover all source folders that are configured via Maven plugins.<br><b>Note</b> that all test-* phases firstly generate and compile production sources.</html>");
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel, new GridConstraints(13, 0, 1, 2, 0, 1, 3, 0, null, null, null, 3));
        this.myImportAutomaticallyBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Import Maven projects automatically");
        jCheckBox6.setMnemonic('A');
        jCheckBox6.setDisplayedMnemonicIndex(22);
        jCheckBox6.setToolTipText("Synchronize Maven project model and IDEA project model each time when pom.xml is changed  ");
        jPanel2.add((Component)jCheckBox6, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusable(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(14, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Automatically download:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Sources");
        jCheckBox5.setMnemonic('R');
        jCheckBox5.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)jCheckBox5, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Documentation");
        jCheckBox4.setMnemonic('D');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeepSourceFoldersCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Keep source and test folders on reimport");
        jCheckBox3.setMnemonic('F');
        jCheckBox3.setDisplayedMnemonicIndex(21);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(15, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(17, 0, 1, 2, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(14, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myProjectFormatLabel = jLabel = new JLabel();
        jLabel.setText("Project format:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = this.myProjectFormatComboBox;
        jPanel4.add((Component)jComboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySeparateModulesDirCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Keep project files in:");
        jCheckBox2.setMnemonic('K');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jCheckBox2.setToolTipText("Keep IDEA specified files like *.iml / .idea in selected directory. By default *.iml files are stored beside the pom.xml ");
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateModulesDirChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(18, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(12, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox2 = new JComboBox();
        jPanel6.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Phase to be used for folders update:");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(29);
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Generated sources folders:");
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel7.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myGeneratedSourcesComboBox = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExcludeTargetFolderCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Exclude build directory (%PROJECT_ROOT%/target)");
        jCheckBox.setToolTipText("If you select this options folder /target will be excluded from project during reimport. Compiler output (/target/classes and /target/test-classes) will be excluded anyway");
        jPanel2.add((Component)jCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setToolTipText(ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jLabel5.setText("Dependency types:");
        jPanel2.add((Component)jLabel5, new GridConstraints(15, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependencyTypes = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jTextField.setColumns(0);
        jPanel2.add((Component)jTextField, new GridConstraints(15, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel2, new GridConstraints(16, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel3.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

