/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementDescriptorWithCDataContent;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlTagRuleProvider;
import com.intellij.xml.actions.GenerateXmlTagAction;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;

public class XmlTagInsertHandler
implements InsertHandler<LookupElement> {
    public static final XmlTagInsertHandler INSTANCE = new XmlTagInsertHandler();

    public void handleInsert(InsertionContext context, LookupElement item) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int offset = editor.getCaretModel().getOffset();
        editor.getDocument().insertString(offset, (CharSequence)" ");
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement current = context.getFile().findElementAt(context.getStartOffset());
        editor.getDocument().deleteString(offset, offset + 1);
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)current, XmlTag.class, (boolean)true);
        if (tag == null) {
            return;
        }
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_TAG_END) == null && XmlUtil.getTokenOfType((PsiElement)tag, XmlTokenType.XML_EMPTY_ELEMENT_END) == null) {
            if (descriptor != null) {
                XmlTagInsertHandler.insertIncompleteTag(context.getCompletionChar(), editor, project, descriptor, tag);
            }
        } else if (context.getCompletionChar() == '\t') {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int caretOffset = editor.getCaretModel().getOffset();
            PsiElement otherTag = PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(caretOffset), XmlTag.class);
            XmlToken endTagStart = XmlUtil.getTokenOfType(otherTag, XmlTokenType.XML_END_TAG_START);
            if (endTagStart != null) {
                PsiElement sibling = endTagStart.getNextSibling();
                assert (sibling != null);
                ASTNode node = sibling.getNode();
                assert (node != null);
                if (node.getElementType() == XmlTokenType.XML_NAME) {
                    int sOffset = sibling.getTextRange().getStartOffset();
                    int eOffset = sibling.getTextRange().getEndOffset();
                    editor.getDocument().deleteString(sOffset, eOffset);
                    assert (otherTag != null);
                    editor.getDocument().insertString(sOffset, (CharSequence)((XmlTag)otherTag).getName());
                }
            }
            editor.getCaretModel().moveToOffset(caretOffset + 1);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
        }
        if (context.getCompletionChar() == ' ' && TemplateManager.getInstance(project).getActiveTemplate(editor) != null) {
            return;
        }
        TailType tailType = LookupItem.handleCompletionChar(editor, item, context.getCompletionChar());
        tailType.processTail(editor, editor.getCaretModel().getOffset());
    }

    private static void insertIncompleteTag(char completionChar, final Editor editor, final Project project, XmlElementDescriptor descriptor, XmlTag tag) {
        TemplateManager templateManager = TemplateManager.getInstance(project);
        Template template = templateManager.createTemplate("", "");
        template.setToIndent(true);
        PsiFile containingFile = tag.getContainingFile();
        boolean htmlCode = HtmlUtil.hasHtml(containingFile);
        template.setToReformat(!htmlCode);
        StringBuilder indirectRequiredAttrs = XmlTagInsertHandler.addRequiredAttributes(descriptor, tag, template, containingFile);
        final boolean chooseAttributeName = XmlTagInsertHandler.addTail(completionChar, descriptor, htmlCode, tag, template, indirectRequiredAttrs);
        templateManager.startTemplate(editor, template, new TemplateEditingAdapter(){
            private RangeMarker myAttrValueMarker;

            @Override
            public void waitingForInput(Template template) {
                int offset = editor.getCaretModel().getOffset();
                this.myAttrValueMarker = editor.getDocument().createRangeMarker(offset + 1, offset + 4);
            }

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                char c;
                final int offset = editor.getCaretModel().getOffset();
                if (chooseAttributeName && offset >= 3 && ((c = editor.getDocument().getCharsSequence().charAt(offset - 3)) == '/' || c == ' ' && brokenOff)) {
                    new WriteCommandAction.Simple(project, new PsiFile[0]){

                        protected void run() throws Throwable {
                            editor.getDocument().replaceString(offset - 2, offset + 1, (CharSequence)">");
                        }
                    }.execute();
                }
            }

            @Override
            public void templateCancelled(Template template) {
                if (this.myAttrValueMarker == null) {
                    return;
                }
                UndoManager manager = UndoManager.getInstance((Project)project);
                if (manager.isUndoInProgress() || manager.isRedoInProgress()) {
                    return;
                }
                if (chooseAttributeName && this.myAttrValueMarker.isValid()) {
                    final int startOffset = this.myAttrValueMarker.getStartOffset();
                    final int endOffset = this.myAttrValueMarker.getEndOffset();
                    new WriteCommandAction.Simple(project, new PsiFile[0]){

                        protected void run() throws Throwable {
                            editor.getDocument().replaceString(startOffset, endOffset, (CharSequence)">");
                        }
                    }.execute();
                }
            }
        });
    }

    @Nullable
    private static StringBuilder addRequiredAttributes(XmlElementDescriptor descriptor, @Nullable XmlTag tag, Template template, PsiFile containingFile) {
        InspectionProfile profile;
        XmlEntitiesInspection inspection;
        boolean htmlCode = HtmlUtil.hasHtml(containingFile);
        Set notRequiredAttributes = Collections.emptySet();
        if (tag instanceof HtmlTag && (inspection = (XmlEntitiesInspection)(profile = InspectionProjectProfileManager.getInstance(tag.getProject()).getInspectionProfile()).getUnwrappedTool("RequiredAttributes", (PsiElement)tag)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inspection.getAdditionalEntries());
            notRequiredAttributes = new HashSet();
            while (tokenizer.hasMoreElements()) {
                notRequiredAttributes.add(tokenizer.nextToken());
            }
        }
        XmlAttributeDescriptor[] attributes = descriptor.getAttributesDescriptors(tag);
        StringBuilder indirectRequiredAttrs = null;
        if (WebEditorOptions.getInstance().isAutomaticallyInsertRequiredAttributes()) {
            XmlExtension extension = XmlExtension.getExtension(containingFile);
            for (XmlAttributeDescriptor attributeDecl : attributes) {
                String attributeName = attributeDecl.getName((PsiElement)tag);
                if (attributeDecl.isRequired() && (tag == null || tag.getAttributeValue(attributeName) == null)) {
                    if (notRequiredAttributes.contains(attributeName)) continue;
                    if (!extension.isIndirectSyntax(attributeDecl)) {
                        template.addTextSegment(" " + attributeName + "=\"");
                        template.addVariable(new MacroCallNode(new CompleteMacro()), true);
                        template.addTextSegment("\"");
                        continue;
                    }
                    if (indirectRequiredAttrs == null) {
                        indirectRequiredAttrs = new StringBuilder();
                    }
                    indirectRequiredAttrs.append("\n<jsp:attribute name=\"").append(attributeName).append("\"></jsp:attribute>\n");
                    continue;
                }
                if (!attributeDecl.isRequired() || !attributeDecl.isFixed() || attributeDecl.getDefaultValue() == null || htmlCode) continue;
                template.addTextSegment(" " + attributeName + "=\"" + attributeDecl.getDefaultValue() + "\"");
            }
        }
        return indirectRequiredAttrs;
    }

    protected static boolean addTail(char completionChar, XmlElementDescriptor descriptor, boolean isHtmlCode, XmlTag tag, Template template, StringBuilder indirectRequiredAttrs) {
        if (completionChar == '>' || completionChar == '/' && indirectRequiredAttrs != null) {
            String name;
            XmlElementDescriptorWithCDataContent cDataContainer;
            template.addTextSegment(">");
            boolean toInsertCDataEnd = false;
            if (descriptor instanceof XmlElementDescriptorWithCDataContent && (cDataContainer = (XmlElementDescriptorWithCDataContent)descriptor).requiresCdataBracesInContext(tag)) {
                template.addTextSegment("<![CDATA[\n");
                toInsertCDataEnd = true;
            }
            if (indirectRequiredAttrs != null) {
                template.addTextSegment(indirectRequiredAttrs.toString());
            }
            template.addEndVariable();
            if (toInsertCDataEnd) {
                template.addTextSegment("\n]]>");
            }
            if (!(tag instanceof HtmlTag && HtmlUtil.isSingleHtmlTag(tag.getName()) || tag.getAttributes().length != 0 || !WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() || (name = descriptor.getName((PsiElement)tag)) == null)) {
                template.addTextSegment("</");
                template.addTextSegment(name);
                template.addTextSegment(">");
            }
        } else if (completionChar == '/') {
            template.addTextSegment("/>");
        } else if (completionChar == ' ' && template.getSegmentsCount() == 0) {
            if (WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && (descriptor.getAttributesDescriptors(tag).length > 0 || XmlTagInsertHandler.isTagFromHtml(tag) && !HtmlUtil.isTagWithoutAttributes(tag.getName()))) {
                XmlTagInsertHandler.completeAttribute(template);
                return true;
            }
        } else if (completionChar == '\u0000' || completionChar == '\n' || completionChar == '\t') {
            if (WebEditorOptions.getInstance().isAutomaticallyInsertClosingTag() && isHtmlCode && HtmlUtil.isSingleHtmlTag(tag.getName())) {
                template.addTextSegment(HtmlUtil.isHtmlTag(tag) ? ">" : "/>");
            } else {
                if (XmlTagInsertHandler.needAlLeastOneAttribute(tag) && WebEditorOptions.getInstance().isAutomaticallyStartAttribute() && tag.getAttributes().length == 0 && template.getSegmentsCount() == 0) {
                    XmlTagInsertHandler.completeAttribute(template);
                    return true;
                }
                XmlTagInsertHandler.completeTagTail(template, descriptor, tag.getContainingFile(), tag, true);
            }
        }
        return false;
    }

    private static void completeAttribute(Template template) {
        template.addTextSegment(" ");
        template.addVariable(new MacroCallNode(new CompleteMacro()), true);
        template.addTextSegment("=\"");
        template.addEndVariable();
        template.addTextSegment("\"");
    }

    private static boolean needAlLeastOneAttribute(XmlTag tag) {
        for (XmlTagRuleProvider ruleProvider : (XmlTagRuleProvider[])XmlTagRuleProvider.EP_NAME.getExtensions()) {
            for (XmlTagRuleProvider.Rule rule : ruleProvider.getTagRule(tag)) {
                if (!rule.needAtLeastOneAttribute(tag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean addRequiredSubTags(Template template, XmlElementDescriptor descriptor, PsiFile file, XmlTag context) {
        if (!WebEditorOptions.getInstance().isAutomaticallyInsertRequiredSubTags()) {
            return false;
        }
        List<XmlElementDescriptor> requiredSubTags = GenerateXmlTagAction.getRequiredSubTags(descriptor);
        if (!requiredSubTags.isEmpty()) {
            template.addTextSegment(">");
            template.setToReformat(true);
        }
        for (XmlElementDescriptor subTag : requiredSubTags) {
            String prefixByNamespace;
            if (subTag == null) {
                template.addTextSegment("<");
                template.addVariable(new MacroCallNode(new CompleteSmartMacro()), true);
                continue;
            }
            String qname = subTag.getName();
            if (subTag instanceof XmlElementDescriptorImpl && StringUtil.isNotEmpty((String)(prefixByNamespace = context.getPrefixByNamespace(((XmlElementDescriptorImpl)subTag).getNamespace())))) {
                qname = prefixByNamespace + ":" + subTag.getName();
            }
            template.addTextSegment("<" + qname);
            XmlTagInsertHandler.addRequiredAttributes(subTag, null, template, file);
            XmlTagInsertHandler.completeTagTail(template, subTag, file, context, false);
        }
        if (!requiredSubTags.isEmpty()) {
            XmlTagInsertHandler.addTagEnd(template, descriptor, context);
        }
        return !requiredSubTags.isEmpty();
    }

    private static void completeTagTail(Template template, XmlElementDescriptor descriptor, PsiFile file, XmlTag context, boolean firstLevel) {
        boolean completeIt = !firstLevel || descriptor.getAttributesDescriptors(null).length == 0;
        switch (descriptor.getContentType()) {
            case -1: {
                return;
            }
            case 0: {
                if (!completeIt) break;
                template.addTextSegment("/>");
                break;
            }
            case 3: {
                if (!completeIt) break;
                template.addTextSegment(">");
                if (firstLevel) {
                    template.addEndVariable();
                } else {
                    template.addVariable(new MacroCallNode(new CompleteMacro()), true);
                }
                XmlTagInsertHandler.addTagEnd(template, descriptor, context);
                break;
            }
            default: {
                if (XmlTagInsertHandler.addRequiredSubTags(template, descriptor, file, context) || !completeIt) break;
                template.addTextSegment(">");
                template.addEndVariable();
                XmlTagInsertHandler.addTagEnd(template, descriptor, context);
            }
        }
    }

    private static void addTagEnd(Template template, XmlElementDescriptor descriptor, XmlTag context) {
        template.addTextSegment("</" + descriptor.getName((PsiElement)context) + ">");
    }

    private static boolean isTagFromHtml(XmlTag tag) {
        String ns = tag.getNamespace();
        return "http://www.w3.org/1999/xhtml".equals(ns) || "http://www.w3.org/1999/html".equals(ns);
    }
}

