/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

abstract class ThreadLocalAnnotatorMap<T, KeyT extends UserDataHolder> {
    private volatile int version;
    private final ThreadLocal<Pair<Integer, Map<KeyT, List<T>>>> CACHE = new ThreadLocal<Pair<Integer, Map<KeyT, List<T>>>>(){

        @Override
        protected Pair<Integer, Map<KeyT, List<T>>> initialValue() {
            return Pair.create((Object)ThreadLocalAnnotatorMap.this.version, (Object)new THashMap());
        }
    };

    ThreadLocalAnnotatorMap() {
    }

    @NotNull
    public abstract Collection<T> initialValue(@NotNull KeyT var1);

    @NotNull
    private List<T> cloneTemplates(@NotNull Collection<T> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        ArrayList<Object> result = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (T template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new ConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(container);
            result.add(clone);
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        return arrayList;
    }

    @NotNull
    public List<T> get(@NotNull KeyT key) {
        Map map;
        List<T> cached;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        Pair<Integer, Map<KeyT, List<T>>> pair = this.CACHE.get();
        Integer mapVersion = (Integer)pair.getFirst();
        if (this.version != mapVersion) {
            this.CACHE.remove();
            pair = this.CACHE.get();
        }
        if ((cached = (List<T>)(map = (Map)pair.getSecond()).get(key)) == null) {
            Collection<T> templates = this.initialValue(key);
            cached = this.cloneTemplates(templates);
            map.put(key, cached);
        }
        List<T> list = cached;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        return list;
    }

    public void clear() {
        ++this.version;
    }
}

