/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class TopmostExpressionSelector
implements PostfixTemplateExpressionSelector {
    @NotNull
    private final Condition<PsiElement> myCondition;

    public TopmostExpressionSelector(@NotNull Condition<PsiElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "<init>"));
        }
        this.myCondition = condition;
    }

    @Override
    public boolean hasExpression(@NotNull PostfixTemplateWithExpressionSelector template, @NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "hasExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "hasExpression"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyDocument", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "hasExpression"));
        }
        PsiElement topmostExpression = template.getPsiInfo().getTopmostExpression(context);
        return topmostExpression != null && this.myCondition.value((Object)topmostExpression);
    }

    @Override
    public void expandTemplate(@NotNull PostfixTemplateWithExpressionSelector template, @NotNull PsiElement context, @NotNull Editor editor) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "expandTemplate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "expandTemplate"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/postfix/templates/TopmostExpressionSelector", "expandTemplate"));
        }
        PostfixTemplatePsiInfo info = template.getPsiInfo();
        PsiElement expression = info.getTopmostExpression(context);
        if (expression == null) {
            return;
        }
        template.expandForChooseExpression(expression, editor);
    }
}

