/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.DeleteThrowsFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateThrowsInspection
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.duplicate.throws.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicateThrows" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "getShortName"));
        }
        return "DuplicateThrows";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.duplicate.throws.ignore.subclassing.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "ignoreSubclassing");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    PsiClassType type = types[i];
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type.equals((Object)otherType)) {
                            problem = InspectionsBundle.message((String)"inspection.duplicate.throws.problem", (Object[])new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            if (otherType.isAssignableFrom((PsiType)type)) {
                                problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{otherType.getCanonicalText()});
                            } else if (type.isAssignableFrom((PsiType)otherType)) {
                                problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{type.getCanonicalText()});
                                ref = refs[j];
                                type = otherType;
                            }
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteThrowsFix(method, type)});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicateThrows/DuplicateThrowsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

