/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    private final DebugProcessImpl myDebugProcess;
    private final VirtualMachine myVirtualMachine;
    private int myTimeStamp;
    private int myPausePressedCount;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> myObjectReferenceProxies;
    @NotNull
    private Map<ThreadReference, ThreadReferenceProxyImpl> myAllThreads;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> myThreadGroups;
    private boolean myAllThreadsDirty;
    private List<ReferenceType> myAllClasses;
    private Map<ReferenceType, List<ReferenceType>> myNestedClassesCache;
    public Throwable mySuspendLogger;
    private final boolean myVersionHigher_15;
    private final boolean myVersionHigher_14;
    private final Capability myWatchFielsModification;
    private final Capability myWatchFieldAccess;
    private final Capability myIsJ2ME;
    private final Capability myGetBytecodes;
    private final Capability myGetSyntheticAttribute;
    private final Capability myGetOwnedMonitorInfo;
    private final Capability myGetMonitorFrameInfo;
    private final Capability myGetCurrentContendedMonitor;
    private final Capability myGetMonitorInfo;
    private final Capability myUseInstanceFilters;
    private final Capability myRedefineClasses;
    private final Capability myAddMethod;
    private final Capability myUnrestrictedlyRedefineClasses;
    private final Capability myPopFrames;
    private final Capability myCanGetInstanceInfo;
    private final Capability myGetSourceDebugExtension;
    private final Capability myRequestVMDeathEvent;
    private final Capability myGetMethodReturnValues;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcess, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualMachine", "com/intellij/debugger/jdi/VirtualMachineProxyImpl", "<init>"));
        }
        this.myTimeStamp = 0;
        this.myPausePressedCount = 0;
        this.myObjectReferenceProxies = new HashMap();
        this.myAllThreads = new HashMap();
        this.myThreadGroups = new HashMap();
        this.myAllThreadsDirty = true;
        this.myNestedClassesCache = new HashMap();
        this.mySuspendLogger = new Throwable();
        this.myWatchFielsModification = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldModification();
            }
        };
        this.myWatchFieldAccess = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canWatchFieldAccess();
            }
        };
        this.myIsJ2ME = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.myGetBytecodes = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetBytecodes();
            }
        };
        this.myGetSyntheticAttribute = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetSyntheticAttribute();
            }
        };
        this.myGetOwnedMonitorInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetOwnedMonitorInfo();
            }
        };
        this.myGetMonitorFrameInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorFrameInfo();
            }
        };
        this.myGetCurrentContendedMonitor = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetCurrentContendedMonitor();
            }
        };
        this.myGetMonitorInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVirtualMachine.canGetMonitorInfo();
            }
        };
        this.myUseInstanceFilters = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUseInstanceFilters();
            }
        };
        this.myRedefineClasses = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRedefineClasses();
            }
        };
        this.myAddMethod = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canAddMethod();
            }
        };
        this.myUnrestrictedlyRedefineClasses = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canUnrestrictedlyRedefineClasses();
            }
        };
        this.myPopFrames = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canPopFrames();
            }
        };
        this.myCanGetInstanceInfo = new Capability(){

            @Override
            protected boolean calcValue() {
                if (!VirtualMachineProxyImpl.this.myVersionHigher_15) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
                }
                catch (NoSuchMethodException ignored) {
                }
                catch (IllegalAccessException e) {
                    LOG.error((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOG.error((Throwable)e);
                }
                return false;
            }
        };
        this.myGetSourceDebugExtension = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canGetSourceDebugExtension();
            }
        };
        this.myRequestVMDeathEvent = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.myVersionHigher_14 && VirtualMachineProxyImpl.this.myVirtualMachine.canRequestVMDeathEvent();
            }
        };
        this.myGetMethodReturnValues = new Capability(){

            @Override
            protected boolean calcValue() {
                if (VirtualMachineProxyImpl.this.myVersionHigher_15) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean rv = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.myVirtualMachine, new Object[0]);
                        return rv;
                    }
                    catch (NoSuchMethodException ignored) {
                    }
                    catch (IllegalAccessException ignored) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.myVirtualMachine = virtualMachine;
        this.myDebugProcess = debugProcess;
        this.myVersionHigher_15 = this.versionHigher("1.5");
        this.myVersionHigher_14 = this.myVersionHigher_15 || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        try {
            virtualMachine.allClasses();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        List<ThreadGroupReference> groups = virtualMachine.topLevelThreadGroups();
        for (ThreadGroupReference threadGroupReference : groups) {
            this.threadGroupCreated(threadGroupReference);
        }
    }

    public VirtualMachine getVirtualMachine() {
        return this.myVirtualMachine;
    }

    public List<ReferenceType> classesByName(String s) {
        return this.myVirtualMachine.classesByName(s);
    }

    public List<ReferenceType> nestedTypes(ReferenceType refType) {
        List<Object> nestedTypes = this.myNestedClassesCache.get(refType);
        if (nestedTypes == null) {
            List<Object> list = Collections.emptyList();
            try {
                list = refType.nestedTypes();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            if (!list.isEmpty()) {
                HashSet<ReferenceType> candidates = new HashSet<ReferenceType>();
                ClassLoaderReference outerLoader = refType.classLoader();
                for (ReferenceType referenceType : list) {
                    try {
                        if (!(outerLoader == null ? referenceType.classLoader() == null : outerLoader.equals(referenceType.classLoader()))) continue;
                        candidates.add(referenceType);
                    }
                    catch (ObjectCollectedException ignored) {}
                }
                if (!candidates.isEmpty()) {
                    HashSet<ReferenceType> nested2 = new HashSet<ReferenceType>();
                    for (ReferenceType candidate : candidates) {
                        nested2.addAll(this.nestedTypes(candidate));
                    }
                    candidates.removeAll(nested2);
                }
                nestedTypes = candidates.isEmpty() ? Collections.emptyList() : new ArrayList(candidates);
            } else {
                nestedTypes = Collections.emptyList();
            }
            this.myNestedClassesCache.put(refType, nestedTypes);
        }
        return nestedTypes;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> allClasses = this.myAllClasses;
        if (allClasses == null) {
            this.myAllClasses = allClasses = this.myVirtualMachine.allClasses();
        }
        return allClasses;
    }

    public String toString() {
        return this.myVirtualMachine.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.myVirtualMachine.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myAllThreadsDirty) {
            this.myAllThreadsDirty = false;
            List<ThreadReference> currentThreads = this.myVirtualMachine.allThreads();
            HashMap result = new HashMap();
            for (ThreadReference threadReference : currentThreads) {
                ThreadReferenceProxyImpl proxy = this.myAllThreads.get(threadReference);
                if (proxy == null) {
                    proxy = new ThreadReferenceProxyImpl(this, threadReference);
                }
                result.put(threadReference, proxy);
            }
            this.myAllThreads = result;
        }
        return this.myAllThreads.values();
    }

    public void threadStarted(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Map<ThreadReference, ThreadReferenceProxyImpl> allThreads = this.myAllThreads;
        if (!allThreads.containsKey(thread)) {
            allThreads.put(thread, new ThreadReferenceProxyImpl(this, thread));
        }
    }

    public void threadStopped(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myAllThreads.remove(thread);
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.myPausePressedCount;
        this.myVirtualMachine.suspend();
        this.clearCaches();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myPausePressedCount > 0) {
            --this.myPausePressedCount;
        }
        this.clearCaches();
        if (LOG.isDebugEnabled()) {
            LOG.debug("before resume VM");
        }
        try {
            this.myVirtualMachine.resume();
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("VM resumed");
        }
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        List<ThreadGroupReference> list = this.getVirtualMachine().topLevelThreadGroups();
        ArrayList<ThreadGroupReferenceProxyImpl> result = new ArrayList<ThreadGroupReferenceProxyImpl>(list.size());
        for (ThreadGroupReference threadGroup : list) {
            result.add(this.getThreadGroupReferenceProxy(threadGroup));
        }
        return result;
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl proxy = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.myThreadGroups.put(threadGroupReference, proxy);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.isJ2ME(this.getVirtualMachine());
    }

    private static boolean isJ2ME(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myThreadGroups.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.myVirtualMachine.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.myVirtualMachine.eventRequestManager();
    }

    public VoidValue mirrorOf() throws EvaluateException {
        return this.myVirtualMachine.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public ByteValue mirrorOf(byte b) {
        return this.myVirtualMachine.mirrorOf(b);
    }

    public CharValue mirrorOf(char c) {
        return this.myVirtualMachine.mirrorOf(c);
    }

    public ShortValue mirrorOf(short i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public IntegerValue mirrorOf(int i) {
        return this.myVirtualMachine.mirrorOf(i);
    }

    public LongValue mirrorOf(long l) {
        return this.myVirtualMachine.mirrorOf(l);
    }

    public FloatValue mirrorOf(float v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public DoubleValue mirrorOf(double v) {
        return this.myVirtualMachine.mirrorOf(v);
    }

    public StringReference mirrorOf(String s) {
        return this.myVirtualMachine.mirrorOf(s);
    }

    public Process process() {
        return this.myVirtualMachine.process();
    }

    public void dispose() {
        this.myVirtualMachine.dispose();
    }

    public void exit(int i) {
        this.myVirtualMachine.exit(i);
    }

    public boolean canWatchFieldModification() {
        return this.myWatchFielsModification.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.myWatchFieldAccess.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.myIsJ2ME.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.myGetBytecodes.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.myGetSyntheticAttribute.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.myGetOwnedMonitorInfo.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.myGetMonitorFrameInfo.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.myGetCurrentContendedMonitor.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.myGetMonitorInfo.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.myUseInstanceFilters.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.myRedefineClasses.isAvailable();
    }

    public boolean canAddMethod() {
        return this.myAddMethod.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.myUnrestrictedlyRedefineClasses.isAvailable();
    }

    public boolean canPopFrames() {
        return this.myPopFrames.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.myCanGetInstanceInfo.isAvailable();
    }

    public final boolean versionHigher(String version) {
        return this.myVirtualMachine.version().compareTo(version) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.myGetSourceDebugExtension.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.myRequestVMDeathEvent.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.myGetMethodReturnValues.isAvailable();
    }

    public String getDefaultStratum() {
        return this.myVersionHigher_14 ? this.myVirtualMachine.getDefaultStratum() : null;
    }

    public String description() {
        return this.myVirtualMachine.description();
    }

    public String version() {
        return this.myVirtualMachine.version();
    }

    public String name() {
        return this.myVirtualMachine.name();
    }

    public void setDebugTraceMode(int i) {
        this.myVirtualMachine.setDebugTraceMode(i);
    }

    public ThreadReferenceProxyImpl getThreadReferenceProxy(ThreadReference thread) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (thread == null) {
            return null;
        }
        ThreadReferenceProxyImpl proxy = this.myAllThreads.get(thread);
        if (proxy == null) {
            proxy = new ThreadReferenceProxyImpl(this, thread);
            this.myAllThreads.put(thread, proxy);
        }
        return proxy;
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference group) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (group == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl proxy = this.myThreadGroups.get(group);
        if (proxy == null && !this.myIsJ2ME.isAvailable()) {
            proxy = new ThreadGroupReferenceProxyImpl(this, group);
            this.myThreadGroups.put(group, proxy);
        }
        return proxy;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl proxy = this.myObjectReferenceProxies.get(objectReference);
            if (proxy == null) {
                proxy = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.myObjectReferenceProxies.put(objectReference, proxy);
            }
            return proxy;
        }
        return null;
    }

    public boolean equals(Object obj) {
        LOG.assertTrue(obj instanceof VirtualMachineProxyImpl);
        return this.myVirtualMachine.equals(((VirtualMachineProxyImpl)obj).getVirtualMachine());
    }

    public int hashCode() {
        return this.myVirtualMachine.hashCode();
    }

    public void clearCaches() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("VM cleared");
        }
        this.myAllClasses = null;
        if (!this.myNestedClassesCache.isEmpty()) {
            this.myNestedClassesCache = new HashMap(this.myNestedClassesCache.size());
        }
        ++this.myTimeStamp;
    }

    @Override
    public int getCurrentTime() {
        return this.myTimeStamp;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public static boolean isCollected(ObjectReference reference) {
        return !VirtualMachineProxyImpl.isJ2ME(reference.virtualMachine()) && reference.isCollected();
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.myPausePressedCount > 0;
    }

    public boolean isSuspended() {
        for (ThreadReferenceProxyImpl thread : this.allThreads()) {
            if (thread.getSuspendCount() == 0) continue;
            return true;
        }
        return false;
    }

    public void logThreads() {
        if (LOG.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl thread : this.allThreads()) {
                if (thread.isCollected()) continue;
                LOG.debug("suspends " + thread + " " + thread.getSuspendCount() + " " + thread.isSuspended());
            }
        }
    }

    private static abstract class Capability {
        private Boolean myValue = null;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.myValue == null) {
                try {
                    this.myValue = this.calcValue();
                }
                catch (VMDisconnectedException e) {
                    LOG.info((Throwable)e);
                    this.myValue = Boolean.FALSE;
                }
            }
            return this.myValue;
        }

        protected abstract boolean calcValue();
    }
}

