/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.DebuggerSessionTab;
import com.intellij.debugger.ui.impl.MainWatchPanel;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPanelsManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerPanelsManager");
    private final Project myProject;
    private final ExecutionManager myExecutionManager;

    public DebuggerPanelsManager(Project project, EditorColorsManager colorsManager, ExecutionManager executionManager) {
        this.myProject = project;
        this.myExecutionManager = executionManager;
    }

    private DebuggerStateManager getContextManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
    }

    @Deprecated
    @Nullable
    public RunContentDescriptor attachVirtualMachine(Executor executor, @NotNull ProgramRunner runner, @NotNull ExecutionEnvironment environment, RunProfileState state, RunContentDescriptor reuseContent, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/debugger/ui/DebuggerPanelsManager", "attachVirtualMachine"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/ui/DebuggerPanelsManager", "attachVirtualMachine"));
        }
        return this.attachVirtualMachine(new ExecutionEnvironmentBuilder(environment).executor(executor).runner(runner).contentToReuse(reuseContent).build(), state, remoteConnection, pollConnection);
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/debugger/ui/DebuggerPanelsManager", "attachVirtualMachine"));
        }
        return this.attachVirtualMachine(new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection));
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(DebugUIEnvironment environment) throws ExecutionException {
        DebugEnvironment modelEnvironment = environment.getEnvironment();
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            debuggerSession.dispose();
            return null;
        }
        if (modelEnvironment.isRemote()) {
            debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(modelEnvironment.getSessionName(), environment.getReuseContent(), new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/debugger/ui/DebuggerPanelsManager$1", "start"));
                }
                JavaDebugProcess javaDebugProcess = JavaDebugProcess.create(session, debuggerSession);
                if (javaDebugProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerPanelsManager$1", "start"));
                }
                return javaDebugProcess;
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    public void projectOpened() {
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/ui/DebuggerPanelsManager$2", "contentSelected"));
                }
                if (executor == DefaultDebugExecutor.getDebugExecutorInstance()) {
                    DebuggerSession session;
                    DebuggerSession debuggerSession = session = descriptor == null ? null : DebuggerPanelsManager.getSession(DebuggerPanelsManager.this.myProject, descriptor.getExecutionConsole());
                    if (session != null) {
                        DebuggerPanelsManager.this.getContextManager().setState(session.getContextManager().getContext(), session.getState(), 8, null);
                    } else {
                        DebuggerPanelsManager.this.getContextManager().setState(DebuggerContextImpl.EMPTY_CONTEXT, 6, 8, null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/debugger/ui/DebuggerPanelsManager$2", "contentRemoved"));
                }
            }
        });
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("DebuggerPanelsManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/DebuggerPanelsManager", "getComponentName"));
        }
        return "DebuggerPanelsManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public static DebuggerPanelsManager getInstance(Project project) {
        return (DebuggerPanelsManager)project.getComponent(DebuggerPanelsManager.class);
    }

    @Nullable
    public MainWatchPanel getWatchPanel() {
        DebuggerSessionTab sessionTab = this.getSessionTab();
        return sessionTab != null ? sessionTab.getWatchPanel() : null;
    }

    @Nullable
    public DebuggerSessionTab getSessionTab() {
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
        return this.getSessionTab(context.getDebuggerSession());
    }

    public void showFramePanel() {
        DebuggerSessionTab sessionTab = this.getSessionTab();
        if (sessionTab != null) {
            sessionTab.showFramePanel();
        }
    }

    public void toFront(DebuggerSession session) {
        DebuggerSessionTab sessionTab = this.getSessionTab(session);
        if (sessionTab != null) {
            sessionTab.toFront(true);
        }
    }

    private static DebuggerSession getSession(Project project, ExecutionConsole console) {
        XDebugProcess process;
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getDebugSession(console);
        if (session != null && (process = session.getDebugProcess()) instanceof JavaDebugProcess) {
            return ((JavaDebugProcess)process).getDebuggerSession();
        }
        return null;
    }

    @Nullable
    private DebuggerSessionTab getSessionTab(DebuggerSession session) {
        return null;
    }
}

