/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.treeHash.DuplocatorHashCallback");
    private TIntObjectHashMap<List<List<PsiFragment>>> myDuplicates = new TIntObjectHashMap();
    private final int myBound;
    private boolean myReadOnly = false;
    private final int myDiscardCost;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.myBound = bound;
        this.myDiscardCost = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.myReadOnly = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public void add(int hash, int cost, PsiFragment frag, NodeSpecificHasher visitor) {
        this.forceAdd(hash, cost, frag);
    }

    private void forceAdd(int hash, int cost, PsiFragment frag) {
        if (frag == null) {
            this.myDuplicates.put(hash, new ArrayList());
            return;
        }
        frag.setCost(cost);
        List fragments = (List)this.myDuplicates.get(hash);
        if (fragments == null) {
            if (!this.myReadOnly) {
                ArrayList list = new ArrayList();
                ArrayList<PsiFragment> listf = new ArrayList<PsiFragment>();
                listf.add(frag);
                list.add(listf);
                this.myDuplicates.put(hash, list);
            }
            return;
        }
        boolean found = false;
        PsiElement[] elements = frag.getElements();
        int discardCost = 0;
        if (this.myDiscardCost >= 0) {
            discardCost = this.myDiscardCost;
        } else {
            DuplocatorState state = DuplocatorUtil.getDuplocatorState(frag);
            if (state != null) {
                discardCost = state.getDiscardCost();
            }
        }
        Iterator i = fragments.iterator();
        while (i.hasNext() && !found) {
            List fi = (List)i.next();
            PsiFragment aFrag = (PsiFragment)fi.get(0);
            if (!aFrag.isEqual(elements, discardCost)) continue;
            boolean skip = false;
            Iterator frags = fi.iterator();
            while (frags.hasNext() && !skip) {
                skip = frag.intersectsWith((PsiFragment)frags.next());
                if (!skip) continue;
                frags.remove();
            }
            fi.add(frag);
            found = true;
        }
        if (!found) {
            ArrayList<PsiFragment> newFrags = new ArrayList<PsiFragment>();
            newFrags.add(frag);
            fragments.add(newFrags);
        }
    }

    @Override
    public void add(int hash, int cost, PsiFragment frag) {
        int bound;
        if (this.myBound >= 0) {
            bound = this.myBound;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            bound = duplocatorState.getLowerBound();
        }
        if (cost >= bound) {
            this.forceAdd(hash, cost, frag);
        }
    }

    public DupInfo getInfo() {
        final TObjectIntHashMap duplicateList = new TObjectIntHashMap();
        this.myDuplicates.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<List<List<PsiFragment>>>(){

            public boolean execute(int hash, List<List<PsiFragment>> listList) {
                for (List<PsiFragment> list : listList) {
                    int len = list.size();
                    if (len <= 1) continue;
                    PsiFragment[] filtered = new PsiFragment[len];
                    int idx = 0;
                    for (PsiFragment fragment : list) {
                        fragment.markDuplicate();
                        filtered[idx++] = fragment;
                    }
                    duplicateList.put((Object)filtered, hash);
                }
                return true;
            }
        });
        this.myDuplicates = null;
        TObjectIntIterator dups = duplicateList.iterator();
        while (dups.hasNext()) {
            dups.advance();
            PsiFragment[] fragments = (PsiFragment[])dups.key();
            LOG.assertTrue(fragments.length > 1);
            boolean nested = false;
            for (PsiFragment fragment : fragments) {
                if (!fragment.isNested()) continue;
                nested = true;
                break;
            }
            if (!nested) continue;
            dups.remove();
        }
        final Object[] duplicates = duplicateList.keys();
        Arrays.sort(duplicates, new Comparator<Object>(){

            @Override
            public int compare(Object x, Object y) {
                return ((PsiFragment[])y)[0].getCost() - ((PsiFragment[])x)[0].getCost();
            }
        });
        return new DupInfo(){
            private final TIntObjectHashMap<GroupNodeDescription> myPattern2Description = new TIntObjectHashMap();

            @Override
            public int getPatterns() {
                return duplicates.length;
            }

            @Override
            public int getPatternCost(int number) {
                return ((PsiFragment[])duplicates[number])[0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return ((PsiFragment[])duplicates[number]).length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return (PsiFragment[])duplicates[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] occs = this.getFragmentOccurences(pattern);
                UsageInfo[] infos = new UsageInfo[occs.length];
                for (int i = 0; i < infos.length; ++i) {
                    infos[i] = occs[i].getUsageInfo();
                }
                return infos;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.myPattern2Description.containsKey(pattern)) {
                    return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getFilesCount();
                }
                return this.cacheGroupNodeDescription(pattern).getFilesCount();
            }

            private GroupNodeDescription cacheGroupNodeDescription(int pattern) {
                PsiFragment[] occurencies;
                HashSet<PsiFile> files = new HashSet<PsiFile>();
                for (PsiFragment occurency : occurencies = this.getFragmentOccurences(pattern)) {
                    PsiFile file = occurency.getFile();
                    if (file == null) continue;
                    files.add(file);
                }
                int fileCount = files.size();
                PsiFile psiFile = occurencies[0].getFile();
                DuplicatesProfile profile = DuplicatesProfileCache.getProfile(this, pattern);
                String comment = profile != null ? profile.getComment(this, pattern) : "";
                GroupNodeDescription description = new GroupNodeDescription(fileCount, psiFile != null ? psiFile.getName() : "unknown", comment);
                this.myPattern2Description.put(pattern, (Object)description);
                return description;
            }

            @Override
            @Nullable
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getTitle();
                    }
                    return this.cacheGroupNodeDescription(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return ((GroupNodeDescription)this.myPattern2Description.get(pattern)).getComment();
                    }
                    return this.cacheGroupNodeDescription(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i) {
                return duplicateList.get((Object)((PsiFragment[])duplicates[i]));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String path, Project project) throws IOException {
        PrettyPrintWriter writer;
        int[] hashCodes = this.myDuplicates.keys();
        OutputStreamWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(path + File.separator + "fragments.xml");
            writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            for (int hash : hashCodes) {
                List dupList = (List)this.myDuplicates.get(hash);
                writer.startNode("hash");
                writer.addAttribute("val", String.valueOf(hash));
                for (List psiFragments : dupList) {
                    DuplocatorHashCallback.writeFragments(psiFragments, writer, project, false);
                }
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        fileWriter = null;
        try {
            fileWriter = new FileWriter(path + File.separator + "duplicates.xml");
            writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            DupInfo info = this.getInfo();
            int patterns = info.getPatterns();
            for (int i = 0; i < patterns; ++i) {
                writer.startNode("duplicate");
                writer.addAttribute("cost", String.valueOf(info.getPatternCost(i)));
                writer.addAttribute("hash", String.valueOf(info.getHash(i)));
                DuplocatorHashCallback.writeFragments(Arrays.asList(info.getFragmentOccurences(i)), writer, project, true);
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private static void writeFragments(List<PsiFragment> psiFragments, PrettyPrintWriter writer, Project project, boolean shouldWriteOffsets) {
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)project);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        for (PsiFragment fragment : psiFragments) {
            PsiFile psiFile = fragment.getFile();
            VirtualFile virtualFile = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) continue;
            writer.startNode("fragment");
            writer.addAttribute("file", macroManager.collapsePath(virtualFile.getUrl()));
            if (shouldWriteOffsets) {
                Document document = documentManager.getDocument(psiFile);
                LOG.assertTrue(document != null);
                int startOffset = fragment.getStartOffset();
                int line = document.getLineNumber(startOffset);
                writer.addAttribute("line", String.valueOf(line));
                int lineStartOffset = document.getLineStartOffset(line);
                if (StringUtil.isEmptyOrSpaces((String)document.getText().substring(lineStartOffset, startOffset))) {
                    startOffset = lineStartOffset;
                }
                writer.addAttribute("start", String.valueOf(startOffset));
                writer.addAttribute("end", String.valueOf(fragment.getEndOffset()));
                if (fragment.containsMultipleFragments()) {
                    int[][] offsets;
                    for (int[] offset : offsets = fragment.getOffsets()) {
                        writer.startNode("offset");
                        writer.addAttribute("start", String.valueOf(offset[0]));
                        writer.addAttribute("end", String.valueOf(offset[1]));
                        writer.endNode();
                    }
                }
            }
            writer.endNode();
        }
    }
}

