/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RestartAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FakeRerunAction
extends AnAction
implements DumbAware {
    static final List<RestartAction> registry = ContainerUtil.createLockFreeCopyOnWriteList();

    FakeRerunAction() {
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{environment.getRunProfile().getName()}));
            presentation.setIcon(ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment.getExecutor().getIcon());
            presentation.setEnabledAndVisible(this.isEnabled(event));
            return;
        }
        FakeRerunAction action = FakeRerunAction.findActualAction(event);
        presentation.setEnabled(action != null && action.isEnabled(event));
        presentation.setVisible(false);
    }

    public void actionPerformed(AnActionEvent event) {
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            ExecutionUtil.restart((ExecutionEnvironment)environment);
            return;
        }
        FakeRerunAction action = FakeRerunAction.findActualAction(event);
        if (action != null && action.isEnabled(event)) {
            action.actionPerformed(event);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(AnActionEvent event) {
        return (ExecutionEnvironment)event.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor = this.getDescriptor(event);
        ProcessHandler processHandler = descriptor == null ? null : descriptor.getProcessHandler();
        ExecutionEnvironment environment = this.getEnvironment(event);
        return environment != null && !ExecutorRegistry.getInstance().isStarting(environment) && (processHandler == null || !processHandler.isProcessTerminating());
    }

    @Nullable
    private JComponent getRunComponent(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/runners/FakeRerunAction", "getRunComponent"));
        }
        RunContentDescriptor descriptor = this.getDescriptor(event);
        return descriptor == null ? null : descriptor.getComponent();
    }

    @Nullable
    private static FakeRerunAction findActualAction(final @NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/runners/FakeRerunAction", "findActualAction"));
        }
        if (registry.isEmpty()) {
            return null;
        }
        ArrayList<RestartAction> candidates = new ArrayList<RestartAction>(registry);
        Collections.sort(candidates, new Comparator<FakeRerunAction>(){

            @Override
            public int compare(@NotNull FakeRerunAction action1, @NotNull FakeRerunAction action2) {
                Window window2;
                if (action1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action1", "com/intellij/execution/runners/FakeRerunAction$1", "compare"));
                }
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action2", "com/intellij/execution/runners/FakeRerunAction$1", "compare"));
                }
                boolean isActive1 = action1.isEnabled(event);
                if (isActive1 != action2.isEnabled(event)) {
                    return isActive1 ? -1 : 1;
                }
                JComponent component1 = action1.getRunComponent(event);
                JComponent component2 = action2.getRunComponent(event);
                Window window1 = component1 == null ? null : SwingUtilities.windowForComponent(component1);
                Window window = window2 = component2 == null ? null : SwingUtilities.windowForComponent(component2);
                if (window1 == null) {
                    return 1;
                }
                if (window2 == null) {
                    return -1;
                }
                boolean showing1 = component1.isShowing();
                boolean showing2 = component2.isShowing();
                if (showing1 && !showing2) {
                    return -1;
                }
                if (showing2 && !showing1) {
                    return 1;
                }
                return window1.isActive() ? -1 : 1;
            }
        });
        return (FakeRerunAction)((Object)candidates.get(0));
    }
}

