/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.util.PlatformModuleRendererFactory;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.awt.Color;
import java.awt.FontMetrics;
import java.io.File;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

class SearchEverywherePsiRenderer
extends PsiElementListCellRenderer<PsiElement> {
    private final JList myList;

    public SearchEverywherePsiRenderer(JList list) {
        this.myList = list;
    }

    @Override
    public String getElementText(PsiElement element) {
        return element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "";
    }

    @Override
    protected String getContainerText(PsiElement element, String name) {
        if (element instanceof PsiFileSystemItem) {
            VirtualFile virtualFile;
            PsiFileSystemItem parent = ((PsiFileSystemItem)element).getParent();
            PsiDirectory psiDirectory = parent instanceof PsiDirectory ? (PsiDirectory)parent : null;
            VirtualFile virtualFile2 = virtualFile = psiDirectory == null ? null : psiDirectory.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            String relativePath = this.getRelativePath(virtualFile, element.getProject());
            if (relativePath == null) {
                return "( " + File.separator + " )";
            }
            int width = this.myList.getWidth();
            if (width == 0) {
                width += 800;
            }
            String path = FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getOptimalTextForComponent(name, new File(relativePath), (JComponent)this, width - this.myRightComponentWidth - 16 - 10);
            return "(" + path + ")";
        }
        return this.getSymbolContainerText(name, element);
    }

    private String getSymbolContainerText(String name, PsiElement element) {
        boolean in;
        String text = SymbolPresentationUtil.getSymbolContainerText(element);
        if (this.myList.getWidth() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        if (text.startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        if (in = text.startsWith("in ")) {
            text = text.substring(3);
        }
        FontMetrics fm = this.myList.getFontMetrics(this.myList.getFont());
        int maxWidth = this.myList.getWidth() - fm.stringWidth(name) - 16 - this.myRightComponentWidth - 20;
        String left = "(" + (in ? "in " : " ");
        String right = ")";
        if (fm.stringWidth(left + text + right) < maxWidth) {
            return left + text + right;
        }
        LinkedList<String> parts = new LinkedList<String>(StringUtil.split((String)text, (String)"."));
        while (parts.size() > 1) {
            int index = parts.size() / 2 - 1;
            parts.remove(index);
            if (fm.stringWidth(StringUtil.join(parts, (String)".") + "...") >= maxWidth) continue;
            parts.add(index, index == 0 ? "..." : ".");
            return left + StringUtil.join(parts, (String)".") + right;
        }
        return left + "..." + right;
    }

    @Nullable
    String getRelativePath(VirtualFile virtualFile, Project project) {
        String projectHomeUrl;
        String url = virtualFile.getPresentableUrl();
        if (project == null) {
            return url;
        }
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(virtualFile);
        if (root != null) {
            return root.getName() + File.separatorChar + VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)root, (char)File.separatorChar);
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            String cont = url.substring(projectHomeUrl.length());
            if (cont.isEmpty()) {
                return null;
            }
            url = "..." + cont;
        }
        return url;
    }

    @Override
    protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value, int index, boolean selected, boolean hasFocus) {
        if (!(value instanceof NavigationItem)) {
            return false;
        }
        NavigationItem item = (NavigationItem)value;
        TextAttributes attributes = SearchEverywherePsiRenderer.getNavigationItemAttributes(item);
        SimpleTextAttributes nameAttributes = attributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes) : null;
        Color color = list.getForeground();
        if (nameAttributes == null) {
            nameAttributes = new SimpleTextAttributes(0, color);
        }
        renderer.append(item + " ", nameAttributes);
        ItemPresentation itemPresentation = item.getPresentation();
        assert (itemPresentation != null);
        renderer.setIcon(itemPresentation.getIcon(true));
        String locationString = itemPresentation.getLocationString();
        if (!StringUtil.isEmpty((String)locationString)) {
            renderer.append(locationString, new SimpleTextAttributes(0, (Color)JBColor.GRAY));
        }
        return true;
    }

    @Override
    protected DefaultListCellRenderer getRightCellRenderer(Object value) {
        DefaultListCellRenderer rightRenderer = super.getRightCellRenderer(value);
        if (rightRenderer instanceof PlatformModuleRendererFactory.PlatformModuleRenderer) {
            return null;
        }
        return rightRenderer;
    }

    @Override
    protected int getIconFlags() {
        return 2;
    }
}

