/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;

public class ShowStructureSettingsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        this.showDialog(project);
    }

    void showDialog(Project project) {
        if (Registry.is((String)"ide.new.project.settings")) {
            new SingleConfigurableEditor(project, (Configurable)ProjectStructureConfigurable.getInstance(project), "OptionsEditor"){

                @Nullable
                protected Border createContentPaneBorder() {
                    return new EmptyBorder(0, 0, 0, 0);
                }

                @Nullable
                protected JComponent createSouthPanel() {
                    JComponent panel = super.createSouthPanel();
                    assert (panel != null);
                    CustomLineBorder line = new CustomLineBorder((Color)new JBColor(Gray._153.withAlpha(128), Gray._100.withAlpha(128)), 1, 0, 0, 0);
                    panel.setBorder(new CompoundBorder((Border)line, new EmptyBorder(10, 5, 5, 5)));
                    return panel;
                }
            }.show();
        } else {
            ShowSettingsUtil.getInstance().editConfigurable(project, "OptionsEditor", (Configurable)ProjectStructureConfigurable.getInstance(project));
        }
    }
}

