/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.impl.ProjectUtil");

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        GeneralSettings.getInstance().setLastProjectCreationLocation(path.replace(File.separatorChar, '/'));
    }

    public static boolean closeAndDispose(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/impl/ProjectUtil", "closeAndDispose"));
        }
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    @Nullable
    public static Project openOrImport(@NotNull String path, Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor provider;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "openOrImport"));
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        virtualFile.refresh(false, false);
        ProjectOpenProcessor strong = ProjectOpenProcessor.getStrongImportProvider((VirtualFile)virtualFile);
        if (strong != null) {
            return strong.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        if (path.endsWith(".ipr") || virtualFile.isDirectory() && virtualFile.findChild(".idea") != null) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        if (virtualFile.isDirectory()) {
            for (VirtualFile child : virtualFile.getChildren()) {
                String childPath = child.getPath();
                if (!childPath.endsWith(".ipr")) continue;
                return ProjectUtil.openProject(childPath, projectToClose, forceOpenInNewFrame);
            }
        }
        if ((provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) != null) {
            final Project project = provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
            if (project != null) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ToolWindow toolWindow;
                        if (!project.isDisposed() && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
                            toolWindow.activate(null);
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
            return project;
        }
        return null;
    }

    @Nullable
    public static Project openProject(String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Project[] openProjects;
        File file = new File(path);
        if (!file.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        if (file.isDirectory() && !new File(file, ".idea").exists()) {
            String message = IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{new File(file, ".idea").getPath()});
            Messages.showErrorDialog((String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!ProjectUtil.isSameProject(path, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                Project toClose;
                Project project = toClose = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
                if (!ProjectUtil.closeAndDispose(toClose)) {
                    return null;
                }
            } else if (exitCode != 0) {
                return null;
            }
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        try {
            project = projectManager.loadAndOpenProject(path);
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidDataException e) {
            LOG.info((Throwable)e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return project;
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        if (msgKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgKey", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        if (titleKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleKey", "com/intellij/ide/impl/ProjectUtil", "confirmLoadingFromRemotePath"));
        }
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/ide/impl/ProjectUtil", "showYesNoDialog"));
        }
        if (titleKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleKey", "com/intellij/ide/impl/ProjectUtil", "showYesNoDialog"));
        }
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon = Messages.getWarningIcon();
        String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
        int answer = window == null ? Messages.showYesNoDialog((String)message, (String)title, (Icon)icon) : Messages.showYesNoDialog((Component)window, (String)message, (String)title, (Icon)icon);
        return answer == 0;
    }

    private static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ide/impl/ProjectUtil", "isRemotePath"));
        }
        return path.contains("//") || path.contains("\\\\");
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existingframe", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.newframe", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    private static boolean isSameProject(String path, Project p) {
        IProjectStore projectStore = ((ProjectEx)p).getStateStore();
        String toOpen = FileUtil.toSystemIndependentName((String)path);
        String existing = FileUtil.toSystemIndependentName((String)projectStore.getProjectFilePath());
        VirtualFile existingBaseDir = projectStore.getProjectBaseDir();
        if (existingBaseDir == null) {
            return false;
        }
        File openFile = new File(toOpen);
        if (openFile.isDirectory()) {
            return FileUtil.pathsEqual((String)toOpen, (String)existingBaseDir.getPath());
        }
        if (StorageScheme.DIRECTORY_BASED == projectStore.getStorageScheme()) {
            return FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)openFile.getParentFile().getPath()), (String)existingBaseDir.getPath());
        }
        return FileUtil.pathsEqual((String)toOpen, (String)existing);
    }

    public static void focusProjectWindow(final Project p, boolean executeIfAppInactive) {
        FocusCommand cmd = new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                JFrame f = WindowManager.getInstance().getFrame(p);
                if (f != null) {
                    f.toFront();
                }
                ActionCallback.Done done = new ActionCallback.Done();
                if (done == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/impl/ProjectUtil$2", "run"));
                }
                return done;
            }
        };
        if (executeIfAppInactive) {
            AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(p));
            cmd.run();
        } else {
            IdeFocusManager.getInstance((Project)p).requestFocus(cmd, true);
        }
    }

    public static String getBaseDir() {
        String lastProjectLocation = GeneralSettings.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        return userHome.replace('/', File.separatorChar) + File.separator + ApplicationNamesInfo.getInstance().getLowercaseProductName() + "Projects";
    }
}

