/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBTreeWithHintProvider;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectViewTree
extends JBTreeWithHintProvider {
    private final Project myProject;

    protected ProjectViewTree(Project project, TreeModel model) {
        super(model);
        this.myProject = project;
        NodeRenderer cellRenderer = new NodeRenderer(){

            protected void doPaint(Graphics2D g) {
                super.doPaint(g);
                this.setOpaque(false);
            }
        };
        cellRenderer.setOpaque(false);
        cellRenderer.setIconOpaque(false);
        this.setCellRenderer((TreeCellRenderer)cellRenderer);
        cellRenderer.setTransparentIconBackground(true);
    }

    public abstract DefaultMutableTreeNode getSelectedNode();

    public Project getProject() {
        return this.myProject;
    }

    public final int getToggleClickCount() {
        NodeDescriptor descriptor;
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof NodeDescriptor && !(descriptor = (NodeDescriptor)object).expandOnDoubleClick()) {
            return -1;
        }
        return super.getToggleClickCount();
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    public static boolean isFileColorsEnabledFor(JTree tree) {
        boolean enabled = FileColorManagerImpl._isEnabled() && FileColorManagerImpl._isEnabledForProjectView();
        boolean opaque = tree.isOpaque();
        if (enabled && opaque) {
            tree.setOpaque(false);
        } else if (!enabled && !opaque) {
            tree.setOpaque(true);
        }
        return enabled;
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        return ProjectViewTree.getColorForObject(object, this.getProject(), new NullableFunction<Object, PsiElement>(){

            public PsiElement fun(Object object) {
                Object element;
                if (object instanceof AbstractTreeNode && (element = ((AbstractTreeNode)object).getValue()) instanceof PsiElement) {
                    return (PsiElement)element;
                }
                return null;
            }
        });
    }

    @Nullable
    public static <T> Color getColorForObject(T object, Project project, @NotNull Function<T, PsiElement> converter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/ide/projectView/impl/ProjectViewTree", "getColorForObject"));
        }
        Color color = null;
        PsiElement psi = (PsiElement)converter.fun(object);
        if (psi != null) {
            if (!psi.isValid()) {
                return null;
            }
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psi);
            if (file != null) {
                color = FileColorManager.getInstance((Project)project).getFileColor(file);
            } else if (psi instanceof PsiDirectory) {
                color = FileColorManager.getInstance((Project)project).getFileColor(((PsiDirectory)psi).getVirtualFile());
            } else if (psi instanceof PsiDirectoryContainer) {
                PsiDirectory[] dirs;
                for (PsiDirectory dir : dirs = ((PsiDirectoryContainer)psi).getDirectories()) {
                    Color c = FileColorManager.getInstance((Project)project).getFileColor(dir.getVirtualFile());
                    if (c != null && color == null) {
                        color = c;
                        continue;
                    }
                    if (c == null) continue;
                    color = null;
                    break;
                }
            }
        }
        return color == null ? null : ColorUtil.softer(color);
    }
}

