/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentRoamingManager;
import com.intellij.openapi.components.impl.stores.ComponentVersionProvider;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.OldStreamProviderAdapter;
import com.intellij.openapi.components.impl.stores.StateStorageManagerImpl;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.components.store.StateStorageBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectLongHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlElementStorage
extends StateStorageBase {
    protected static final Logger LOG = Logger.getInstance(XmlElementStorage.class);
    private static final RoamingElementFilter DISABLED_ROAMING_ELEMENT_FILTER = new RoamingElementFilter(RoamingType.DISABLED);
    private static final String ATTR_NAME = "name";
    private static final String VERSION_FILE_SUFFIX = ".ver";
    @NotNull
    protected final String myRootElementName;
    protected StorageData myLoadedData;
    protected final StreamProvider myStreamProvider;
    protected final String myFileSpec;
    protected boolean myBlockSavingTheContent;
    private final ComponentVersionProvider myLocalVersionProvider;
    protected final RemoteComponentVersionProvider myRemoteVersionProvider;
    protected final RoamingType myRoamingType;

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String rootElementName, @Nullable StreamProvider streamProvider, ComponentVersionProvider componentVersionProvider) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "<init>"));
        }
        super(pathMacroSubstitutor);
        this.myBlockSavingTheContent = false;
        this.myFileSpec = fileSpec;
        this.myRoamingType = roamingType == null ? RoamingType.PER_USER : roamingType;
        this.myRootElementName = rootElementName;
        this.myStreamProvider = this.myRoamingType == RoamingType.DISABLED ? null : streamProvider;
        this.myLocalVersionProvider = componentVersionProvider;
        this.myRemoteVersionProvider = streamProvider == null || !streamProvider.isVersioningRequired() ? null : new RemoteComponentVersionProvider();
    }

    @Nullable
    protected abstract Element loadLocalData();

    public boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) throws StateStorageException {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "hasState"));
        }
        return this.getStorageData(reloadData).hasState(componentName);
    }

    @Nullable
    public <T> T getState(Object component, @NotNull String componentName, @NotNull Class<T> stateClass, @Nullable T mergeInto) throws StateStorageException {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getState"));
        }
        Element state = this.getStorageData(false).getStateAndArchive(componentName);
        return DefaultStateSerializer.deserializeState(state, stateClass, mergeInto);
    }

    @NotNull
    protected StorageData getStorageData() {
        StorageData storageData = this.getStorageData(false);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
        }
        return storageData;
    }

    @NotNull
    private StorageData getStorageData(boolean reloadData) {
        if (this.myLoadedData != null && !reloadData) {
            StorageData storageData = this.myLoadedData;
            if (storageData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
            }
            return storageData;
        }
        StorageData storageData = this.myLoadedData = this.loadData(true);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getStorageData"));
        }
        return storageData;
    }

    @NotNull
    protected StorageData loadData(boolean useProvidersData) {
        Element element;
        StorageData result;
        block7: {
            result = this.createStorageData();
            if (useProvidersData && this.myStreamProvider != null && this.myStreamProvider.isEnabled()) {
                StorageData storageData;
                try {
                    element = this.loadDataFromStreamProvider();
                    if (element != null) {
                        this.loadState(result, element);
                    }
                    if (this.myStreamProvider.isVersioningRequired() || this.myStreamProvider instanceof OldStreamProviderAdapter || this.myStreamProvider instanceof CurrentUserHolder) break block7;
                    storageData = result;
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
                if (storageData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
                }
                return storageData;
            }
        }
        if ((element = this.loadLocalData()) != null) {
            this.loadState(result, element);
        }
        StorageData storageData = result;
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadData"));
        }
        return storageData;
    }

    @Nullable
    protected final Element loadDataFromStreamProvider() throws IOException, JDOMException {
        assert (this.myStreamProvider != null);
        InputStream inputStream = this.myStreamProvider.loadContent(this.myFileSpec, this.myRoamingType);
        if (inputStream == null) {
            return null;
        }
        Element element = JDOMUtil.loadDocument((InputStream)inputStream).getRootElement();
        this.filterOutOfDate(element);
        return element;
    }

    protected final void loadState(@NotNull StorageData result, @NotNull Element element) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "loadState"));
        }
        result.load(element, this.myPathMacroSubstitutor, true);
    }

    @NotNull
    protected StorageData createStorageData() {
        StorageData storageData = new StorageData(this.myRootElementName);
        if (storageData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "createStorageData"));
        }
        return storageData;
    }

    public void setDefaultState(Element element) {
        this.myLoadedData = this.createStorageData();
        this.loadState(this.myLoadedData, element);
    }

    @Nullable
    public final XmlElementStorageSaveSession startExternalization() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession(this.getStorageData());
    }

    @Nullable
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "startSave"));
        }
        if (this.checkIsSavingDisabled()) {
            return null;
        }
        XmlElementStorageSaveSession session = (XmlElementStorageSaveSession)externalizationSession;
        if (LOG.isDebugEnabled() && this.myFileSpec.equals("$MODULE_FILE$")) {
            LOG.debug("startSave: session " + session.myCopiedStorageData + " for " + this.toString());
        }
        return session.myCopiedStorageData == null ? null : session;
    }

    protected abstract XmlElementStorageSaveSession createSaveSession(@NotNull StorageData var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Element getElement(@NotNull StorageData data, boolean collapsePaths, @NotNull Map<String, Element> newLiveStates) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "getElement"));
        }
        Element element = data.save(newLiveStates);
        if (element == null || JDOMUtil.isEmpty((Element)element)) {
            return null;
        }
        if (collapsePaths && this.myPathMacroSubstitutor != null) {
            try {
                this.myPathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.myPathMacroSubstitutor.reset();
            }
        }
        return element;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<VirtualFile> changedFiles, @NotNull Set<String> result) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        StorageData oldData = this.myLoadedData;
        StorageData newData = this.getStorageData(true);
        if (oldData == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString());
            }
            result.addAll(newData.getComponentNames());
        } else {
            Set<String> changedComponentNames = oldData.getChangedComponentNames(newData, this.myPathMacroSubstitutor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("analyzeExternalChangesAndUpdateIfNeed: changedComponentNames + " + changedComponentNames + " for " + this.toString());
            }
            if (!ContainerUtil.isEmpty(changedComponentNames)) {
                result.addAll(changedComponentNames);
            }
        }
    }

    private TObjectLongHashMap<String> loadVersions(List<Element> elements) {
        TObjectLongHashMap result = new TObjectLongHashMap();
        for (Element component : elements) {
            long version;
            String name = component.getAttributeValue(ATTR_NAME);
            if (name == null || (version = this.myLocalVersionProvider.getVersion(name)) <= 0L) continue;
            result.put((Object)name, version);
        }
        return result;
    }

    public void resetData() {
        this.myLoadedData = null;
    }

    private void filterOutOfDate(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage", "filterOutOfDate"));
        }
        if (this.myRemoteVersionProvider == null) {
            return;
        }
        Iterator iterator = element.getContent((Filter)new ElementFilter("component")).iterator();
        while (iterator.hasNext()) {
            String name = ((Element)iterator.next()).getAttributeValue(ATTR_NAME);
            long remoteVersion = this.myRemoteVersionProvider.getVersion(name);
            if (remoteVersion <= this.myLocalVersionProvider.getVersion(name)) {
                iterator.remove();
                continue;
            }
            this.myLocalVersionProvider.changeVersion(name, remoteVersion);
        }
    }

    public void resetProviderCache() {
        if (this.myRemoteVersionProvider != null) {
            this.myRemoteVersionProvider.myProviderVersions = null;
        }
    }

    private static class RoamingElementFilter
    extends ElementFilter {
        final RoamingType myRoamingType;

        public RoamingElementFilter(RoamingType roamingType) {
            super("component");
            this.myRoamingType = roamingType;
        }

        public boolean matches(Object obj) {
            return super.matches(obj) && ComponentRoamingManager.getInstance().getRoamingType(((Element)obj).getAttributeValue(XmlElementStorage.ATTR_NAME)) == this.myRoamingType;
        }
    }

    private final class RemoteComponentVersionProvider
    implements ComponentVersionProvider {
        private TObjectLongHashMap<String> myProviderVersions;

        private RemoteComponentVersionProvider() {
        }

        @Override
        public long getVersion(String name) {
            if (this.myProviderVersions == null) {
                this.loadProviderVersions();
            }
            return this.myProviderVersions == null ? -1L : this.myProviderVersions.get((Object)name);
        }

        @Override
        public void changeVersion(String name, long version) {
            if (this.myProviderVersions == null) {
                this.loadProviderVersions();
            }
            if (this.myProviderVersions != null) {
                this.myProviderVersions.put((Object)name, version);
            }
        }

        private void loadProviderVersions() {
            assert (XmlElementStorage.this.myStreamProvider != null);
            if (!XmlElementStorage.this.myStreamProvider.isEnabled()) {
                return;
            }
            this.myProviderVersions = new TObjectLongHashMap();
            for (RoamingType type : RoamingType.values()) {
                try {
                    Document doc = StorageUtil.loadDocument(XmlElementStorage.this.myStreamProvider.loadContent(XmlElementStorage.this.myFileSpec + XmlElementStorage.VERSION_FILE_SUFFIX, type));
                    if (doc == null) continue;
                    StateStorageManagerImpl.loadComponentVersions(this.myProviderVersions, doc);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    protected abstract class XmlElementStorageSaveSession
    implements StateStorage.SaveSession,
    StateStorage.ExternalizationSession {
        private final StorageData myOriginalStorageData;
        private StorageData myCopiedStorageData;
        private final Map<String, Element> myNewLiveStates;

        public XmlElementStorageSaveSession(StorageData storageData) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "<init>"));
            }
            this.myNewLiveStates = new THashMap();
            this.myOriginalStorageData = storageData;
        }

        public final void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state, @Nullable Storage storageSpec) {
            Element element;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "setState"));
            }
            try {
                if (LOG.isDebugEnabled() && state instanceof JDOMExternalizable && componentName.endsWith("ApplicationInfo")) {
                    return;
                }
                element = DefaultStateSerializer.serializeState(state, storageSpec);
            }
            catch (WriteExternalException e) {
                LOG.debug((Throwable)e);
                return;
            }
            catch (Throwable e) {
                LOG.info("Unable to serialize component state!", e);
                return;
            }
            if (this.myCopiedStorageData == null) {
                this.myCopiedStorageData = StorageData.setStateAndCloneIfNeed(componentName, element, this.myOriginalStorageData, this.myNewLiveStates);
                if (this.myCopiedStorageData != null) {
                    XmlElementStorage.this.myLocalVersionProvider.changeVersion(componentName, System.currentTimeMillis());
                }
            } else if (this.myCopiedStorageData.setState(componentName, element, this.myNewLiveStates) != null) {
                XmlElementStorage.this.myLocalVersionProvider.changeVersion(componentName, System.currentTimeMillis());
            }
        }

        public void forceSave() {
            LOG.assertTrue(this.myCopiedStorageData == null);
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            try {
                this.doSave(XmlElementStorage.this.getElement(this.myOriginalStorageData, this.isCollapsePathsOnSave(), Collections.<String, Element>emptyMap()));
            }
            catch (IOException e) {
                throw new StateStorageException((Throwable)e);
            }
        }

        public final void save() {
            if (XmlElementStorage.this.myBlockSavingTheContent) {
                return;
            }
            try {
                this.doSave(XmlElementStorage.this.getElement(this.myCopiedStorageData, this.isCollapsePathsOnSave(), this.myNewLiveStates));
                XmlElementStorage.this.myLoadedData = this.myCopiedStorageData;
            }
            catch (IOException e) {
                throw new StateStorageException((Throwable)e);
            }
        }

        protected boolean isCollapsePathsOnSave() {
            return true;
        }

        protected abstract void doSave(@Nullable Element var1) throws IOException;

        protected void saveForProvider(@Nullable BufferExposingByteArrayOutputStream content, @Nullable Element element) throws IOException {
            if (!XmlElementStorage.this.myStreamProvider.isApplicable(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType)) {
                return;
            }
            if (element == null) {
                XmlElementStorage.this.myStreamProvider.delete(XmlElementStorage.this.myFileSpec, XmlElementStorage.this.myRoamingType);
                return;
            }
            if (XmlElementStorage.this.myFileSpec.equals("$WORKSPACE_FILE$")) {
                Element copiedElement = JDOMUtil.cloneElement((Element)element, (ElementFilter)DISABLED_ROAMING_ELEMENT_FILTER);
                if (copiedElement != null) {
                    this.doSaveForProvider(copiedElement, DISABLED_ROAMING_ELEMENT_FILTER.myRoamingType, content);
                }
            } else {
                this.doSaveForProvider(element, XmlElementStorage.this.myRoamingType, content);
            }
        }

        private void doSaveForProvider(@NotNull Element element, @NotNull RoamingType roamingType, @Nullable BufferExposingByteArrayOutputStream content) throws IOException {
            TObjectLongHashMap versions;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (roamingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roamingType", "com/intellij/openapi/components/impl/stores/XmlElementStorage$XmlElementStorageSaveSession", "doSaveForProvider"));
            }
            if (content == null) {
                StorageUtil.doSendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec, (Parent)element, roamingType, true);
            } else {
                XmlElementStorage.this.myStreamProvider.saveContent(XmlElementStorage.this.myFileSpec, content.getInternalBuffer(), content.size(), XmlElementStorage.this.myRoamingType, true);
            }
            if (XmlElementStorage.this.myStreamProvider.isVersioningRequired() && !(versions = XmlElementStorage.this.loadVersions(element.getChildren("component"))).isEmpty()) {
                Element versionDoc = StateStorageManagerImpl.createComponentVersionsXml((TObjectLongHashMap<String>)versions);
                StorageUtil.doSendContent(XmlElementStorage.this.myStreamProvider, XmlElementStorage.this.myFileSpec + XmlElementStorage.VERSION_FILE_SUFFIX, (Parent)versionDoc, roamingType, true);
            }
        }
    }
}

