/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemRecentTaskListModel;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.util.Producer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemRecentTasksList
extends JBList
implements Producer<ExternalTaskExecutionInfo> {
    @NotNull
    private static final JLabel EMPTY_RENDERER = new JLabel(" ");

    public ExternalSystemRecentTasksList(@NotNull ExternalSystemRecentTaskListModel model, final @NotNull ProjectSystemId externalSystemId, final @NotNull Project project) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList", "<init>"));
        }
        super((ListModel)model);
        this.setSelectionMode(0);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        Icon icon = null;
        if (manager instanceof ExternalSystemUiAware) {
            icon = ((ExternalSystemUiAware)manager).getTaskIcon();
        }
        if (icon == null) {
            icon = DefaultExternalSystemUiAware.INSTANCE.getTaskIcon();
        }
        this.setCellRenderer(new MyRenderer(project, icon, ExternalSystemUtil.findConfigurationType(externalSystemId)));
        this.setVisibleRowCount(ExternalSystemConstants.RECENT_TASKS_NUMBER);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalTaskExecutionInfo task = ExternalSystemRecentTasksList.this.produce();
                if (task == null) {
                    return;
                }
                ExternalSystemUtil.runTask(task.getSettings(), task.getExecutorId(), project, externalSystemId);
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                ExternalTaskExecutionInfo task = ExternalSystemRecentTasksList.this.produce();
                if (task == null) {
                    return;
                }
                ExternalSystemUtil.runTask(task.getSettings(), task.getExecutorId(), project, externalSystemId);
            }
        });
    }

    public ExternalSystemRecentTaskListModel getModel() {
        return (ExternalSystemRecentTaskListModel)super.getModel();
    }

    public void setFirst(@NotNull ExternalTaskExecutionInfo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList", "setFirst"));
        }
        ExternalTaskExecutionInfo selected = this.produce();
        ExternalSystemRecentTaskListModel model = this.getModel();
        model.setFirst(task);
        this.clearSelection();
        if (selected == null) {
            return;
        }
        for (int i = 0; i < model.size(); ++i) {
            if (!selected.equals(model.getElementAt(i))) continue;
            this.addSelectionInterval(i, i);
            return;
        }
    }

    @Nullable
    public ExternalTaskExecutionInfo produce() {
        int[] indices = this.getSelectedIndices();
        if (indices == null || indices.length != 1) {
            return null;
        }
        Object e = this.getModel().getElementAt(indices[0]);
        return e instanceof ExternalTaskExecutionInfo ? (ExternalTaskExecutionInfo)e : null;
    }

    private static class MyRenderer
    extends DefaultListCellRenderer {
        @NotNull
        private final Icon myGenericTaskIcon;
        @NotNull
        private final Project myProject;
        @Nullable
        private ConfigurationType myConfigurationType;

        MyRenderer(@NotNull Project project, @NotNull Icon genericTaskIcon, @Nullable ConfigurationType configurationType) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList$MyRenderer", "<init>"));
            }
            if (genericTaskIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericTaskIcon", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemRecentTasksList$MyRenderer", "<init>"));
            }
            this.myProject = project;
            this.myGenericTaskIcon = genericTaskIcon;
            this.myConfigurationType = configurationType;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ExternalSystemRecentTaskListModel.MyEmptyDescriptor) {
                return EMPTY_RENDERER;
            }
            if (value instanceof ExternalTaskExecutionInfo) {
                Executor executor;
                ExternalTaskExecutionInfo taskInfo = (ExternalTaskExecutionInfo)value;
                String text = null;
                if (this.myConfigurationType != null) {
                    List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(this.myConfigurationType);
                    for (RunConfiguration configuration : configurations) {
                        ExternalSystemRunConfiguration c;
                        if (!(configuration instanceof ExternalSystemRunConfiguration) || !(c = (ExternalSystemRunConfiguration)configuration).getSettings().equals((Object)taskInfo.getSettings())) continue;
                        text = c.getName();
                    }
                }
                if (StringUtil.isEmpty(text)) {
                    text = AbstractExternalSystemTaskConfigurationType.generateName(this.myProject, taskInfo.getSettings());
                }
                this.setText(text);
                Icon icon = null;
                String executorId = taskInfo.getExecutorId();
                if (!StringUtil.isEmpty((String)executorId) && (executor = ExecutorRegistry.getInstance().getExecutorById(executorId)) != null) {
                    icon = executor.getIcon();
                }
                if (icon == null) {
                    icon = this.myGenericTaskIcon;
                }
                this.setIcon(icon);
            }
            return renderer;
        }

        @Override
        public void setIcon(Icon icon) {
            if (icon != null) {
                super.setIcon(icon);
            }
        }
    }
}

