/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkConfigurable
implements UnnamedConfigurable {
    private JdkComboBox myCbProjectJdk;
    private JPanel myJdkPanel;
    private final Project myProject;
    private final ProjectSdksModel myJdksModel;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(Sdk sdk) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            ProjectJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            ProjectJdkConfigurable.this.reloadModel();
        }
    };
    private boolean myFreeze = false;

    public ProjectJdkConfigurable(Project project, ProjectSdksModel jdksModel) {
        this.myProject = project;
        this.myJdksModel = jdksModel;
        this.myJdksModel.addListener(this.myListener);
    }

    @Nullable
    public Sdk getSelectedProjectJdk() {
        return this.myJdksModel.findSdk(this.myCbProjectJdk.getSelectedJdk());
    }

    public JComponent createComponent() {
        if (this.myJdkPanel == null) {
            this.myJdkPanel = new JPanel(new GridBagLayout());
            this.myCbProjectJdk = new JdkComboBox(this.myJdksModel);
            this.myCbProjectJdk.insertItemAt(new JdkComboBox.NoneJdkComboBoxItem(), 0);
            this.myCbProjectJdk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProjectJdkConfigurable.this.myFreeze) {
                        return;
                    }
                    ProjectJdkConfigurable.this.myJdksModel.setProjectSdk(ProjectJdkConfigurable.this.myCbProjectJdk.getSelectedJdk());
                    ProjectJdkConfigurable.this.clearCaches();
                }
            });
            this.myJdkPanel.add((Component)new JLabel(ProjectBundle.message((String)"module.libraries.target.jdk.project.radio", (Object[])new Object[0])), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 4, 0), 0, 0));
            this.myJdkPanel.add((Component)((Object)this.myCbProjectJdk), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0));
            JButton setUpButton = new JButton(ApplicationBundle.message((String)"button.new", (Object[])new Object[0]));
            this.myCbProjectJdk.setSetupButton(setUpButton, this.myProject, this.myJdksModel, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.NoneJdkComboBoxItem(), null, false);
            this.myJdkPanel.add((Component)setUpButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            JButton editButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
            this.myCbProjectJdk.setEditButton(editButton, this.myProject, new Computable<Sdk>(){

                @Nullable
                public Sdk compute() {
                    return ProjectJdkConfigurable.this.myJdksModel.getProjectSdk();
                }
            });
            this.myJdkPanel.add((Component)editButton, new GridBagConstraints(-1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 4, 0, 0), 0, 0));
        }
        return this.myJdkPanel;
    }

    private void reloadModel() {
        String sdkName;
        this.myFreeze = true;
        Sdk projectJdk = this.myJdksModel.getProjectSdk();
        this.myCbProjectJdk.reloadModel(new JdkComboBox.NoneJdkComboBoxItem(), this.myProject);
        String string = sdkName = projectJdk == null ? ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName() : projectJdk.getName();
        if (sdkName != null) {
            Sdk jdk = this.myJdksModel.findSdk(sdkName);
            if (jdk != null) {
                this.myCbProjectJdk.setSelectedJdk(jdk);
            } else {
                this.myCbProjectJdk.setInvalidJdk(sdkName);
                this.clearCaches();
            }
        } else {
            this.myCbProjectJdk.setSelectedJdk(null);
        }
        this.myFreeze = false;
    }

    private void clearCaches() {
        Module[] modules;
        ModuleStructureConfigurable rootConfigurable = ModuleStructureConfigurable.getInstance(this.myProject);
        for (Module module : modules = rootConfigurable.getModules()) {
            StructureConfigurableContext context = rootConfigurable.getContext();
            context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
        }
    }

    public boolean isModified() {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
        return !Comparing.equal((Object)projectJdk, (Object)this.getSelectedProjectJdk());
    }

    public void apply() {
        ProjectRootManager.getInstance((Project)this.myProject).setProjectSdk(this.getSelectedProjectJdk());
    }

    public void reset() {
        this.reloadModel();
        String sdkName = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdkName();
        if (sdkName != null) {
            Sdk jdk = this.myJdksModel.findSdk(sdkName);
            if (jdk != null) {
                this.myCbProjectJdk.setSelectedJdk(jdk);
            } else {
                this.myCbProjectJdk.setInvalidJdk(sdkName);
            }
        } else {
            this.myCbProjectJdk.setSelectedJdk(null);
        }
    }

    public void disposeUIResources() {
        this.myJdksModel.removeListener(this.myListener);
        this.myJdkPanel = null;
        this.myCbProjectJdk = null;
    }
}

