/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class UpdateCheckerComponent
implements ApplicationComponent {
    private static final long CHECK_INTERVAL = 86400000L;
    private final Alarm myCheckForUpdatesAlarm;
    private final Runnable myCheckRunnable;
    private final UpdateSettings mySettings;

    public UpdateCheckerComponent(@NotNull Application app, @NotNull UpdateSettings settings) {
        if (app == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "app", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "<init>"));
        }
        this.myCheckForUpdatesAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myCheckRunnable = new Runnable(){

            @Override
            public void run() {
                UpdateChecker.updateAndShowResult().doWhenDone(new Runnable(){

                    @Override
                    public void run() {
                        UpdateCheckerComponent.this.queueNextCheck(86400000L);
                    }
                });
            }
        };
        this.mySettings = settings;
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener.Adapter(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent$2", "appFrameCreated"));
                }
                UpdateCheckerComponent.this.scheduleOnStartCheck();
            }
        });
    }

    public void initComponent() {
        PluginsAdvertiser.ensureDeleted();
    }

    private void scheduleOnStartCheck() {
        if (!this.mySettings.CHECK_NEEDED) {
            return;
        }
        String currentBuild = ApplicationInfo.getInstance().getBuild().asString();
        long timeToNextCheck = this.mySettings.LAST_TIME_CHECKED + 86400000L - System.currentTimeMillis();
        if (StringUtil.compareVersionNumbers((String)this.mySettings.LAST_BUILD_CHECKED, (String)currentBuild) < 0 || timeToNextCheck <= 0L) {
            this.myCheckRunnable.run();
        } else {
            this.queueNextCheck(timeToNextCheck);
        }
    }

    private void queueNextCheck(long interval) {
        this.myCheckForUpdatesAlarm.addRequest(this.myCheckRunnable, interval);
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this.myCheckForUpdatesAlarm);
    }

    @NotNull
    public String getComponentName() {
        if ("UpdateCheckerComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateCheckerComponent", "getComponentName"));
        }
        return "UpdateCheckerComponent";
    }

    public void queueNextCheck() {
        this.queueNextCheck(86400000L);
    }

    public void cancelChecks() {
        this.myCheckForUpdatesAlarm.cancelAllRequests();
    }
}

