/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PsiChangeTracker {
    private PsiChangeTracker() {
    }

    public static <T extends PsiElement> Map<T, FileStatus> getElementsChanged(PsiElement file, PsiElement oldFile, PsiFilter<T> filter) {
        FileStatus status;
        HashMap<PsiElement, FileStatus> result = new HashMap<PsiElement, FileStatus>();
        ArrayList oldElements = new ArrayList();
        ArrayList elements = new ArrayList();
        if (file == null) {
            oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
            PsiChangeTracker.calculateStatuses(elements, oldElements, result, filter);
            return result;
        }
        Project project = file.getProject();
        file.accept((PsiElementVisitor)filter.createVisitor(elements));
        VirtualFile vf = file.getContainingFile().getVirtualFile();
        FileStatus fileStatus = status = vf == null ? null : FileStatusManager.getInstance((Project)project).getStatus(vf);
        if (status == null && oldFile == null) {
            status = FileStatus.ADDED;
        }
        if (status == FileStatus.ADDED || status == FileStatus.DELETED || status == FileStatus.DELETED_FROM_FS || status == FileStatus.UNKNOWN) {
            for (PsiElement element : elements) {
                result.put(element, status);
            }
            return result;
        }
        if (oldFile == null) {
            return result;
        }
        oldFile.accept((PsiElementVisitor)filter.createVisitor(oldElements));
        PsiChangeTracker.calculateStatuses(elements, oldElements, result, filter);
        return result;
    }

    private static <T extends PsiElement> Map<T, FileStatus> calculateStatuses(List<T> elements, List<T> oldElements, Map<T, FileStatus> result, PsiFilter<T> filter) {
        for (PsiElement element : elements) {
            PsiElement e = null;
            for (PsiElement oldElement : oldElements) {
                if (!filter.areEquivalent(element, oldElement)) continue;
                e = oldElement;
                break;
            }
            if (e != null) {
                oldElements.remove(e);
                if (element.getText().equals(e.getText())) continue;
                result.put(element, FileStatus.MODIFIED);
                continue;
            }
            result.put(element, FileStatus.ADDED);
        }
        for (PsiElement oldElement : oldElements) {
            result.put(oldElement, FileStatus.DELETED);
        }
        return result;
    }
}

