/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.dbCommitted;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CacheJdbcConnection {
    private final Object myLock;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.dbCommitted.CacheJdbcConnection");
    private Connection myConnection;
    private final Map<String, PreparedStatement> myPreparedStatementsMap;
    private final File myDbFile;
    private final ThrowableConsumer<Connection, VcsException> myInitDbScript;

    public CacheJdbcConnection(File dbFile, ThrowableConsumer<Connection, VcsException> initDbScript) {
        this.myDbFile = dbFile;
        this.myInitDbScript = initDbScript;
        this.myLock = new Object();
        this.myPreparedStatementsMap = new HashMap<String, PreparedStatement>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        Connection connection;
        HashMap<String, PreparedStatement> copyMap;
        Object object = this.myLock;
        synchronized (object) {
            copyMap = new HashMap<String, PreparedStatement>(this.myPreparedStatementsMap);
            connection = this.myConnection;
            this.myConnection = null;
            this.myPreparedStatementsMap.clear();
        }
        if (connection != null) {
            for (PreparedStatement statement : copyMap.values()) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.info((Throwable)e);
                }
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getOrCreatePreparedStatement(@NotNull String name, ThrowableConvertor<Connection, PreparedStatement, SQLException> getter) throws VcsException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/dbCommitted/CacheJdbcConnection", "getOrCreatePreparedStatement"));
        }
        Object object = this.myLock;
        synchronized (object) {
            PreparedStatement newStatement;
            this.getConnection();
            PreparedStatement statement = this.myPreparedStatementsMap.get(name);
            if (statement != null) {
                return statement;
            }
            try {
                newStatement = (PreparedStatement)getter.convert((Object)this.myConnection);
            }
            catch (SQLException e) {
                throw new VcsException((Throwable)e);
            }
            this.myPreparedStatementsMap.put(name, newStatement);
            return newStatement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws VcsException {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnection == null) {
                this.myConnection = this.initConnection();
            }
            return this.myConnection;
        }
    }

    private Connection initConnection() throws VcsException {
        boolean existed = this.myDbFile.exists();
        try {
            Class.forName("org.sqlite.JDBC");
            Connection connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", this.myDbFile.getPath()));
            if (!existed && this.myInitDbScript != null) {
                this.myInitDbScript.consume((Object)connection);
            }
            connection.setAutoCommit(false);
            return connection;
        }
        catch (ClassNotFoundException e) {
            throw new VcsException((Throwable)e);
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }

    public void commit() throws VcsException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new VcsException((Throwable)e);
        }
    }
}

