/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyTextFilePatch;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.actions.ChangeDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentable;
import com.intellij.openapi.vcs.changes.actions.DiffRequestPresentableProxy;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.ShowDiffUIContext;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchForBaseRevisionTexts;
import com.intellij.openapi.vcs.changes.patch.MergedDiffRequestPresentable;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DiffShelvedChangesAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DiffShelvedChangesAction.showShelvedChangesDiff(e.getDataContext());
    }

    public static void showShelvedChangesDiff(DataContext dc) {
        DiffRequestPresentable presentable;
        String path;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        ShelvedChangeList[] changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY.getData(dc);
        if (changeLists == null) {
            changeLists = (ShelvedChangeList[])ShelvedChangesViewManager.SHELVED_RECYCLED_CHANGELIST_KEY.getData(dc);
        }
        if (changeLists == null) {
            return;
        }
        List<ShelvedChange> changesFromFirstList = changeLists[0].getChanges(project);
        ArrayList<DiffRequestPresentable> diffRequestPresentables = new ArrayList<DiffRequestPresentable>();
        ApplyPatchContext context = new ApplyPatchContext(project.getBaseDir(), 0, false, false);
        PatchesPreloader preloader = new PatchesPreloader(project);
        LinkedList<String> missing = new LinkedList<String>();
        DiffShelvedChangesAction.processTextChanges(project, changesFromFirstList, diffRequestPresentables, context, preloader, missing);
        List<ShelvedBinaryFile> files = changeLists[0].getBinaryFiles();
        DiffShelvedChangesAction.processBinaryFiles(project, files, diffRequestPresentables);
        if (!missing.isEmpty()) {
            VcsBalloonProblemNotifier.showOverChangesView(project, "Show Diff: Cannot find base for: " + StringUtil.join(missing, (String)",\n"), MessageType.WARNING, new NamedRunnable[0]);
        }
        Collections.sort(diffRequestPresentables, ChangeDiffRequestComparator.getInstance());
        HashSet<String> selectedPaths = new HashSet<String>();
        List shelvedChanges = (List)ShelvedChangesViewManager.SHELVED_CHANGE_KEY.getData(dc);
        List binaryFiles = (List)ShelvedChangesViewManager.SHELVED_BINARY_FILE_KEY.getData(dc);
        for (ShelvedChange change : shelvedChanges) {
            selectedPaths.add(FilePathsHelper.convertPath((String)ChangesUtil.getFilePath((Change)change.getChange(project)).getPath()));
        }
        for (ShelvedBinaryFile file : binaryFiles) {
            selectedPaths.add(FilePathsHelper.convertPath((FilePath)ChangesUtil.getFilePath((Change)file.createChange(project))));
        }
        int idx = 0;
        Iterator<DiffRequestPresentable> i$ = diffRequestPresentables.iterator();
        while (i$.hasNext() && !selectedPaths.contains(path = FilePathsHelper.convertPath((String)(presentable = i$.next()).getPathPresentation()))) {
            ++idx;
        }
        idx = idx >= diffRequestPresentables.size() ? 0 : idx;
        ShowDiffAction.showDiffImpl(project, diffRequestPresentables, idx, new ShowDiffUIContext(true));
    }

    private static void processBinaryFiles(final Project project, List<ShelvedBinaryFile> files, ArrayList<DiffRequestPresentable> diffRequestPresentables) {
        final String base = project.getBaseDir().getPath();
        for (final ShelvedBinaryFile file : files) {
            diffRequestPresentables.add(new DiffRequestPresentableProxy(){

                @Override
                @NotNull
                protected DiffRequestPresentable init() throws VcsException {
                    ChangeDiffRequestPresentable changeDiffRequestPresentable = new ChangeDiffRequestPresentable(project, file.createChange(project));
                    if (changeDiffRequestPresentable == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$1", "init"));
                    }
                    return changeDiffRequestPresentable;
                }

                public String getPathPresentation() {
                    File file1 = new File(base, file.AFTER_PATH == null ? file.BEFORE_PATH : file.AFTER_PATH);
                    return FileUtil.toSystemDependentName((String)file1.getPath());
                }
            });
        }
    }

    private static void processTextChanges(final Project project, List<ShelvedChange> changesFromFirstList, ArrayList<DiffRequestPresentable> diffRequestPresentables, final ApplyPatchContext context, final PatchesPreloader preloader, List<String> missing) {
        final String base = project.getBasePath();
        for (final ShelvedChange shelvedChange : changesFromFirstList) {
            String beforePath = shelvedChange.getBeforePath();
            try {
                final VirtualFile f = ApplyTextFilePatch.findPatchTarget(context, beforePath, shelvedChange.getAfterPath(), FileStatus.ADDED.equals(shelvedChange.getFileStatus()));
                if (!(FileStatus.ADDED.equals(shelvedChange.getFileStatus()) || f != null && f.exists())) {
                    if (beforePath == null) continue;
                    missing.add(beforePath);
                    continue;
                }
                diffRequestPresentables.add(new DiffRequestPresentableProxy(){

                    @Override
                    @NotNull
                    protected DiffRequestPresentable init() throws VcsException {
                        if (shelvedChange.isConflictingChange(project)) {
                            final CommitContext commitContext = new CommitContext();
                            final TextFilePatch patch = preloader.getPatch(shelvedChange, commitContext);
                            final FilePath pathBeforeRename = context.getPathBeforeRename(f);
                            final String relativePath = patch.getAfterName() == null ? patch.getBeforeName() : patch.getAfterName();
                            Getter<ApplyPatchForBaseRevisionTexts> revisionTextsGetter = new Getter<ApplyPatchForBaseRevisionTexts>(){

                                public ApplyPatchForBaseRevisionTexts get() {
                                    return ApplyPatchForBaseRevisionTexts.create(project, f, pathBeforeRename, patch, new Getter<CharSequence>(){

                                        public CharSequence get() {
                                            BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)Extensions.findExtension((ExtensionPointName)PatchEP.EP_NAME, (AreaInstance)project, BaseRevisionTextPatchEP.class);
                                            if (baseRevisionTextPatchEP != null && commitContext != null) {
                                                return baseRevisionTextPatchEP.provideContent(relativePath, commitContext);
                                            }
                                            return null;
                                        }
                                    });
                                }
                            };
                            MergedDiffRequestPresentable mergedDiffRequestPresentable = new MergedDiffRequestPresentable(project, revisionTextsGetter, f, "Shelved Version");
                            if (mergedDiffRequestPresentable == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$2", "init"));
                            }
                            return mergedDiffRequestPresentable;
                        }
                        Change change = shelvedChange.getChange(project);
                        ChangeDiffRequestPresentable changeDiffRequestPresentable = new ChangeDiffRequestPresentable(project, change);
                        if (changeDiffRequestPresentable == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$2", "init"));
                        }
                        return changeDiffRequestPresentable;
                    }

                    public String getPathPresentation() {
                        return FileUtil.toSystemDependentName((String)new File(base, shelvedChange.getAfterPath() == null ? shelvedChange.getBeforePath() : shelvedChange.getAfterPath()).getPath());
                    }
                });
            }
            catch (IOException e) {}
        }
    }

    public void update(AnActionEvent e) {
        ActionManager.getInstance().getAction("ChangesView.Diff").update(e);
    }

    private static final class MyComparator
    implements Comparator<ShelvedChange> {
        private final Project myProject;

        public MyComparator(Project project) {
            this.myProject = project;
        }

        @Override
        public int compare(ShelvedChange o1, ShelvedChange o2) {
            return ChangesComparator.getInstance(true).compare(o1.getChange(this.myProject), o2.getChange(this.myProject));
        }
    }

    private static class PatchesPreloader {
        private final Map<String, List<TextFilePatch>> myFilePatchesMap;
        private final Project myProject;

        private PatchesPreloader(Project project) {
            this.myProject = project;
            this.myFilePatchesMap = new HashMap<String, List<TextFilePatch>>();
        }

        @NotNull
        public TextFilePatch getPatch(ShelvedChange shelvedChange, CommitContext commitContext) throws VcsException {
            List<TextFilePatch> textFilePatches = this.myFilePatchesMap.get(shelvedChange.getPatchPath());
            if (textFilePatches == null) {
                try {
                    textFilePatches = ShelveChangesManager.loadPatches(this.myProject, shelvedChange.getPatchPath(), commitContext);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
                catch (PatchSyntaxException e) {
                    throw new VcsException((Throwable)e);
                }
                this.myFilePatchesMap.put(shelvedChange.getPatchPath(), textFilePatches);
            }
            for (TextFilePatch textFilePatch : textFilePatches) {
                if (!shelvedChange.getBeforePath().equals(textFilePatch.getBeforeName())) continue;
                TextFilePatch textFilePatch2 = textFilePatch;
                if (textFilePatch2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/DiffShelvedChangesAction$PatchesPreloader", "getPatch"));
                }
                return textFilePatch2;
            }
            throw new VcsException("Can not find patch for " + shelvedChange.getBeforePath() + " in patch file.");
        }
    }

    private static class ChangeDiffRequestComparator
    implements Comparator<DiffRequestPresentable> {
        private static final ChangeDiffRequestComparator ourInstance = new ChangeDiffRequestComparator();

        private ChangeDiffRequestComparator() {
        }

        public static ChangeDiffRequestComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(DiffRequestPresentable o1, DiffRequestPresentable o2) {
            return FilePathsHelper.convertPath((String)o1.getPathPresentation()).compareTo(FilePathsHelper.convertPath((String)o2.getPathPresentation()));
        }
    }
}

