/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTreeList<T>
extends JPanel
implements TypeSafeDataProvider {
    private final Tree myTree;
    private final JBList myList;
    private final JScrollPane myTreeScrollPane;
    private final JScrollPane myListScrollPane;
    protected final Project myProject;
    private final boolean myShowCheckboxes;
    private final boolean myHighlightProblems;
    private boolean myShowFlatten;
    private final Collection<T> myIncludedChanges;
    private Runnable myDoubleClickHandler = EmptyRunnable.getInstance();
    private boolean myAlwaysExpandList;
    @NonNls
    private static final String TREE_CARD = "Tree";
    @NonNls
    private static final String LIST_CARD = "List";
    @NonNls
    private static final String ROOT = "root";
    private final CardLayout myCards;
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    private final Runnable myInclusionListener;
    @Nullable
    private ChangeNodeDecorator myChangeDecorator;
    private Runnable myGenericSelectionListener;

    public ChangesTreeList(Project project, Collection<T> initiallyIncluded, boolean showCheckboxes, boolean highlightProblems, @Nullable Runnable inclusionListener, @Nullable ChangeNodeDecorator decorator) {
        this.myProject = project;
        this.myShowCheckboxes = showCheckboxes;
        this.myHighlightProblems = highlightProblems;
        this.myInclusionListener = inclusionListener;
        this.myChangeDecorator = decorator;
        this.myIncludedChanges = new HashSet<T>(initiallyIncluded);
        this.myAlwaysExpandList = true;
        this.myCards = new CardLayout();
        this.setLayout(this.myCards);
        final int checkboxWidth = new JCheckBox().getPreferredSize().width;
        this.myTree = new MyTree(project, checkboxWidth);
        this.myTree.setHorizontalAutoScrollingEnabled(false);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setOpaque(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new MyTreeCellRenderer());
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                ChangesBrowserNode node = (ChangesBrowserNode)o.getLastPathComponent();
                return node.getTextPresentation();
            }
        });
        this.myList = new JBList(new DefaultListModel());
        this.myList.setVisibleRowCount(10);
        this.myListScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myList);
        this.add((Component)this.myListScrollPane, LIST_CARD);
        this.myTreeScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        this.add((Component)this.myTreeScrollPane, TREE_CARD);
        new ListSpeedSearch((JList)this.myList){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Change) {
                    return ChangesUtil.getFilePath((Change)((Change)element)).getName();
                }
                return super.getElementText(element);
            }
        };
        this.myList.setCellRenderer((ListCellRenderer)new MyListCellRenderer());
        new MyToggleSelectionAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), this);
        if (this.myShowCheckboxes) {
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangesTreeList.this.includeSelection();
                }
            }, KeyStroke.getKeyStroke(155, 0), 1);
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChangesTreeList.this.excludeSelection();
                }
            }, KeyStroke.getKeyStroke(127, 0), 1);
        }
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangesTreeList.this.myDoubleClickHandler.run();
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode() && e.getModifiers() == 0) {
                    if (ChangesTreeList.this.myTree.getSelectionCount() <= 1) {
                        Object lastPathComponent = ChangesTreeList.this.myTree.getLastSelectedPathComponent();
                        if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                            return;
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                        if (!node.isLeaf()) {
                            return;
                        }
                    }
                    ChangesTreeList.this.myDoubleClickHandler.run();
                    e.consume();
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList$7", "onClick"));
                }
                int idx = ChangesTreeList.this.myList.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    Rectangle baseRect = ChangesTreeList.this.myList.getCellBounds(idx, idx);
                    baseRect.setSize(checkboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        ChangesTreeList.this.toggleSelection();
                        return true;
                    }
                    if (clickCount == 2) {
                        ChangesTreeList.this.myDoubleClickHandler.run();
                        return true;
                    }
                }
                return false;
            }
        }.installOn((Component)this.myList);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath clickPath;
                TreePath treePath = clickPath = ChangesTreeList.this.myTree.getUI() instanceof WideSelectionTreeUI ? ChangesTreeList.this.myTree.getClosestPathForLocation(e.getX(), e.getY()) : ChangesTreeList.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (clickPath == null) {
                    return false;
                }
                ChangesTreeList.this.myDoubleClickHandler.run();
                return true;
            }
        }.installOn((Component)this.myTree);
        this.setShowFlatten(PropertiesComponent.getInstance((Project)this.myProject).isTrueValue(FLATTEN_OPTION_KEY));
        String emptyText = StringUtil.capitalize((String)DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.setEmptyText(emptyText);
    }

    public void setEmptyText(@NotNull String emptyText) {
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "setEmptyText"));
        }
        this.myTree.getEmptyText().setText(emptyText);
        this.myList.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(Runnable runnable) {
        this.myGenericSelectionListener = runnable;
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ChangesTreeList.this.myGenericSelectionListener.run();
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChangesTreeList.this.myGenericSelectionListener.run();
            }
        });
    }

    public void setChangeDecorator(@Nullable ChangeNodeDecorator changeDecorator) {
        this.myChangeDecorator = changeDecorator;
    }

    public void setDoubleClickHandler(Runnable doubleClickHandler) {
        this.myDoubleClickHandler = doubleClickHandler;
    }

    public void installPopupHandler(ActionGroup group) {
        PopupHandler.installUnknownPopupHandler((JComponent)this.myList, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
        PopupHandler.installUnknownPopupHandler((JComponent)this.myTree, (ActionGroup)group, (ActionManager)ActionManager.getInstance());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myShowFlatten ? this.myList : this.myTree;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    public boolean isShowFlatten() {
        return this.myShowFlatten;
    }

    public void setScrollPaneBorder(Border border) {
        this.myListScrollPane.setBorder(border);
        this.myTreeScrollPane.setBorder(border);
    }

    public void setShowFlatten(boolean showFlatten) {
        List<T> wasSelected = this.getSelectedChanges();
        this.myShowFlatten = showFlatten;
        this.myCards.show(this, this.myShowFlatten ? LIST_CARD : TREE_CARD);
        this.select(wasSelected);
        if (this.myList.hasFocus() || this.myTree.hasFocus()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChangesTreeList.this.requestFocus();
                }
            });
        }
    }

    @Override
    public void requestFocus() {
        if (this.myShowFlatten) {
            this.myList.requestFocus();
        } else {
            this.myTree.requestFocus();
        }
    }

    public void setChangesToDisplay(List<T> changes) {
        this.setChangesToDisplay(changes, null);
    }

    public void setChangesToDisplay(final List<T> changes, final @Nullable VirtualFile toSelect) {
        boolean wasEmpty = this.myList.isEmpty();
        final ArrayList<T> sortedChanges = new ArrayList<T>(changes);
        Collections.sort(sortedChanges, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return TreeModelBuilder.getPathForObject(o1).getName().compareToIgnoreCase(TreeModelBuilder.getPathForObject(o2).getName());
            }
        });
        THashSet wasSelected = new THashSet(Arrays.asList(this.myList.getSelectedValues()));
        this.myList.setModel((ListModel)new AbstractListModel(){

            @Override
            public int getSize() {
                return sortedChanges.size();
            }

            @Override
            public Object getElementAt(int index) {
                return sortedChanges.get(index);
            }
        });
        final DefaultTreeModel model = this.buildTreeModel(changes, this.myChangeDecorator);
        TreeState state = null;
        if (!this.myAlwaysExpandList && !wasEmpty) {
            state = TreeState.createOn((JTree)this.myTree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.myTree.getModel().getRoot()));
        }
        this.myTree.setModel((TreeModel)model);
        if (!this.myAlwaysExpandList && !wasEmpty) {
            state.applyTo((JTree)this.myTree, (DefaultMutableTreeNode)this.myTree.getModel().getRoot());
            TIntArrayList indices = new TIntArrayList();
            for (int i = 0; i < sortedChanges.size(); ++i) {
                Object t = sortedChanges.get(i);
                if (!wasSelected.contains(t)) continue;
                indices.add(i);
            }
            this.myList.setSelectedIndices(indices.toNativeArray());
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ChangesTreeList.this.myProject.isDisposed()) {
                    return;
                }
                TreeUtil.expandAll((JTree)ChangesTreeList.this.myTree);
                int listSelection = 0;
                int scrollRow = -1;
                if (ChangesTreeList.this.myShowCheckboxes) {
                    if (ChangesTreeList.this.myIncludedChanges.size() > 0) {
                        CheckboxTreeBase.NodeState state;
                        ChangesBrowserNode node;
                        for (int i = 0; i < sortedChanges.size(); ++i) {
                            Object t = sortedChanges.get(i);
                            if (!ChangesTreeList.this.myIncludedChanges.contains(t)) continue;
                            listSelection = i;
                            break;
                        }
                        ChangesBrowserNode root = (ChangesBrowserNode)model.getRoot();
                        Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            node = (ChangesBrowserNode)enumeration.nextElement();
                            state = ChangesTreeList.this.getNodeStatus(node);
                            if (node == root || state != CheckboxTreeBase.NodeState.CLEAR) continue;
                            ChangesTreeList.this.myTree.collapsePath(new TreePath(node.getPath()));
                        }
                        enumeration = root.depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            node = (ChangesBrowserNode)enumeration.nextElement();
                            state = ChangesTreeList.this.getNodeStatus(node);
                            if (state != CheckboxTreeBase.NodeState.FULL || !node.isLeaf()) continue;
                            scrollRow = ChangesTreeList.this.myTree.getRowForPath(new TreePath(node.getPath()));
                            break;
                        }
                    }
                } else if (toSelect != null) {
                    ChangesBrowserNode root = (ChangesBrowserNode)model.getRoot();
                    final int[] rowToSelect = new int[]{-1};
                    TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                        public boolean accept(Object node) {
                            Change change;
                            VirtualFile virtualFile;
                            Object userObject;
                            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change && ((virtualFile = (change = (Change)userObject).getVirtualFile()) != null && virtualFile.equals(toSelect) || ChangesTreeList.seemsToBeMoved(change, toSelect))) {
                                Object[] path = ((DefaultMutableTreeNode)node).getPath();
                                rowToSelect[0] = ChangesTreeList.this.myTree.getRowForPath(new TreePath(path));
                            }
                            return rowToSelect[0] == -1;
                        }
                    });
                    int n = scrollRow = rowToSelect[0] == -1 ? scrollRow : rowToSelect[0];
                }
                if (changes.size() > 0) {
                    ChangesTreeList.this.myList.setSelectedIndex(listSelection);
                    ChangesTreeList.this.myList.ensureIndexIsVisible(listSelection);
                    if (scrollRow >= 0) {
                        ChangesTreeList.this.myTree.setSelectionRow(scrollRow);
                    }
                    TreeUtil.showRowCentered((JTree)ChangesTreeList.this.myTree, (int)scrollRow, (boolean)false);
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static boolean seemsToBeMoved(Change change, VirtualFile toSelect) {
        ContentRevision afterRevision = change.getAfterRevision();
        if (afterRevision == null) {
            return false;
        }
        FilePath file = afterRevision.getFile();
        return FileUtil.pathsEqual((String)file.getPath(), (String)toSelect.getPath());
    }

    protected abstract DefaultTreeModel buildTreeModel(List<T> var1, ChangeNodeDecorator var2);

    private void toggleSelection() {
        boolean hasExcluded = false;
        for (T value : this.getSelectedChanges()) {
            if (this.myIncludedChanges.contains(value)) continue;
            hasExcluded = true;
        }
        if (hasExcluded) {
            this.includeSelection();
        } else {
            this.excludeSelection();
        }
        this.repaint();
    }

    private void includeSelection() {
        for (T change : this.getSelectedChanges()) {
            this.myIncludedChanges.add(change);
        }
        this.notifyInclusionListener();
        this.repaint();
    }

    private void excludeSelection() {
        for (T change : this.getSelectedChanges()) {
            this.myIncludedChanges.remove(change);
        }
        this.notifyInclusionListener();
        this.repaint();
    }

    public List<T> getChanges() {
        if (this.myShowFlatten) {
            ListModel m = this.myList.getModel();
            int size = m.getSize();
            ArrayList result = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                result.add(m.getElementAt(i));
            }
            return result;
        }
        final LinkedHashSet result = new LinkedHashSet();
        TreeUtil.traverseDepth((TreeNode)((ChangesBrowserNode)this.myTree.getModel().getRoot()), (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                ChangesBrowserNode changeNode = (ChangesBrowserNode)node;
                if (changeNode.isLeaf()) {
                    result.addAll(changeNode.getAllChangesUnder());
                }
                return true;
            }
        });
        return new ArrayList(result);
    }

    public int getSelectionCount() {
        if (this.myShowFlatten) {
            return this.myList.getSelectedIndices().length;
        }
        return this.myTree.getSelectionCount();
    }

    @NotNull
    public List<T> getSelectedChanges() {
        if (this.myShowFlatten) {
            ArrayList<Object> changes = new ArrayList<Object>();
            for (Object anO : this.myList.getSelectedValues()) {
                changes.add(anO);
            }
            ArrayList<Object> arrayList = changes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChanges"));
            }
            return arrayList;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChanges"));
            }
            return list;
        }
        LinkedHashSet changes = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            changes.addAll(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent()));
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)changes);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangesTreeList", "getSelectedChanges"));
        }
        return arrayList;
    }

    protected abstract List<T> getSelectedObjects(ChangesBrowserNode<T> var1);

    @Nullable
    protected abstract T getLeadSelectedObject(ChangesBrowserNode var1);

    @Nullable
    public T getHighestLeadSelection() {
        if (this.myShowFlatten) {
            int index = this.myList.getLeadSelectionIndex();
            ListModel listModel = this.myList.getModel();
            if (index < 0 || index >= listModel.getSize()) {
                return null;
            }
            return (T)listModel.getElementAt(index);
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return this.getLeadSelectedObject((ChangesBrowserNode)path.getLastPathComponent());
    }

    @Nullable
    public T getLeadSelection() {
        if (this.myShowFlatten) {
            int index = this.myList.getLeadSelectionIndex();
            ListModel listModel = this.myList.getModel();
            return index < 0 || index >= listModel.getSize() ? null : (T)listModel.getElementAt(index);
        }
        TreePath path = this.myTree.getSelectionPath();
        return (T)(path == null ? null : ContainerUtil.getFirstItem(this.getSelectedObjects((ChangesBrowserNode)path.getLastPathComponent())));
    }

    private void notifyInclusionListener() {
        if (this.myInclusionListener != null) {
            this.myInclusionListener.run();
        }
    }

    public void setIncludedChanges(Collection<T> changes) {
        this.myIncludedChanges.clear();
        this.myIncludedChanges.addAll(changes);
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void includeChange(T change) {
        this.myIncludedChanges.add(change);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void includeChanges(Collection<T> changes) {
        this.myIncludedChanges.addAll(changes);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void excludeChange(T change) {
        this.myIncludedChanges.remove(change);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public void excludeChanges(Collection<T> changes) {
        this.myIncludedChanges.removeAll(changes);
        this.notifyInclusionListener();
        this.myTree.repaint();
        this.myList.repaint();
    }

    public boolean isIncluded(T change) {
        return this.myIncludedChanges.contains(change);
    }

    public Collection<T> getIncludedChanges() {
        return this.myIncludedChanges;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)this.myTree);
    }

    public AnAction[] getTreeActions() {
        ToggleShowDirectoriesAction directoriesAction = new ToggleShowDirectoriesAction();
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)this.myTree){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!ChangesTreeList.this.myShowFlatten);
            }
        };
        CollapseAllAction collapseAllAction = new CollapseAllAction((JTree)this.myTree){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!ChangesTreeList.this.myShowFlatten);
            }
        };
        AnAction[] actions = new AnAction[]{directoriesAction, expandAllAction, collapseAllAction};
        directoriesAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(80, SystemInfo.isMac ? 256 : 128)), this);
        expandAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ExpandAll")), (JComponent)this.myTree);
        collapseAllAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("CollapseAll")), (JComponent)this.myTree);
        return actions;
    }

    public void setSelectionMode(@JdkConstants.ListSelectionMode int mode) {
        this.myList.setSelectionMode(mode);
        this.myTree.getSelectionModel().setSelectionMode(ChangesTreeList.getTreeSelectionModeFromListSelectionMode(mode));
    }

    @JdkConstants.TreeSelectionMode
    private static int getTreeSelectionModeFromListSelectionMode(@JdkConstants.ListSelectionMode int mode) {
        switch (mode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Illegal selection mode: " + mode);
    }

    private CheckboxTreeBase.NodeState getNodeStatus(ChangesBrowserNode<T> node) {
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (T change : this.getSelectedObjects(node)) {
            if (this.myIncludedChanges.contains(change)) {
                hasIncluded = true;
                continue;
            }
            hasExcluded = true;
        }
        if (hasIncluded && hasExcluded) {
            return CheckboxTreeBase.NodeState.PARTIAL;
        }
        if (hasIncluded) {
            return CheckboxTreeBase.NodeState.FULL;
        }
        return CheckboxTreeBase.NodeState.CLEAR;
    }

    public void select(final List<T> changes) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        final ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.traverse((TreeNode)root, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                Object change = ((DefaultMutableTreeNode)node).getUserObject();
                if (changes.contains(change)) {
                    treeSelection.add(new TreePath(((DefaultMutableTreeNode)node).getPath()));
                }
                return true;
            }
        });
        this.myTree.setSelectionPaths(treeSelection.toArray(new TreePath[treeSelection.size()]));
        ListModel model = this.myList.getModel();
        int size = model.getSize();
        ArrayList<Integer> listSelection = new ArrayList<Integer>(changes.size());
        for (int i = 0; i < size; ++i) {
            Object el = model.getElementAt(i);
            if (!changes.contains(el)) continue;
            listSelection.add(i);
        }
        this.myList.setSelectedIndices(ChangesTreeList.int2int(listSelection));
    }

    private static int[] int2int(List<Integer> treeSelection) {
        int[] toPass = new int[treeSelection.size()];
        int i = 0;
        for (Integer integer : treeSelection) {
            toPass[i] = integer;
            ++i;
        }
        return toPass;
    }

    public void enableSelection(boolean value) {
        this.myTree.setEnabled(value);
    }

    public void setAlwaysExpandList(boolean alwaysExpandList) {
        this.myAlwaysExpandList = alwaysExpandList;
    }

    public void setPaintBusy(boolean value) {
        this.myTree.setPaintBusy(value);
        this.myList.setPaintBusy(value);
    }

    public void calcData(DataKey key, DataSink sink) {
    }

    private class MyTree
    extends Tree
    implements TypeSafeDataProvider {
        private final Project myProject;
        private final int myCheckboxWidth;

        public MyTree(Project project, int checkboxWidth) {
            super((TreeNode)ChangesBrowserNode.create(ChangesTreeList.this.myProject, ChangesTreeList.ROOT));
            this.myProject = project;
            this.myCheckboxWidth = checkboxWidth;
        }

        public boolean isFileColorsEnabled() {
            boolean enabled = Registry.is((String)"file.colors.in.commit.dialog") && FileColorManager.getInstance((Project)this.myProject).isEnabled() && FileColorManager.getInstance((Project)this.myProject).isEnabledForProjectView();
            boolean opaque = this.isOpaque();
            if (enabled && opaque) {
                this.setOpaque(false);
            } else if (!enabled && !opaque) {
                this.setOpaque(true);
            }
            return enabled;
        }

        public Color getFileColorFor(Object object) {
            VirtualFile file = null;
            if (object instanceof FilePathImpl) {
                file = LocalFileSystem.getInstance().findFileByPath(((FilePathImpl)object).getPath());
            } else if (object instanceof Change) {
                file = ((Change)object).getVirtualFile();
            }
            if (file != null) {
                return FileColorManager.getInstance((Project)this.myProject).getFileColor(file);
            }
            return super.getFileColorFor(object);
        }

        public Dimension getPreferredScrollableViewportSize() {
            Dimension size = super.getPreferredScrollableViewportSize();
            size = new Dimension(size.width + 10, size.height);
            return size;
        }

        protected void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501) {
                if (!ChangesTreeList.this.myTree.isEnabled()) {
                    return;
                }
                int row = ChangesTreeList.this.myTree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    Rectangle baseRect = ChangesTreeList.this.myTree.getRowBounds(row);
                    baseRect.setSize(this.myCheckboxWidth, baseRect.height);
                    if (baseRect.contains(e.getPoint())) {
                        ChangesTreeList.this.myTree.setSelectionRow(row);
                        ChangesTreeList.this.toggleSelection();
                    }
                }
            }
            super.processMouseEvent(e);
        }

        public int getToggleClickCount() {
            return -1;
        }

        public void calcData(DataKey key, DataSink sink) {
            ChangesTreeList.this.calcData(key, sink);
        }
    }

    private class SelectAllAction
    extends AnAction {
        private SelectAllAction() {
            super("Select All", "Select all items", AllIcons.Actions.Selectall);
        }

        public void actionPerformed(AnActionEvent e) {
            if (ChangesTreeList.this.myShowFlatten) {
                int count = ChangesTreeList.this.myList.getModel().getSize();
                if (count > 0) {
                    ChangesTreeList.this.myList.setSelectionInterval(0, count - 1);
                }
            } else {
                int countTree = ChangesTreeList.this.myTree.getRowCount();
                if (countTree > 0) {
                    ChangesTreeList.this.myTree.setSelectionInterval(0, countTree - 1);
                }
            }
        }
    }

    public class ToggleShowDirectoriesAction
    extends ToggleAction
    implements DumbAware {
        public ToggleShowDirectoriesAction() {
            super(VcsBundle.message((String)"changes.action.show.directories.text", (Object[])new Object[0]), VcsBundle.message((String)"changes.action.show.directories.description", (Object[])new Object[0]), AllIcons.Actions.GroupByPackage);
        }

        public boolean isSelected(AnActionEvent e) {
            return !ChangesTreeList.this.myProject.isDisposed() && !PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).isTrueValue(ChangesTreeList.FLATTEN_OPTION_KEY);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PropertiesComponent.getInstance((Project)ChangesTreeList.this.myProject).setValue(ChangesTreeList.FLATTEN_OPTION_KEY, String.valueOf(!state));
            ChangesTreeList.this.setShowFlatten(!state);
        }
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            ChangesTreeList.this.toggleSelection();
        }
    }

    private class MyListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private final ColoredListCellRenderer myTextRenderer;
        public final JCheckBox myCheckbox;

        public MyListCellRenderer() {
            super(new BorderLayout());
            this.myCheckbox = new JCheckBox();
            this.myTextRenderer = new VirtualFileListCellRenderer(ChangesTreeList.this.myProject){

                @Override
                protected void putParentPath(Object value, FilePath path, FilePath self) {
                    boolean applyChangeDecorator;
                    super.putParentPath(value, path, self);
                    boolean bl = applyChangeDecorator = value instanceof Change && ChangesTreeList.this.myChangeDecorator != null;
                    if (applyChangeDecorator) {
                        ChangesTreeList.this.myChangeDecorator.decorate((Change)value, (SimpleColoredComponent)this, ChangesTreeList.this.isShowFlatten());
                    }
                }

                @Override
                protected void putParentPathImpl(Object value, String parentPath, FilePath self) {
                    boolean applyChangeDecorator = value instanceof Change && ChangesTreeList.this.myChangeDecorator != null;
                    List<Pair<String, ChangeNodeDecorator.Stress>> parts = null;
                    if (applyChangeDecorator) {
                        parts = ChangesTreeList.this.myChangeDecorator.stressPartsOfFileName((Change)value, parentPath);
                    }
                    if (parts == null) {
                        super.putParentPathImpl(value, parentPath, self);
                        return;
                    }
                    for (Pair pair : parts) {
                        this.append((String)pair.getFirst(), ((ChangeNodeDecorator.Stress)((Object)pair.getSecond())).derive(SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    }
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    Color color;
                    VirtualFile file;
                    Component component = super.getListCellRendererComponent(list, value, index, selected, hasFocus);
                    FileColorManager colorManager = FileColorManager.getInstance((Project)ChangesTreeList.this.myProject);
                    if (!selected && Registry.is((String)"file.colors.in.commit.dialog") && colorManager.isEnabled() && colorManager.isEnabledForProjectView() && value instanceof Change && (file = ((Change)value).getVirtualFile()) != null && (color = colorManager.getFileColor(file)) != null) {
                        component.setBackground(color);
                    }
                    return component;
                }
            };
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.add((Component)this.myCheckbox, "West");
            }
            this.add((Component)this.myTextRenderer, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myTextRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.myCheckbox.setSelected(ChangesTreeList.this.myIncludedChanges.contains(value));
                return this;
            }
            return this.myTextRenderer;
        }
    }

    private class MyTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        private final ChangesBrowserNodeRenderer myTextRenderer;
        private final JCheckBox myCheckBox;

        public MyTreeCellRenderer() {
            super(new BorderLayout());
            this.myCheckBox = new JCheckBox();
            this.myTextRenderer = new ChangesBrowserNodeRenderer(ChangesTreeList.this.myProject, false, ChangesTreeList.this.myHighlightProblems);
            if (ChangesTreeList.this.myShowCheckboxes) {
                this.add((Component)this.myCheckBox, "West");
            }
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
                NonOpaquePanel.setTransparent((JComponent)this);
                NonOpaquePanel.setTransparent((JComponent)this.myCheckBox);
            } else {
                this.setBackground(null);
                this.myCheckBox.setBackground(null);
                this.myCheckBox.setOpaque(false);
            }
            this.myTextRenderer.setOpaque(false);
            this.myTextRenderer.setTransparentIconBackground(true);
            this.myTextRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (ChangesTreeList.this.myShowCheckboxes) {
                CheckboxTreeBase.NodeState state = ChangesTreeList.this.getNodeStatus((ChangesBrowserNode)value);
                this.myCheckBox.setSelected(state != CheckboxTreeBase.NodeState.CLEAR);
                this.myCheckBox.setEnabled(state != CheckboxTreeBase.NodeState.PARTIAL);
                this.revalidate();
                return this;
            }
            return this.myTextRenderer;
        }
    }
}

