/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.artifacts;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactListener;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.EventDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactImpl
extends UserDataHolderBase
implements ModifiableArtifact {
    private CompositePackagingElement<?> myRootElement;
    private String myName;
    private boolean myBuildOnMake;
    private String myOutputPath;
    private final EventDispatcher<ArtifactListener> myDispatcher;
    private ArtifactType myArtifactType;
    private Map<ArtifactPropertiesProvider, ArtifactProperties<?>> myProperties;

    public ArtifactImpl(@NotNull String name, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        this(name, artifactType, buildOnMake, rootElement, outputPath, null);
    }

    public ArtifactImpl(@NotNull String name, @NotNull ArtifactType artifactType, boolean buildOnMake, @NotNull CompositePackagingElement<?> rootElement, String outputPath, EventDispatcher<ArtifactListener> dispatcher) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "<init>"));
        }
        this.myName = name;
        this.myArtifactType = artifactType;
        this.myBuildOnMake = buildOnMake;
        this.myRootElement = rootElement;
        this.myOutputPath = outputPath;
        this.myDispatcher = dispatcher;
        this.myProperties = new HashMap();
        this.resetProperties();
    }

    private void resetProperties() {
        this.myProperties.clear();
        for (ArtifactPropertiesProvider provider : ArtifactPropertiesProvider.getProviders()) {
            if (!provider.isAvailableFor(this.myArtifactType)) continue;
            this.myProperties.put(provider, provider.createProperties(this.myArtifactType));
        }
    }

    @NotNull
    public ArtifactType getArtifactType() {
        ArtifactType artifactType = this.myArtifactType;
        if (artifactType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "getArtifactType"));
        }
        return artifactType;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    @NotNull
    public CompositePackagingElement<?> getRootElement() {
        CompositePackagingElement<?> compositePackagingElement = this.myRootElement;
        if (compositePackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "getRootElement"));
        }
        return compositePackagingElement;
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public Collection<? extends ArtifactPropertiesProvider> getPropertiesProviders() {
        return Collections.unmodifiableCollection(this.myProperties.keySet());
    }

    public ArtifactImpl createCopy(EventDispatcher<ArtifactListener> dispatcher) {
        ArtifactImpl artifact = new ArtifactImpl(this.myName, this.myArtifactType, this.myBuildOnMake, this.myRootElement, this.myOutputPath, dispatcher);
        for (Map.Entry<ArtifactPropertiesProvider, ArtifactProperties<?>> entry : this.myProperties.entrySet()) {
            ArtifactProperties<?> newProperties = artifact.myProperties.get(entry.getKey());
            newProperties.loadState(entry.getValue().getState());
        }
        return artifact;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "setName"));
        }
        String oldName = this.myName;
        this.myName = name;
        if (this.myDispatcher != null) {
            ((ArtifactListener)this.myDispatcher.getMulticaster()).artifactChanged((Artifact)this, oldName);
        }
    }

    @NonNls
    public String toString() {
        return "artifact:" + this.myName;
    }

    public void setRootElement(CompositePackagingElement<?> root) {
        this.myRootElement = root;
    }

    public void setProperties(ArtifactPropertiesProvider provider, ArtifactProperties<?> properties) {
        if (properties != null) {
            this.myProperties.put(provider, properties);
        } else {
            this.myProperties.remove(provider);
        }
    }

    public void setArtifactType(@NotNull ArtifactType selected) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "setArtifactType"));
        }
        this.myArtifactType = selected;
        this.resetProperties();
    }

    public void setBuildOnMake(boolean buildOnMake) {
        this.myBuildOnMake = buildOnMake;
    }

    public void setOutputPath(String outputPath) {
        this.myOutputPath = outputPath;
    }

    public ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/packaging/impl/artifacts/ArtifactImpl", "getProperties"));
        }
        return this.myProperties.get(provider);
    }

    public VirtualFile getOutputFile() {
        String filePath = this.getOutputFilePath();
        return !StringUtil.isEmpty((String)filePath) ? LocalFileSystem.getInstance().findFileByPath(filePath) : null;
    }

    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        String filePath = this.myRootElement instanceof ArchivePackagingElement ? this.myOutputPath + "/" + ((ArchivePackagingElement)this.myRootElement).getArchiveFileName() : this.myOutputPath;
        return filePath;
    }

    @Nullable
    public String getOutputDirectoryPathToCleanOnRebuild() {
        if (this.myRootElement instanceof ArchivePackagingElement || StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        return this.myOutputPath;
    }

    public void copyFrom(ArtifactImpl modified) {
        this.myName = modified.getName();
        this.myOutputPath = modified.getOutputPath();
        this.myBuildOnMake = modified.isBuildOnMake();
        this.myRootElement = modified.getRootElement();
        this.myProperties = modified.myProperties;
        this.myArtifactType = modified.getArtifactType();
    }
}

