/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaBlock
extends AbstractJavaBlock {
    private final Map<IElementType, Wrap> myReservedWrap = ContainerUtil.newHashMap();
    private int myStartOffset = -1;

    public SimpleJavaBlock(ASTNode node, Wrap wrap, AlignmentStrategy alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        ASTNode child;
        int offset = this.myStartOffset != -1 ? this.myStartOffset : (child != null ? child.getTextRange().getStartOffset() : 0);
        ArrayList<Block> result = new ArrayList<Block>();
        Indent indent = null;
        for (child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType()) || child.getElementType() == JavaDocElementType.DOC_COMMENT) {
                result.add(SimpleJavaBlock.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, AlignmentStrategy.getNullStrategy()));
                indent = Indent.getNoneIndent();
            } else if (!FormatterUtil.containsWhiteSpacesOnly(child)) break;
            offset += child.getTextLength();
        }
        this.myReservedAlignment = this.createChildAlignment();
        this.myReservedAlignment2 = this.createChildAlignment2(this.myReservedAlignment);
        Wrap childWrap = this.createChildWrap();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                ASTNode astNode = child;
                AlignmentStrategy alignmentStrategyToUse = ALIGN_IN_COLUMNS_ELEMENT_TYPES.contains(this.myNode.getElementType()) ? this.myAlignmentStrategy : AlignmentStrategy.wrap(this.chooseAlignment(this.myReservedAlignment, this.myReservedAlignment2, child), new IElementType[0]);
                if (astNode != (child = this.processChild(result, astNode, alignmentStrategyToUse, childWrap, indent, offset)) && child != null) {
                    offset = child.getTextRange().getStartOffset();
                }
                if (indent != null && !(this.myNode.getPsi() instanceof PsiFile) && child != null && child.getElementType() != JavaElementType.MODIFIER_LIST) {
                    indent = Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
                }
            }
            if (child == null) continue;
            offset += child.getTextLength();
            child = child.getTreeNext();
        }
        return result;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myStartOffset == -1 ? super.getTextRange() : new TextRange(this.myStartOffset, this.myStartOffset + this.myNode.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getTextRange"));
        }
        return textRange;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == JavaElementType.CONDITIONAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_TERNARY_OPERATION) {
            Alignment usedAlignment = this.getUsedAlignment(newChildIndex);
            if (usedAlignment != null) {
                ChildAttributes childAttributes = new ChildAttributes(null, usedAlignment);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (this.myNode.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/SimpleJavaBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Override
    public Wrap getReservedWrap(IElementType elementType) {
        return this.myReservedWrap.get(elementType);
    }

    @Override
    public void setReservedWrap(Wrap reservedWrap, IElementType operationType) {
        this.myReservedWrap.put(operationType, reservedWrap);
    }

    public void setStartOffset(int startOffset) {
        this.myStartOffset = startOffset;
    }
}

