/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LeakHunter {
    private static final Map<Class, Field[]> allFields = new THashMap();
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final Processor<Project> NOT_DEFAULT_PROJECT = new Processor<Project>(){

        public boolean process(Project project) {
            return !project.isDefault();
        }
    };
    private static final Set<Object> visited = ContainerUtil.newIdentityTroveSet();
    private static final Stack<BackLink> toVisit = new Stack();
    private static final Key<Boolean> IS_NOT_A_LEAK = Key.create((String)"IS_NOT_A_LEAK");
    private static final Set<String> noFollowClasses = new THashSet();
    private static final Key<Boolean> REPORTED_LEAKED;

    private static Field[] getAllFields(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/LeakHunter", "getAllFields"));
        }
        Field[] cached = allFields.get(aClass);
        if (cached == null) {
            Field[] declaredFields = aClass.getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>(declaredFields.length + 5);
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                fields.add(declaredField);
            }
            Class superclass = aClass.getSuperclass();
            if (superclass != null) {
                for (Field sup : LeakHunter.getAllFields(superclass)) {
                    if (fields.contains(sup)) continue;
                    fields.add(sup);
                }
            }
            cached = fields.isEmpty() ? EMPTY_FIELD_ARRAY : fields.toArray(new Field[fields.size()]);
            allFields.put(aClass, cached);
        }
        return cached;
    }

    private static void walkObjects(@NotNull Class lookFor, @NotNull Processor<BackLink> leakProcessor) {
        if (lookFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookFor", "com/intellij/testFramework/LeakHunter", "walkObjects"));
        }
        if (leakProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leakProcessor", "com/intellij/testFramework/LeakHunter", "walkObjects"));
        }
        block5: while (!toVisit.isEmpty()) {
            BackLink backLink = (BackLink)toVisit.pop();
            Object root = backLink.value;
            if (!visited.add(root)) continue;
            Class rootClass = backLink.aClass;
            for (Field field : LeakHunter.getAllFields(rootClass)) {
                BackLink newBackLink;
                Object value;
                String fieldName = field.getName();
                if (root instanceof Reference && "referent".equals(fieldName)) continue;
                try {
                    value = field.get(root);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (value == null) continue;
                Class<?> valueClass = value.getClass();
                if (lookFor.isAssignableFrom(valueClass) && LeakHunter.isReallyLeak(field, fieldName, value, valueClass)) {
                    newBackLink = new BackLink(valueClass, value, field, backLink);
                    leakProcessor.process((Object)newBackLink);
                    continue;
                }
                newBackLink = new BackLink(valueClass, value, field, backLink);
                if (!LeakHunter.toFollow(valueClass)) continue;
                toVisit.push((Object)newBackLink);
            }
            if (!rootClass.isArray() || !LeakHunter.toFollow(rootClass.getComponentType())) continue;
            try {
                Object[] arr$ = (Object[])root;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block5;
                    Object o = arr$[i$];
                    if (o != null) {
                        Class<?> oClass = o.getClass();
                        toVisit.push((Object)new BackLink(oClass, o, null, backLink));
                    }
                    ++i$;
                }
            }
            catch (ClassCastException ignored) {
                continue;
            }
            break;
        }
        return;
    }

    public static void markAsNotALeak(@NotNull UserDataHolder object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/testFramework/LeakHunter", "markAsNotALeak"));
        }
        object.putUserData(IS_NOT_A_LEAK, (Object)Boolean.TRUE);
    }

    private static boolean isReallyLeak(Field field, String fieldName, Object value, Class valueClass) {
        return !(value instanceof UserDataHolder) || ((UserDataHolder)value).getUserData(IS_NOT_A_LEAK) == null;
    }

    private static boolean toFollow(Class oClass) {
        String name = oClass.getName();
        return !noFollowClasses.contains(name);
    }

    public static void checkProjectLeak() throws Exception {
        LeakHunter.checkLeak(ApplicationManager.getApplication(), ProjectImpl.class);
        LeakHunter.checkLeak(Extensions.getRootArea(), ProjectImpl.class, NOT_DEFAULT_PROJECT);
    }

    public static void checkLeak(@NotNull Object root, @NotNull Class suspectClass) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        LeakHunter.checkLeak(root, suspectClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void checkLeak(@NotNull Object root, @NotNull Class<T> suspectClass, final @Nullable Processor<? super T> isReallyLeak) throws AssertionError {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (suspectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspectClass", "com/intellij/testFramework/LeakHunter", "checkLeak"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
        PersistentEnumerator.clearCacheForTests();
        toVisit.clear();
        visited.clear();
        toVisit.push((Object)new BackLink(root.getClass(), root, null, null));
        try {
            LeakHunter.walkObjects(suspectClass, new Processor<BackLink>(){

                public boolean process(BackLink backLink) {
                    UserDataHolder leaked = (UserDataHolder)backLink.value;
                    if (((UserDataHolderBase)leaked).replace(REPORTED_LEAKED, null, (Object)Boolean.TRUE) && (isReallyLeak == null || isReallyLeak.process((Object)leaked))) {
                        String place = leaked instanceof Project ? PlatformTestCase.getCreationPlace((Project)leaked) : "";
                        System.out.println("Leaked object found:" + leaked + "; hash: " + System.identityHashCode(leaked) + "; place: " + place);
                        while (backLink != null) {
                            String valueStr;
                            try {
                                valueStr = backLink.value instanceof FList ? "FList" : String.valueOf(backLink.value);
                            }
                            catch (Throwable e) {
                                valueStr = "(" + e.getMessage() + " while computing .toString())";
                            }
                            System.out.println("-->" + backLink.field + "; Value: " + valueStr + "; " + backLink.aClass);
                            backLink = backLink.backLink;
                        }
                        System.out.println(";-----");
                        throw new AssertionError();
                    }
                    return true;
                }
            });
        }
        finally {
            visited.clear();
            ((THashSet)visited).compact();
            toVisit.clear();
            toVisit.trimToSize();
        }
    }

    static {
        noFollowClasses.add("java.lang.Boolean");
        noFollowClasses.add("java.lang.Byte");
        noFollowClasses.add("java.lang.Class");
        noFollowClasses.add("java.lang.Character");
        noFollowClasses.add("java.lang.Double");
        noFollowClasses.add("java.lang.Float");
        noFollowClasses.add("java.lang.Integer");
        noFollowClasses.add("java.lang.Long");
        noFollowClasses.add("java.lang.Object");
        noFollowClasses.add("java.lang.Short");
        noFollowClasses.add("java.lang.String");
        REPORTED_LEAKED = Key.create((String)"REPORTED_LEAKED");
    }

    private static class BackLink {
        private final Class aClass;
        private final Object value;
        private final Field field;
        private final BackLink backLink;

        private BackLink(@NotNull Class aClass, @NotNull Object value, Field field, BackLink backLink) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/testFramework/LeakHunter$BackLink", "<init>"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/testFramework/LeakHunter$BackLink", "<init>"));
            }
            this.aClass = aClass;
            this.value = value;
            this.field = field;
            this.backLink = backLink;
        }
    }
}

