/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.CompositeException;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String IDEA_MARKER_CLASS = "com.intellij.openapi.components.impl.stores.IdeaProjectStoreImpl";
    public static final String TEMP_DIR_MARKER = "unitTest_";
    protected static boolean OVERWRITE_TESTDATA;
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static final Random RNG;
    private static final String ORIGINAL_TEMP_DIR;
    protected final Disposable myTestRootDisposable = new Disposable(){

        public void dispose() {
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    };
    protected static String ourPathToKeep;
    private CodeStyleSettings myOldCodeStyleSettings;
    private String myTempDir;
    protected static final Key<String> CREATION_PLACE;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class DELETE_ON_EXIT_HOOK_CLASS;

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            String testName = this.getTestName(true);
            if (StringUtil.isEmptyOrSpaces((String)testName)) {
                testName = "";
            }
            testName = new File(testName).getName();
            this.myTempDir = FileUtil.toSystemDependentName((String)(ORIGINAL_TEMP_DIR + "/" + TEMP_DIR_MARKER + testName + "_" + RNG.nextInt(1000)));
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir);
        }
        ApplicationInfoImpl.setInPerformanceTest(this.isPerformanceTest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            Disposer.dispose((Disposable)this.myTestRootDisposable);
            UsefulTestCase.cleanupSwingDataStructures();
            UsefulTestCase.cleanupDeleteOnExitHookList();
        }
        finally {
            if (this.shouldContainTempFiles()) {
                FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                if (ourPathToKeep != null && FileUtil.isAncestor((String)this.myTempDir, (String)ourPathToKeep, (boolean)false)) {
                    File[] files = new File(this.myTempDir).listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (FileUtil.pathsEqual((String)file.getPath(), (String)ourPathToKeep)) continue;
                            FileUtil.delete((File)file);
                        }
                    }
                } else {
                    FileUtil.delete((File)new File(this.myTempDir));
                }
            }
        }
        UIUtil.removeLeakingAppleListeners();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupDeleteOnExitHookList() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> list;
        Class clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String path = (String)list.get(i);
            if (FileSystemUtil.getAttributes((String)path) != null && !new File(path).delete()) continue;
            Class clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    protected CompositeException checkForSettingsDamage() throws Exception {
        Application app = ApplicationManager.getApplication();
        if (this.isPerformanceTest() || app == null || app instanceof MockApplication) {
            return new CompositeException(new Throwable[0]);
        }
        CodeStyleSettings oldCodeStyleSettings = this.myOldCodeStyleSettings;
        this.myOldCodeStyleSettings = null;
        return UsefulTestCase.doCheckForSettingsDamage(oldCodeStyleSettings, this.getCurrentCodeStyleSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompositeException doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) throws Exception {
        if (oldCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldCodeStyleSettings", "com/intellij/testFramework/UsefulTestCase", "doCheckForSettingsDamage"));
        }
        if (currentCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentCodeStyleSettings", "com/intellij/testFramework/UsefulTestCase", "doCheckForSettingsDamage"));
        }
        CompositeException result = new CompositeException(new Throwable[0]);
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        try {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS, (String)"\n"));
        }
        catch (AssertionError error) {
            CodeInsightSettings clean = new CodeInsightSettings();
            for (Field field : clean.getClass().getFields()) {
                try {
                    ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            result.add((Throwable)((Object)error));
        }
        currentCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        try {
            UsefulTestCase.checkSettingsEqual((JDOMExternalizable)oldCodeStyleSettings, (JDOMExternalizable)currentCodeStyleSettings, "Code style settings damaged");
        }
        catch (AssertionError e) {
            result.add((Throwable)((Object)e));
        }
        finally {
            currentCodeStyleSettings.clearCodeStyleSettings();
        }
        try {
            InplaceRefactoring.checkCleared();
        }
        catch (AssertionError e) {
            result.add((Throwable)((Object)e));
        }
        try {
            StartMarkAction.checkCleared();
        }
        catch (AssertionError e) {
            result.add((Throwable)((Object)e));
        }
        return result;
    }

    protected void storeSettings() {
        if (!this.isPerformanceTest() && ApplicationManager.getApplication() != null) {
            this.myOldCodeStyleSettings = this.getCurrentCodeStyleSettings().clone();
            this.myOldCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        }
    }

    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getInstance().getCurrentSettings();
    }

    public Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    protected void runTest() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    UsefulTestCase.super.runTest();
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throwables[0] = e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throwables[0] = e;
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        return PlatformTestUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    public static void edt(Runnable r) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)r);
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/testFramework/UsefulTestCase", "invokeTestRunnable"));
        }
        UIUtil.invokeAndWaitIfNeeded((Runnable)runnable);
    }

    protected void defaultRunBare() throws Throwable {
        super.runBare();
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            final Throwable[] exception = new Throwable[]{null};
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            UsefulTestCase.this.defaultRunBare();
                        }
                        catch (Throwable tearingDown) {
                            if (exception[0] != null) break block2;
                            exception[0] = tearingDown;
                        }
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        return true;
    }

    @NonNls
    public static String toString(Iterable<?> collection) {
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((THashSet)o));
            } else {
                builder.append(o);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static <T> void assertOrderedEquals(T[] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    public static <T> void assertOrderedEquals(Iterable<T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual, @NotNull byte[] expected) {
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "com/intellij/testFramework/UsefulTestCase", "assertOrderedEquals"));
        }
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/testFramework/UsefulTestCase", "assertOrderedEquals"));
        }
        UsefulTestCase.assertEquals((int)actual.length, (int)expected.length);
        for (int i = 0; i < actual.length; ++i) {
            byte a = actual[i];
            byte e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (byte)e, (byte)a);
        }
    }

    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<T> actual, T ... expected) {
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "com/intellij/testFramework/UsefulTestCase", "assertOrderedEquals"));
        }
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/testFramework/UsefulTestCase", "assertOrderedEquals"));
        }
        Assert.assertNotNull(actual);
        Assert.assertNotNull(expected);
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(Iterable<? extends T> actual, Collection<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static <T> void assertOrderedEquals(String erroMsg, Iterable<? extends T> actual, Collection<? extends T> expected) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : actual) {
            list.add(t);
        }
        if (!list.equals(new ArrayList<T>(expected))) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)erroMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    public static <T> void assertOrderedCollection(T[] collection, Consumer<T> ... checkers) {
        if (checkers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkers", "com/intellij/testFramework/UsefulTestCase", "assertOrderedCollection"));
        }
        Assert.assertNotNull(collection);
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertSameElements(T[] collection, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(collection), expected);
    }

    public static <T> void assertSameElements(Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertSameElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(Collection<? extends T> collection, Collection<T> expected) {
        UsefulTestCase.assertSameElements(null, collection, expected);
    }

    public static <T> void assertSameElements(String message, Collection<? extends T> collection, Collection<T> expected) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertNotNull(expected);
        if (collection.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(collection))) {
            Assert.assertEquals((String)message, (Object)UsefulTestCase.toString(expected, "\n"), (Object)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals((String)message, new HashSet<T>(expected), new HashSet<T>(collection));
        }
    }

    public <T> void assertContainsOrdered(Collection<? extends T> collection, T ... expected) {
        this.assertContainsOrdered(collection, (Collection<T>)Arrays.asList(expected));
    }

    public <T> void assertContainsOrdered(Collection<? extends T> collection, Collection<T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertOrderedEquals(UsefulTestCase.toString(collection), copy, expected);
    }

    public <T> void assertContainsElements(Collection<? extends T> collection, T ... expected) {
        this.assertContainsElements(collection, (Collection<T>)Arrays.asList(expected));
    }

    public <T> void assertContainsElements(Collection<? extends T> collection, Collection<T> expected) {
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    public static String toString(Object[] collection, String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    public <T> void assertDoesntContain(Collection<? extends T> collection, T ... notExpected) {
        this.assertDoesntContain(collection, (Collection<T>)Arrays.asList(notExpected));
    }

    public <T> void assertDoesntContain(Collection<? extends T> collection, Collection<T> notExpected) {
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    public static String toString(Collection<?> collection, String separator) {
        List list = ContainerUtil.map2List(collection, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                return String.valueOf(o);
            }
        });
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        return builder.toString();
    }

    public static <T> void assertOrderedCollection(Collection<? extends T> collection, Consumer<T> ... checkers) {
        Assert.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    public static <T> void assertUnorderedCollection(T[] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    public static <T> void assertUnorderedCollection(Collection<? extends T> collection, Consumer<T> ... checkers) {
        Assert.assertNotNull(collection);
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer : checkerSet) {
                Throwable error = UsefulTestCase.accepts(consumer, actual);
                if (error == null) {
                    checkerSet.remove(consumer);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(Consumer<T> condition, T actual) {
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    public static <T> T assertInstanceOf(Object o, Class<T> aClass) {
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(Collection<T> collection) {
        Assert.assertNotNull(collection);
        Iterator<T> iterator = collection.iterator();
        String toString = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator.hasNext());
        T t = iterator.next();
        Assert.assertFalse((String)toString, (boolean)iterator.hasNext());
        return t;
    }

    public static <T> T assertOneElement(T[] ts) {
        Assert.assertNotNull(ts);
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    public static <T> void assertOneOf(T value, T ... values) {
        boolean found = false;
        for (T v : values) {
            if (value != v && (value == null || !value.equals(v))) continue;
            found = true;
        }
        Assert.assertTrue((String)(value + " should be equal to one of " + Arrays.toString(values)), (boolean)found);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole("Thread dump:");
    }

    public static void assertEmpty(Object[] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }

    public static void assertEmpty(Collection<?> collection) {
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(String errorMsg, Collection<T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, new Object[0]);
    }

    public static void assertSize(int expectedSize, Object[] array) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
    }

    public static void assertSize(int expectedSize, Collection<?> c) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myTestRootDisposable, disposable);
        return disposable;
    }

    public static void assertSameLines(String expected, String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((Object)expectedText, (Object)actualText);
    }

    public static void assertExists(File file) {
        UsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(File file) {
        UsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        return UsefulTestCase.getTestName(name, lowercaseFirstLetter);
    }

    public static String getTestName(String name, boolean lowercaseFirstLetter) {
        if (name == null) {
            return "";
        }
        if (StringUtil.isEmpty((String)(name = StringUtil.trimStart((String)name, (String)"test")))) {
            return "";
        }
        return UsefulTestCase.lowercaseFirstLetter(name, lowercaseFirstLetter);
    }

    public static String lowercaseFirstLetter(String name, boolean lowercaseFirstLetter) {
        if (lowercaseFirstLetter && !UsefulTestCase.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public static boolean isAllUppercaseName(String name) {
        int uppercaseChars = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLowerCase(name.charAt(i))) {
                return false;
            }
            if (!Character.isUpperCase(name.charAt(i))) continue;
            ++uppercaseChars;
        }
        return uppercaseChars >= 3;
    }

    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    protected static void assertSameLinesWithFile(String filePath, String actualText) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)fileText.trim());
        String actual = StringUtil.convertLineSeparators((String)actualText.trim());
        if (!Comparing.equal((String)expected, (String)actual)) {
            throw new FileComparisonFailure(null, expected, actual, filePath);
        }
    }

    public static void clearFields(Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(Object test, Class aClass) throws IllegalAccessException {
        if (aClass == null) {
            return;
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    protected static void checkSettingsEqual(JDOMExternalizable expected, JDOMExternalizable settings, String message) throws Exception {
        if (expected == null || settings == null) {
            return;
        }
        Element oldS = new Element("temp");
        expected.writeExternal(oldS);
        Element newS = new Element("temp");
        settings.writeExternal(newS);
        String newString = JDOMUtil.writeElement((Element)newS, (String)"\n");
        String oldString = JDOMUtil.writeElement((Element)oldS, (String)"\n");
        Assert.assertEquals((String)message, (Object)oldString, (Object)newString);
    }

    public boolean isPerformanceTest() {
        String name = this.getName();
        return name != null && name.contains("Performance") || ((Object)((Object)this)).getClass().getName().contains("Performance");
    }

    public static void doPostponedFormatting(final Project project) {
        DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                PostprocessReformattingAspect.getInstance(project).doPostponedFormatting();
            }
        });
    }

    protected static void checkAllTimersAreDisposed() {
        Object timer;
        Object timerQueue;
        Field firstTimerF;
        try {
            Class<?> TimerQueueC = Class.forName("javax.swing.TimerQueue");
            Method sharedInstance = TimerQueueC.getDeclaredMethod("sharedInstance", new Class[0]);
            sharedInstance.setAccessible(true);
            firstTimerF = ReflectionUtil.getDeclaredField(TimerQueueC, (String)"firstTimer");
            timerQueue = sharedInstance.invoke(null, new Object[0]);
            if (firstTimerF == null) {
                DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(TimerQueueC, (Object)timerQueue, DelayQueue.class, (String)"queue");
                timer = delayQueue.peek();
            } else {
                firstTimerF.setAccessible(true);
                timer = firstTimerF.get(timerQueue);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (timer != null) {
            if (firstTimerF != null) {
                ReflectionUtil.resetField((Object)timerQueue, (Field)firstTimerF);
            }
            String text = "";
            if (timer instanceof Delayed) {
                long delay = ((Delayed)timer).getDelay(TimeUnit.MILLISECONDS);
                text = "(delayed for " + delay + "ms)";
                Method getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
                getTimer.setAccessible(true);
                try {
                    timer = getTimer.invoke(timer, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Timer t = (Timer)timer;
            text = "Timer (listeners: " + Arrays.asList(t.getActionListeners()) + ") " + text;
            UsefulTestCase.fail((String)("Not disposed Timer: " + text + "; queue:" + timerQueue));
        }
    }

    protected void assertException(AbstractExceptionCase exceptionCase) throws Throwable {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) throws Throwable {
        UsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    protected void assertNoException(AbstractExceptionCase exceptionCase) throws Throwable {
        UsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertExceptionOccurred(boolean shouldOccur, AbstractExceptionCase exceptionCase, String expectedErrorMsg) throws Throwable {
        block9: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                if (shouldOccur) {
                    wasThrown = true;
                    String errorMessage = exceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)errorMessage, exceptionCase.getExpectedExceptionClass(), e.getClass());
                    if (expectedErrorMsg != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)expectedErrorMsg, (String)e.getMessage());
                    }
                    break block9;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(e.getClass())) {
                    wasThrown = true;
                    System.out.println("");
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + e.getMessage()));
                    break block9;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)exceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/testFramework/UsefulTestCase", "annotatedWith"));
        }
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    protected static boolean isInHeadlessEnvironment() {
        return GraphicsEnvironment.isHeadless();
    }

    public static void refreshRecursively(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase", "refreshRecursively"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$6", "visitFile"));
                }
                file.getChildren();
                return true;
            }
        });
        file.refresh(false, true);
    }

    @NotNull
    public static Test filteredSuite(@RegExp String regexp, @NotNull Test test) {
        if (test == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "test", "com/intellij/testFramework/UsefulTestCase", "filteredSuite"));
        }
        final Pattern pattern = Pattern.compile(regexp);
        final TestSuite testSuite = new TestSuite();
        new Processor<Test>(){

            public boolean process(Test test) {
                if (test instanceof TestSuite) {
                    int len = ((TestSuite)test).testCount();
                    for (int i = 0; i < len; ++i) {
                        this.process(((TestSuite)test).testAt(i));
                    }
                } else if (pattern.matcher(test.toString()).find()) {
                    testSuite.addTest(test);
                }
                return false;
            }
        }.process(test);
        TestSuite testSuite2 = testSuite;
        if (testSuite2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/UsefulTestCase", "filteredSuite"));
        }
        return testSuite2;
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase", "refreshAndFindFile"));
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
        });
    }

    public static <E extends Exception> void invokeAndWaitIfNeeded(final @NotNull ThrowableRunnable<E> runnable) throws Exception {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/testFramework/UsefulTestCase", "invokeAndWaitIfNeeded"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            final Ref ref = Ref.create();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        ref.set((Object)e);
                    }
                }
            });
            if (!ref.isNull()) {
                throw (Exception)ref.get();
            }
        }
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = false;
        RNG = new SecureRandom();
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        ourPathToKeep = null;
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            CodeInsightSettings defaultSettings = new CodeInsightSettings();
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS, (String)"\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getField(aClass, null, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }
}

