/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBListTableFocusTraversalPolicy;
import com.intellij.util.ui.table.JBListTableModel;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import com.intellij.util.ui.table.MouseSuppressor;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public abstract class JBListTable {
    protected final JTable myInternalTable;
    private final JBTable mainTable;
    private final RowResizeAnimator myRowResizeAnimator;
    private final Disposable myOnRemoveDisposable;
    private MouseEvent myMouseEvent;
    private MyCellEditor myCellEditor;
    private int myLastFocusedEditorComponentIdx;

    public JBListTable(final @NotNull JTable t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/ui/table/JBListTable", "<init>"));
        }
        this.myLastFocusedEditorComponentIdx = -1;
        this.myInternalTable = t;
        this.myOnRemoveDisposable = Disposer.newDisposable();
        final JBListTableModel model = new JBListTableModel(t.getModel()){

            @Override
            public JBTableRow getRow(int index) {
                return JBListTable.this.getRowAt(index);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return JBListTable.this.isRowEditable(rowIndex);
            }

            @Override
            public void addRow() {
                JBListTable.this.myLastFocusedEditorComponentIdx = -1;
                super.addRow();
            }
        };
        this.mainTable = new JBTable(model){

            public void editingStopped(ChangeEvent e) {
                super.editingStopped(e);
            }

            public void editingCanceled(ChangeEvent e) {
                super.editingCanceled(e);
            }

            protected void processKeyEvent(KeyEvent e) {
                JBListTable.this.myMouseEvent = null;
                if (e.isAltDown()) {
                    super.processKeyEvent(e);
                    return;
                }
                if (e.getKeyCode() == 9) {
                    if (e.getID() == 401) {
                        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        if (e.isShiftDown()) {
                            keyboardFocusManager.focusPreviousComponent((Component)((Object)this));
                        } else {
                            keyboardFocusManager.focusNextComponent((Component)((Object)this));
                        }
                    }
                    e.consume();
                    return;
                }
                super.processKeyEvent(e);
            }

            protected void processMouseEvent(MouseEvent e) {
                JBListTable.this.myMouseEvent = e;
                super.processMouseEvent(e);
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                final JBTableRowRenderer rowRenderer = JBListTable.this.getRowRenderer(row);
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int col) {
                        return rowRenderer.getRowRendererComponent(t, row, selected, focused);
                    }
                };
            }

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                boolean isDown;
                int row;
                if (e.isAltDown() || e.isMetaDown() || e.isControlDown()) {
                    return false;
                }
                if (e.getKeyCode() == 27 && pressed && (row = this.getSelectedRow()) != -1 && JBListTable.this.isRowEmpty(row)) {
                    int newRow;
                    int count = model.getRowCount();
                    model.removeRow(row);
                    int n = newRow = count == row + 1 ? row - 1 : row;
                    if (0 <= newRow && newRow < model.getRowCount()) {
                        this.setRowSelectionInterval(newRow, newRow);
                    }
                }
                if (e.getKeyCode() == 10) {
                    if (e.getID() == 401) {
                        if (!this.isEditing() && e.getModifiers() == 0) {
                            this.editCellAt(this.getSelectedRow(), this.getSelectedColumn());
                        } else if (this.isEditing()) {
                            TableUtil.stopEditing((JTable)((Object)this));
                            if (e.isControlDown() || e.isMetaDown()) {
                                return false;
                            }
                            row = this.getSelectedRow() + 1;
                            if (row < this.getRowCount()) {
                                this.getSelectionModel().setSelectionInterval(row, row);
                            }
                        } else if (e.isControlDown() || e.isMetaDown()) {
                            return false;
                        }
                    }
                    e.consume();
                    return true;
                }
                if (this.isEditing() && e.getKeyCode() == 9) {
                    if (pressed) {
                        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                        if (e.isShiftDown()) {
                            mgr.focusPreviousComponent();
                        } else {
                            mgr.focusNextComponent();
                        }
                    }
                    return true;
                }
                boolean isUp = e.getKeyCode() == 38;
                boolean bl = isDown = e.getKeyCode() == 40;
                if (this.isEditing() && (isUp || isDown) && e.getModifiers() == 0 && e.getID() == 401) {
                    int row2 = this.getSelectedRow();
                    super.processKeyBinding(ks, e, condition, pressed);
                    if (!this.isEditing() && row2 != this.getSelectedRow()) {
                        TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)0);
                        e.consume();
                        return true;
                    }
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            public void columnMarginChanged(ChangeEvent e) {
                TableColumn resizingColumn;
                TableColumn tableColumn = resizingColumn = this.tableHeader != null ? this.tableHeader.getResizingColumn() : null;
                if (resizingColumn != null && this.autoResizeMode == 0) {
                    resizingColumn.setPreferredWidth(resizingColumn.getWidth());
                }
                this.resizeAndRepaint();
            }

            public TableCellEditor getCellEditor(int row, int column) {
                JBTableRowEditor editor = JBListTable.this.getRowEditor(row);
                if (editor != null) {
                    editor.setMouseEvent(JBListTable.this.myMouseEvent);
                    editor.prepareEditor(t, row);
                    JBListTable.installPaddingAndBordersForEditors(editor);
                    editor.setFocusCycleRoot(true);
                    editor.setFocusTraversalPolicy(new JBListTableFocusTraversalPolicy(editor));
                    MouseSuppressor.install(editor);
                    JBListTable.this.myCellEditor = new MyCellEditor(editor);
                    return JBListTable.this.myCellEditor;
                }
                JBListTable.this.myCellEditor = null;
                return JBListTable.this.myCellEditor;
            }

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Object value = this.getValueAt(row, column);
                boolean isSelected = this.isCellSelected(row, column);
                return editor.getTableCellEditorComponent((JTable)((Object)this), value, isSelected, row, column);
            }

            public void addNotify() {
                super.addNotify();
                Disposer.register((Disposable)JBListTable.this.myOnRemoveDisposable, (Disposable)JBListTable.this.myRowResizeAnimator);
            }

            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)JBListTable.this.myOnRemoveDisposable);
            }
        };
        this.mainTable.setStriped(true);
        this.myRowResizeAnimator = new RowResizeAnimator((JTable)this.mainTable);
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.mainTable);
    }

    public Disposable getOnRemoveDisposable() {
        return this.myOnRemoveDisposable;
    }

    private static void installPaddingAndBordersForEditors(JBTableRowEditor editor) {
        List editors = UIUtil.findComponentsOfType((JComponent)editor, EditorTextField.class);
        for (EditorTextField textField : editors) {
            textField.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
            textField.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        }
    }

    public final JBTable getTable() {
        return this.mainTable;
    }

    protected abstract JBTableRowRenderer getRowRenderer(int var1);

    protected abstract JBTableRowEditor getRowEditor(int var1);

    protected JBTableRow getRowAt(final int row) {
        return new JBTableRow(){

            @Override
            public Object getValueAt(int column) {
                return JBListTable.this.myInternalTable.getValueAt(row, column);
            }
        };
    }

    protected boolean isRowEditable(int row) {
        return true;
    }

    protected boolean isRowEmpty(int row) {
        return false;
    }

    public static JComponent createEditorTextFieldPresentation(Project project, FileType type, String text, boolean selected, boolean focused) {
        JPanel panel = new JPanel(new BorderLayout());
        EditorTextField field = new EditorTextField(text, project, type){

            @Override
            protected boolean shouldHaveBorder() {
                return false;
            }
        };
        Font font = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN);
        font = new Font(font.getFontName(), font.getStyle(), 12);
        field.setFont(font);
        field.addSettingsProvider(EditorSettingsProvider.NO_WHITESPACE);
        if (selected && focused) {
            panel.setBackground(UIUtil.getTableSelectionBackground());
            field.setAsRendererWithSelection(UIUtil.getTableSelectionBackground(), UIUtil.getTableSelectionForeground());
        } else {
            panel.setBackground(UIUtil.getTableBackground());
            if (selected) {
                panel.setBorder((Border)new DottedBorder(UIUtil.getTableForeground()));
            }
        }
        panel.add((Component)((Object)field), "West");
        return panel;
    }

    private static class RowResizeAnimator
    implements ActionListener,
    Disposable {
        private static final int ANIMATION_STEP_MILLIS = 15;
        private static final int RESIZE_AMOUNT_PER_STEP = 5;
        private final TIntObjectHashMap<RowAnimationState> myRowAnimationStates = new TIntObjectHashMap();
        private final Timer myAnimationTimer = new Timer(15, this);
        private final JTable myTable;

        public RowResizeAnimator(JTable table) {
            this.myTable = table;
        }

        public void resize(int row, int targetHeight) {
            this.myRowAnimationStates.put(row, (Object)new RowAnimationState(row, targetHeight));
            this.startAnimation();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doAnimationStep(e.getWhen());
        }

        public void dispose() {
            this.stopAnimation();
        }

        private void startAnimation() {
            if (!this.myAnimationTimer.isRunning()) {
                this.myAnimationTimer.start();
            }
        }

        private void stopAnimation() {
            this.myAnimationTimer.stop();
        }

        private void doAnimationStep(final long updateTime) {
            final TIntArrayList completeRows = new TIntArrayList(this.myRowAnimationStates.size());
            this.myRowAnimationStates.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<RowAnimationState>(){

                public boolean execute(int row, RowAnimationState animationState) {
                    if (animationState.doAnimationStep(updateTime)) {
                        completeRows.add(row);
                    }
                    return true;
                }
            });
            completeRows.forEach(new TIntProcedure(){

                public boolean execute(int row) {
                    RowResizeAnimator.this.myRowAnimationStates.remove(row);
                    return true;
                }
            });
            if (this.myRowAnimationStates.isEmpty()) {
                this.stopAnimation();
            }
        }

        private class RowAnimationState {
            private final int myRow;
            private final int myTargetHeight;
            private long myLastUpdateTime;

            public RowAnimationState(int row, int targetHeight) {
                this.myRow = row;
                this.myTargetHeight = targetHeight;
                this.myLastUpdateTime = System.currentTimeMillis();
            }

            public boolean doAnimationStep(long currentTime) {
                int currentRowHeight = RowResizeAnimator.this.myTable.getRowHeight(this.myRow);
                int resizeAbs = (int)(5.0 * ((double)(currentTime - this.myLastUpdateTime) / 15.0));
                int leftToAnimate = this.myTargetHeight - currentRowHeight;
                int newHeight = Math.abs(leftToAnimate) <= Math.abs(resizeAbs) ? this.myTargetHeight : currentRowHeight + (leftToAnimate < 0 ? -resizeAbs : resizeAbs);
                RowResizeAnimator.this.myTable.setRowHeight(this.myRow, newHeight);
                this.myLastUpdateTime = currentTime;
                return this.myTargetHeight == newHeight;
            }
        }
    }

    private class MyCellEditor
    extends AbstractTableCellEditor {
        private final JBTableRowEditor myEditor;

        public MyCellEditor(JBTableRowEditor editor) {
            this.myEditor = editor;
        }

        public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, int column) {
            final JPanel p = new JPanel(new BorderLayout()){

                @Override
                public void addNotify() {
                    super.addNotify();
                    int height = this.getPreferredSize().height;
                    if (height > table.getRowHeight(row)) {
                        JBListTable.this.myRowResizeAnimator.resize(row, height);
                    }
                }

                @Override
                public void removeNotify() {
                    if (JBListTable.this.myCellEditor != null) {
                        JBListTable.this.myCellEditor.saveFocusIndex();
                    }
                    super.removeNotify();
                    JBListTable.this.myRowResizeAnimator.resize(row, table.getRowHeight());
                }
            };
            p.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)p);
                    focusManager.requestFocus(this.getComponentToFocus(), true);
                }

                private Component getComponentToFocus() {
                    if (JBListTable.this.myLastFocusedEditorComponentIdx >= 0) {
                        JComponent[] focusableComponents = MyCellEditor.this.myEditor.getFocusableComponents();
                        if (JBListTable.this.myLastFocusedEditorComponentIdx < focusableComponents.length) {
                            return focusableComponents[JBListTable.this.myLastFocusedEditorComponentIdx];
                        }
                    }
                    return MyCellEditor.this.myEditor.getPreferredFocusedComponent();
                }
            });
            p.add((Component)this.myEditor, "Center");
            return p;
        }

        public Object getCellEditorValue() {
            return this.myEditor.getValue();
        }

        public boolean stopCellEditing() {
            this.saveFocusIndex();
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.saveFocusIndex();
            super.cancelCellEditing();
        }

        private void saveFocusIndex() {
            JComponent[] components = this.myEditor.getFocusableComponents();
            for (int i = 0; i < components.length; ++i) {
                if (!components[i].hasFocus()) continue;
                JBListTable.this.myLastFocusedEditorComponentIdx = i;
                break;
            }
        }
    }
}

