/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.index;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;

public class DomElementClassIndex
extends StringStubIndexExtension<PsiFile> {
    public static final StubIndexKey<String, PsiFile> KEY = StubIndexKey.createIndexKey((String)"dom.elementClass");
    private static final DomElementClassIndex ourInstance = new DomElementClassIndex();

    public static DomElementClassIndex getInstance() {
        return ourInstance;
    }

    public boolean hasStubElementsOfType(DomFileElement domFileElement, Class<? extends DomElement> clazz) {
        VirtualFile file = domFileElement.getFile().getVirtualFile();
        if (!(file instanceof VirtualFileWithId)) {
            return false;
        }
        String clazzName = clazz.getName();
        final int virtualFileId = ((VirtualFileWithId)file).getId();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        StubIndex.getInstance().processElements(KEY, (Object)clazzName, domFileElement.getFile().getProject(), GlobalSearchScope.fileScope((PsiFile)domFileElement.getFile()), new IdFilter(){

            public boolean containsFileId(int id) {
                return id == virtualFileId;
            }
        }, PsiFile.class, (Processor)processor);
        return processor.isFound();
    }

    @NotNull
    public StubIndexKey<String, PsiFile> getKey() {
        StubIndexKey<String, PsiFile> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/index/DomElementClassIndex", "getKey"));
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return 0;
    }
}

