/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.visible.adapters;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LinearGraphWithHiddenNodes;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.IdFlags;
import com.intellij.vcs.log.graph.utils.ListenerController;
import com.intellij.vcs.log.graph.utils.impl.SetListenerController;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LinearGraphAsGraphWithHiddenNodes
implements LinearGraphWithHiddenNodes {
    @NotNull
    private final LinearGraph myDelegateGraph;
    @NotNull
    private final Flags myVisibleNodes;
    @NotNull
    private final SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> myListenerController;

    public LinearGraphAsGraphWithHiddenNodes(@NotNull LinearGraph delegateGraph) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "<init>"));
        }
        this(delegateGraph, new IdFlags(delegateGraph.nodesCount(), true));
    }

    public LinearGraphAsGraphWithHiddenNodes(@NotNull LinearGraph delegateGraph, @NotNull Flags visibleNodes) {
        if (delegateGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateGraph", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "<init>"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "<init>"));
        }
        this.myListenerController = new SetListenerController();
        this.myDelegateGraph = delegateGraph;
        this.myVisibleNodes = visibleNodes;
    }

    @Override
    public boolean nodeIsVisible(int nodeIndex) {
        return this.myVisibleNodes.get(nodeIndex);
    }

    @Override
    @NotNull
    public GraphNode.Type getNodeType(int nodeIndex) {
        GraphNode.Type type = GraphNode.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "getNodeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public GraphEdge.Type getEdgeType(int upNodeIndex, int downNodeIndex) {
        GraphEdge.Type type = GraphEdge.Type.USUAL;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "getEdgeType"));
        }
        return type;
    }

    @Override
    @NotNull
    public ListenerController<LinearGraphWithHiddenNodes.UpdateListener> getListenerController() {
        SetListenerController<LinearGraphWithHiddenNodes.UpdateListener> setListenerController = this.myListenerController;
        if (setListenerController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "getListenerController"));
        }
        return setListenerController;
    }

    @Override
    public int nodesCount() {
        return this.myDelegateGraph.nodesCount();
    }

    @Override
    @NotNull
    public List<Integer> getUpNodes(int nodeIndex) {
        List<Integer> list = this.myDelegateGraph.getUpNodes(nodeIndex);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "getUpNodes"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Integer> getDownNodes(int nodeIndex) {
        List<Integer> list = this.myDelegateGraph.getDownNodes(nodeIndex);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/visible/adapters/LinearGraphAsGraphWithHiddenNodes", "getDownNodes"));
        }
        return list;
    }
}

