/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.ui.filter.FilterModel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FilterPopupComponent<Filter extends VcsLogFilter>
extends JPanel {
    protected static final String ALL = "All";
    private static final int GAP_BEFORE_ARROW = 3;
    private static final int BORDER_SIZE = 2;
    private static final Border INNER_MARGIN_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border FOCUSED_BORDER = FilterPopupComponent.createFocusedBorder();
    private static final Border UNFOCUSED_BORDER = FilterPopupComponent.createUnfocusedBorder();
    @NotNull
    private final JLabel myFilterNameLabel;
    @NotNull
    private final JLabel myFilterValueLabel;
    @NotNull
    protected final FilterModel<Filter> myFilterModel;

    FilterPopupComponent(@NotNull String filterName, @NotNull FilterModel<Filter> filterModel) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "<init>"));
        }
        this.myFilterModel = filterModel;
        this.myFilterNameLabel = new JLabel(filterName + ": ");
        this.myFilterValueLabel = new JLabel(){

            @Override
            public String getText() {
                Object filter = FilterPopupComponent.this.myFilterModel.getFilter();
                return filter == null ? FilterPopupComponent.ALL : FilterPopupComponent.this.getText(filter);
            }
        };
        this.setDefaultForeground();
        this.setFocusable(true);
        this.setBorder(UNFOCUSED_BORDER);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.myFilterNameLabel);
        this.add(this.myFilterValueLabel);
        this.add(Box.createHorizontalStrut(3));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
        this.updateLabelOnFilterChange();
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
    }

    private void updateLabelOnFilterChange() {
        this.myFilterModel.addSetFilterListener(new Runnable(){

            @Override
            public void run() {
                FilterPopupComponent.this.myFilterValueLabel.revalidate();
                FilterPopupComponent.this.myFilterValueLabel.repaint();
            }
        });
    }

    @NotNull
    protected abstract String getText(@NotNull Filter var1);

    @Nullable
    protected abstract String getToolTip(@NotNull Filter var1);

    @Override
    public String getToolTipText() {
        Filter filter = this.myFilterModel.getFilter();
        return filter == null ? null : this.getToolTip(filter);
    }

    private static Border createFocusedBorder() {
        return BorderFactory.createCompoundBorder((Border)new RoundedLineBorder(UIUtil.getHeaderActiveColor(), 10, 2), INNER_MARGIN_BORDER);
    }

    private static Border createUnfocusedBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), INNER_MARGIN_BORDER);
    }

    protected abstract ActionGroup createActionGroup();

    @NotNull
    protected AnAction createAllAction() {
        AllAction allAction = new AllAction();
        if (allAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/FilterPopupComponent", "createAllAction"));
        }
        return allAction;
    }

    private void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$3", "focusGained"));
                }
                FilterPopupComponent.this.setBorder(FOCUSED_BORDER);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$3", "focusLost"));
                }
                FilterPopupComponent.this.setBorder(UNFOCUSED_BORDER);
            }
        });
    }

    private void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$4", "keyPressed"));
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    FilterPopupComponent.this.showPopupMenu();
                }
            }
        });
    }

    private void showPopupMenuOnClick() {
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$5", "onClick"));
                }
                FilterPopupComponent.this.showPopupMenu();
                return true;
            }
        }.installOn((Component)this);
    }

    private void indicateHovering() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$6", "mouseEntered"));
                }
                FilterPopupComponent.this.setOnHoverForeground();
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$6", "mouseExited"));
                }
                FilterPopupComponent.this.setDefaultForeground();
            }
        });
    }

    private void setDefaultForeground() {
        this.myFilterNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
        this.myFilterValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor().darker().darker());
    }

    private void setOnHoverForeground() {
        this.myFilterNameLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.myFilterValueLabel.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private void showPopupMenu() {
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        popup.showUnderneathOf((Component)this);
    }

    private class AllAction
    extends DumbAwareAction {
        AllAction() {
            super(FilterPopupComponent.ALL);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/FilterPopupComponent$AllAction", "actionPerformed"));
            }
            FilterPopupComponent.this.myFilterModel.setFilter(null);
        }
    }
}

