/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.ui.VcsStructureChooser;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureFilterPopupComponent
extends FilterPopupComponent<VcsLogStructureFilter> {
    private static final int FILTER_LABEL_LENGTH = 20;

    public StructureFilterPopupComponent(@NotNull FilterModel<VcsLogStructureFilter> filterModel) {
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "<init>"));
        }
        super("Structure", filterModel);
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        Collection<VirtualFile> files = StructureFilterPopupComponent.getAllFiles(this.myFilterModel.getDataPack(), filter);
        if (files.size() == 0) {
            if ("All" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return "All";
        }
        if (files.size() == 1) {
            VirtualFile file = files.iterator().next();
            String string = StringUtil.shortenPathWithEllipsis((String)file.getPresentableUrl(), (int)20);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
            }
            return string;
        }
        String string = files.size() + " items";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogStructureFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return StructureFilterPopupComponent.getToolTip(StructureFilterPopupComponent.getAllFiles(this.myFilterModel.getDataPack(), filter));
    }

    @NotNull
    private static Collection<VirtualFile> getAllFiles(@NotNull VcsLogDataPack dataPack, @NotNull VcsLogStructureFilter filter) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getAllFiles"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getAllFiles"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile root : dataPack.getLogProviders().keySet()) {
            result.addAll(filter.getFiles(root));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getAllFiles"));
        }
        return arrayList;
    }

    @Override
    protected ActionGroup createActionGroup() {
        return new DefaultActionGroup(new AnAction[]{this.createAllAction(), new SelectAction()});
    }

    @NotNull
    private static String getToolTip(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        List<Object> filesToDisplay = new ArrayList<VirtualFile>(files);
        if (files.size() > 10) {
            filesToDisplay = filesToDisplay.subList(0, 10);
        }
        String tooltip = StringUtil.join(filesToDisplay, (Function)new Function<VirtualFile, String>(){

            public String fun(VirtualFile file) {
                return file.getPresentableUrl();
            }
        }, (String)"\n");
        if (files.size() > 10) {
            tooltip = tooltip + "\n...";
        }
        String string = tooltip;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent", "getToolTip"));
        }
        return string;
    }

    private class SelectAction
    extends DumbAwareAction {
        SelectAction() {
            super("Select...");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Set<VirtualFile> roots;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/filter/StructureFilterPopupComponent$SelectAction", "actionPerformed"));
            }
            Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
            VcsLogDataPack dataPack = StructureFilterPopupComponent.this.myFilterModel.getDataPack();
            VcsLogStructureFilter filter = (VcsLogStructureFilter)StructureFilterPopupComponent.this.myFilterModel.getFilter();
            Collection<Object> files = filter == null ? Collections.emptySet() : StructureFilterPopupComponent.getAllFiles(dataPack, filter);
            VcsStructureChooser chooser = new VcsStructureChooser(project, "Select Files or Folders to Filter", files, new ArrayList<VirtualFile>(roots = dataPack.getLogProviders().keySet()));
            if (chooser.showAndGet()) {
                StructureFilterPopupComponent.this.myFilterModel.setFilter(new VcsLogStructureFilterImpl(chooser.getSelectedFiles(), roots));
            }
        }
    }
}

