/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParenthesesUtils {
    public static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int RELATIONAL_PRECEDENCE = 8;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_XOR_PRECEDENCE = 11;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int NUM_PRECEDENCES = 17;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(17);

    private ParenthesesUtils() {
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Nullable
    public static PsiExpression stripParentheses(@Nullable PsiExpression expression) {
        while (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            expression = parenthesizedExpression.getExpression();
        }
        return expression;
    }

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/siyeh/ig/psiutils/ParenthesesUtils", "isCommutativeOperator"));
        }
        return !token.equals(JavaTokenType.MINUS) && !token.equals(JavaTokenType.DIV) && !token.equals(JavaTokenType.PERC) && !token.equals(JavaTokenType.LTLT) && !token.equals(JavaTokenType.GTGT) && !token.equals(JavaTokenType.GTGTGT);
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression) {
        PsiPrimitiveType primitiveType;
        IElementType tokenType = expression.getOperationTokenType();
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)type);
            if (primitiveType == null) {
                return false;
            }
        } else if (type instanceof PsiPrimitiveType) {
            primitiveType = (PsiPrimitiveType)type;
        } else {
            return false;
        }
        if (JavaTokenType.PLUS == tokenType || JavaTokenType.ASTERISK == tokenType) {
            return primitiveType != PsiType.FLOAT && primitiveType != PsiType.DOUBLE;
        }
        if (JavaTokenType.EQEQ == tokenType || JavaTokenType.NE == tokenType) {
            return primitiveType == PsiType.BOOLEAN;
        }
        if (JavaTokenType.AND == tokenType || JavaTokenType.OR == tokenType || JavaTokenType.XOR == tokenType) {
            return true;
        }
        return JavaTokenType.OROR == tokenType || JavaTokenType.ANDAND == tokenType;
    }

    public static int getPrecedence(PsiExpression expression) {
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression || expression instanceof PsiArrayAccessExpression || expression instanceof PsiArrayInitializerExpression) {
            return 0;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            if (referenceExpression.getQualifier() != null) {
                return 1;
            }
            return 0;
        }
        if (expression instanceof PsiMethodCallExpression || expression instanceof PsiNewExpression) {
            return 1;
        }
        if (expression instanceof PsiTypeCastExpression) {
            return 4;
        }
        if (expression instanceof PsiPrefixExpression) {
            return 3;
        }
        if (expression instanceof PsiPostfixExpression) {
            return 2;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            return ParenthesesUtils.getPrecedenceForOperator(polyadicExpression.getOperationTokenType());
        }
        if (expression instanceof PsiInstanceOfExpression) {
            return 8;
        }
        if (expression instanceof PsiConditionalExpression) {
            return 15;
        }
        if (expression instanceof PsiAssignmentExpression) {
            return 16;
        }
        if (expression instanceof PsiParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/siyeh/ig/psiutils/ParenthesesUtils", "getPrecedenceForOperator"));
        }
        Integer precedence = s_binaryOperatorPrecedence.get(operator);
        if (precedence == null) {
            throw new IllegalArgumentException("unknown operator: " + operator);
        }
        return precedence;
    }

    public static void removeParentheses(@NotNull PsiExpression expression, boolean ignoreClarifyingParentheses) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParentheses"));
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            ParenthesesUtils.removeParensFromMethodCallExpression(methodCall, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            ParenthesesUtils.removeParensFromReferenceExpression(referenceExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            ParenthesesUtils.removeParensFromNewExpression(newExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            ParenthesesUtils.removeParensFromAssignmentExpression(assignmentExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression;
            ParenthesesUtils.removeParensFromArrayInitializerExpression(arrayInitializerExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            ParenthesesUtils.removeParensFromTypeCastExpression(typeCastExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression;
            ParenthesesUtils.removeParensFromArrayAccessExpression(arrayAccessExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            ParenthesesUtils.removeParensFromPrefixExpression(prefixExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression;
            ParenthesesUtils.removeParensFromPostfixExpression(postfixExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            ParenthesesUtils.removeParensFromPolyadicExpression(polyadicExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)expression;
            ParenthesesUtils.removeParensFromInstanceOfExpression(instanceofExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            ParenthesesUtils.removeParensFromConditionalExpression(conditionalExpression, ignoreClarifyingParentheses);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            ParenthesesUtils.removeParensFromParenthesizedExpression(parenthesizedExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromReferenceExpression(@NotNull PsiReferenceExpression referenceExpression, boolean ignoreClarifyingParentheses) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromReferenceExpression"));
        }
        PsiExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromParenthesizedExpression(@NotNull PsiParenthesizedExpression parenthesizedExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        PsiArrayAccessExpression arrayAccessExpression;
        if (parenthesizedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parenthesizedExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromParenthesizedExpression"));
        }
        PsiExpression body = parenthesizedExpression.getExpression();
        if (body == null) {
            parenthesizedExpression.delete();
            return;
        }
        PsiElement parent = parenthesizedExpression.getParent();
        if (!(parent instanceof PsiExpression) || parent instanceof PsiParenthesizedExpression || parent instanceof PsiArrayInitializerExpression) {
            PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace((PsiElement)body);
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            return;
        }
        if (parent instanceof PsiArrayAccessExpression && parenthesizedExpression == (arrayAccessExpression = (PsiArrayAccessExpression)parent).getIndexExpression()) {
            PsiExpression newExpression = (PsiExpression)parent.addAfter((PsiElement)body, (PsiElement)parenthesizedExpression);
            parenthesizedExpression.delete();
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            return;
        }
        PsiExpression parentExpression = (PsiExpression)parent;
        int parentPrecedence = ParenthesesUtils.getPrecedence(parentExpression);
        if (parentPrecedence < (childPrecedence = ParenthesesUtils.getPrecedence(body))) {
            PsiElement bodyParent = body.getParent();
            PsiParenthesizedExpression newParenthesizedExpression = (PsiParenthesizedExpression)parenthesizedExpression.replace(bodyParent);
            PsiExpression expression = newParenthesizedExpression.getExpression();
            if (expression != null) {
                ParenthesesUtils.removeParentheses(expression, ignoreClarifyingParentheses);
            }
        } else if (parentPrecedence == childPrecedence) {
            if (parentExpression instanceof PsiPolyadicExpression && body instanceof PsiPolyadicExpression) {
                PsiExpression[] parentOperands;
                PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
                IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
                PsiPolyadicExpression bodyPolyadicExpression = (PsiPolyadicExpression)body;
                IElementType bodyOperator = bodyPolyadicExpression.getOperationTokenType();
                PsiType parentType = parentPolyadicExpression.getType();
                PsiType bodyType = body.getType();
                if (parentType != null && parentType.equals(bodyType) && parentOperator.equals(bodyOperator) && (PsiTreeUtil.isAncestor((PsiElement)(parentOperands = parentPolyadicExpression.getOperands())[0], (PsiElement)body, (boolean)true) || ParenthesesUtils.isCommutativeOperator(bodyOperator))) {
                    PsiExpression newExpression = (PsiExpression)parent.addAfter((PsiElement)body, (PsiElement)parenthesizedExpression);
                    parenthesizedExpression.delete();
                    ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
                    return;
                }
                if (ignoreClarifyingParentheses) {
                    if (parentOperator.equals(bodyOperator)) {
                        ParenthesesUtils.removeParentheses(body, ignoreClarifyingParentheses);
                    }
                } else {
                    PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace((PsiElement)body);
                    ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
                }
            } else {
                PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace((PsiElement)body);
                ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
            }
        } else if (ignoreClarifyingParentheses && parent instanceof PsiPolyadicExpression && (body instanceof PsiPolyadicExpression || body instanceof PsiInstanceOfExpression)) {
            ParenthesesUtils.removeParentheses(body, ignoreClarifyingParentheses);
        } else {
            PsiExpression newExpression = (PsiExpression)parenthesizedExpression.replace((PsiElement)body);
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromConditionalExpression(@NotNull PsiConditionalExpression conditionalExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression elseBranch;
        if (conditionalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionalExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromConditionalExpression"));
        }
        PsiExpression condition = conditionalExpression.getCondition();
        ParenthesesUtils.removeParentheses(condition, ignoreClarifyingParentheses);
        PsiExpression thenBranch = conditionalExpression.getThenExpression();
        if (thenBranch != null) {
            ParenthesesUtils.removeParentheses(thenBranch, ignoreClarifyingParentheses);
        }
        if ((elseBranch = conditionalExpression.getElseExpression()) != null) {
            ParenthesesUtils.removeParentheses(elseBranch, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromInstanceOfExpression(@NotNull PsiInstanceOfExpression instanceofExpression, boolean ignoreClarifyingParentheses) {
        if (instanceofExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceofExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromInstanceOfExpression"));
        }
        PsiExpression operand = instanceofExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression, boolean ignoreClarifyingParentheses) {
        if (polyadicExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "polyadicExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromPolyadicExpression"));
        }
        for (PsiExpression operand : polyadicExpression.getOperands()) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromPostfixExpression(@NotNull PsiPostfixExpression postfixExpression, boolean ignoreClarifyingParentheses) {
        if (postfixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postfixExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromPostfixExpression"));
        }
        PsiExpression operand = postfixExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPrefixExpression(@NotNull PsiPrefixExpression prefixExpression, boolean ignoreClarifyingParentheses) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromPrefixExpression"));
        }
        PsiExpression operand = prefixExpression.getOperand();
        if (operand != null) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression, boolean ignoreClarifyingParentheses) {
        if (arrayAccessExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayAccessExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromArrayAccessExpression"));
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ParenthesesUtils.removeParentheses(arrayExpression, ignoreClarifyingParentheses);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        if (indexExpression != null) {
            ParenthesesUtils.removeParentheses(indexExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromTypeCastExpression(@NotNull PsiTypeCastExpression typeCastExpression, boolean ignoreClarifyingParentheses) {
        if (typeCastExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeCastExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromTypeCastExpression"));
        }
        PsiExpression operand = typeCastExpression.getOperand();
        if (operand != null) {
            ParenthesesUtils.removeParentheses(operand, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializerExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression[] initializers;
        if (arrayInitializerExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayInitializerExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromArrayInitializerExpression"));
        }
        for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
            ParenthesesUtils.removeParentheses(initializer, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromAssignmentExpression(@NotNull PsiAssignmentExpression assignment, boolean ignoreClarifyingParentheses) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromAssignmentExpression"));
        }
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression rhs = assignment.getRExpression();
        ParenthesesUtils.removeParentheses(lhs, ignoreClarifyingParentheses);
        if (rhs != null) {
            ParenthesesUtils.removeParentheses(rhs, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromNewExpression(@NotNull PsiNewExpression newExpression, boolean ignoreClarifyingParentheses) {
        PsiExpressionList argumentList;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpression[] dimensions;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromNewExpression"));
        }
        for (PsiExpression dimension : dimensions = newExpression.getArrayDimensions()) {
            ParenthesesUtils.removeParentheses(dimension, ignoreClarifyingParentheses);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        if (qualifier != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
        if ((arrayInitializer = newExpression.getArrayInitializer()) != null) {
            ParenthesesUtils.removeParentheses((PsiExpression)arrayInitializer, ignoreClarifyingParentheses);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            PsiExpression[] arguments;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
            }
        }
    }

    private static void removeParensFromMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression, boolean ignoreClarifyingParentheses) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/siyeh/ig/psiutils/ParenthesesUtils", "removeParensFromMethodCallExpression"));
        }
        PsiReferenceExpression target = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        ParenthesesUtils.removeParentheses((PsiExpression)target, ignoreClarifyingParentheses);
        for (PsiExpression argument : arguments) {
            ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
        }
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression, boolean ignoreClarifyingParentheses) {
        PsiArrayAccessExpression arrayAccessExpression;
        PsiExpression indexExpression;
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpression)) {
            return false;
        }
        PsiExpression child = expression.getExpression();
        if (child == null) {
            return true;
        }
        if (parent instanceof PsiArrayAccessExpression && expression == (indexExpression = (arrayAccessExpression = (PsiArrayAccessExpression)parent).getIndexExpression())) {
            return false;
        }
        return ParenthesesUtils.areParenthesesNeeded(child, (PsiExpression)parent, ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        int childPrecedence;
        if (parentExpression instanceof PsiParenthesizedExpression || parentExpression instanceof PsiArrayInitializerExpression) {
            return false;
        }
        int parentPrecedence = ParenthesesUtils.getPrecedence(parentExpression);
        if (parentPrecedence > (childPrecedence = ParenthesesUtils.getPrecedence(expression))) {
            return ignoreClarifyingParentheses && (expression instanceof PsiPolyadicExpression ? parentExpression instanceof PsiPolyadicExpression || parentExpression instanceof PsiConditionalExpression || parentExpression instanceof PsiInstanceOfExpression : expression instanceof PsiInstanceOfExpression);
        }
        if (parentExpression instanceof PsiPolyadicExpression && expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression parentPolyadicExpression = (PsiPolyadicExpression)parentExpression;
            PsiType parentType = parentPolyadicExpression.getType();
            if (parentType == null) {
                return true;
            }
            PsiPolyadicExpression childPolyadicExpression = (PsiPolyadicExpression)expression;
            PsiType childType = childPolyadicExpression.getType();
            if (!parentType.equals(childType)) {
                return true;
            }
            if (childType.equalsToText("java.lang.String") && !PsiTreeUtil.isAncestor((PsiElement)parentPolyadicExpression.getOperands()[0], (PsiElement)childPolyadicExpression, (boolean)true)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (childType.equals(operand.getType())) continue;
                    return true;
                }
            } else if (childType.equals(PsiType.BOOLEAN)) {
                for (PsiExpression operand : operands = childPolyadicExpression.getOperands()) {
                    if (PsiType.BOOLEAN.equals((Object)operand.getType())) continue;
                    return true;
                }
            }
            IElementType parentOperator = parentPolyadicExpression.getOperationTokenType();
            IElementType childOperator = childPolyadicExpression.getOperationTokenType();
            if (ignoreClarifyingParentheses && !childOperator.equals(parentOperator)) {
                return true;
            }
            PsiExpression[] parentOperands = parentPolyadicExpression.getOperands();
            if (!(PsiTreeUtil.isAncestor((PsiElement)parentOperands[0], (PsiElement)expression, (boolean)false) || ParenthesesUtils.isAssociativeOperation(parentPolyadicExpression) && JavaTokenType.DIV != childOperator && JavaTokenType.PERC != childOperator)) {
                return true;
            }
        } else if (parentExpression instanceof PsiConditionalExpression && expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parentExpression;
            PsiExpression condition = conditionalExpression.getCondition();
            return PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)expression, (boolean)true);
        }
        return parentPrecedence < childPrecedence;
    }

    static {
        s_binaryOperatorPrecedence.put(JavaTokenType.PLUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.MINUS, 6);
        s_binaryOperatorPrecedence.put(JavaTokenType.ASTERISK, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.DIV, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.PERC, 5);
        s_binaryOperatorPrecedence.put(JavaTokenType.ANDAND, 13);
        s_binaryOperatorPrecedence.put(JavaTokenType.OROR, 14);
        s_binaryOperatorPrecedence.put(JavaTokenType.AND, 10);
        s_binaryOperatorPrecedence.put(JavaTokenType.OR, 12);
        s_binaryOperatorPrecedence.put(JavaTokenType.XOR, 11);
        s_binaryOperatorPrecedence.put(JavaTokenType.LTLT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GTGTGT, 7);
        s_binaryOperatorPrecedence.put(JavaTokenType.GT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.GE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LT, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.LE, 8);
        s_binaryOperatorPrecedence.put(JavaTokenType.EQEQ, 9);
        s_binaryOperatorPrecedence.put(JavaTokenType.NE, 9);
    }
}

