/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.annotation.AnnotateOverriddenMethodsPredicate;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateOverriddenMethodsIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        AnnotateOverriddenMethodsPredicate annotateOverriddenMethodsPredicate = new AnnotateOverriddenMethodsPredicate();
        if (annotateOverriddenMethodsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention", "getElementPredicate"));
        }
        return annotateOverriddenMethodsPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationText = annotation.getText();
        PsiElement grandParent = element.getParent().getParent();
        if (grandParent instanceof PsiMethod) {
            return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.method.name", annotationText);
        }
        return IntentionPowerPackBundle.message("annotate.overridden.methods.intention.parameters.name", annotationText);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiMethod method;
        int parameterIndex;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/annotation/AnnotateOverriddenMethodsIntention", "processIntention"));
        }
        PsiAnnotation annotation = (PsiAnnotation)element;
        String annotationName = annotation.getQualifiedName();
        if (annotationName == null) {
            return;
        }
        Project project = element.getProject();
        NullableNotNullManager notNullManager = NullableNotNullManager.getInstance((Project)project);
        List notNulls = notNullManager.getNotNulls();
        List<String> nullables = notNullManager.getNullables();
        List<Object> annotationsToRemove = notNulls.contains(annotationName) ? nullables : (nullables.contains(annotationName) ? notNulls : Collections.emptyList());
        PsiElement parent = annotation.getParent();
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiMethod)) {
            if (!(grandParent instanceof PsiParameter)) {
                return;
            }
            PsiParameter parameter = (PsiParameter)grandParent;
            PsiElement greatGrandParent = grandParent.getParent();
            if (!(greatGrandParent instanceof PsiParameterList)) {
                return;
            }
            PsiParameterList parameterList = (PsiParameterList)greatGrandParent;
            parameterIndex = parameterList.getParameterIndex(parameter);
            PsiElement greatGreatGrandParent = greatGrandParent.getParent();
            if (!(greatGreatGrandParent instanceof PsiMethod)) {
                return;
            }
            method = (PsiMethod)greatGreatGrandParent;
        } else {
            parameterIndex = -1;
            method = (PsiMethod)grandParent;
        }
        Collection overridingMethods = OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true).findAll();
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        for (PsiMethod overridingMethod : overridingMethods) {
            if (parameterIndex == -1) {
                AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)overridingMethod, annotationName, attributes, element, annotationsToRemove);
                continue;
            }
            PsiParameterList parameterList = overridingMethod.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter parameter = parameters[parameterIndex];
            AnnotateOverriddenMethodsIntention.annotate((PsiModifierListOwner)parameter, annotationName, attributes, element, annotationsToRemove);
        }
    }

    private static void annotate(PsiModifierListOwner modifierListOwner, String annotationName, PsiNameValuePair[] attributes, PsiElement context, List<String> annotationsToRemove) {
        Project project = context.getProject();
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (modifierList.findAnnotation(annotationName) != null) {
            return;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace((PsiElement)modifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        PsiFile fromFile = context.getContainingFile();
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String annotationToRemove : annotationsToRemove) {
                annotationsManager.deannotate(modifierListOwner, annotationToRemove);
            }
            annotationsManager.annotateExternally(modifierListOwner, annotationName, fromFile, attributes);
        } else {
            PsiFile containingFile = modifierListOwner.getContainingFile();
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)containingFile)) {
                return;
            }
            for (String annotationToRemove : annotationsToRemove) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (String[])new String[]{annotationToRemove});
                if (annotation == null) continue;
                annotation.delete();
            }
            PsiAnnotation inserted = modifierList.addAnnotation(annotationName);
            for (PsiNameValuePair pair : attributes) {
                inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            codeStyleManager.shortenClassReferences((PsiElement)inserted);
            if (containingFile != fromFile) {
                UndoUtil.markPsiFileForUndo((PsiFile)fromFile);
            }
        }
    }
}

