/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.PsiElementPredicate;

class ExpandBooleanPredicate
implements PsiElementPredicate {
    ExpandBooleanPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiStatement containingStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        if (containingStatement == null) {
            return false;
        }
        return ExpandBooleanPredicate.isBooleanReturn(containingStatement) || ExpandBooleanPredicate.isBooleanAssignment(containingStatement) || ExpandBooleanPredicate.isBooleanDeclaration(containingStatement);
    }

    public static boolean isBooleanReturn(PsiStatement statement) {
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null || returnValue instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType returnType = returnValue.getType();
        return PsiType.BOOLEAN.equals((Object)returnType);
    }

    public static boolean isBooleanAssignment(PsiStatement statement) {
        if (!(statement instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
        PsiExpression expression = expressionStatement.getExpression();
        if (!(expression instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null || rhs instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType assignmentType = rhs.getType();
        return PsiType.BOOLEAN.equals((Object)assignmentType);
    }

    public static boolean isBooleanDeclaration(PsiStatement statement) {
        if (!(statement instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
        PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
        if (declaredElements.length != 1) {
            return false;
        }
        PsiElement element = declaredElements[0];
        if (!(element instanceof PsiLocalVariable)) {
            return false;
        }
        PsiLocalVariable variable = (PsiLocalVariable)element;
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null || initializer instanceof PsiLiteralExpression) {
            return false;
        }
        PsiType type = initializer.getType();
        return PsiType.BOOLEAN.equals((Object)type);
    }
}

