/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;

final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    DefaultWebServerPathHandler() {
    }

    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @Nullable String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        PathInfo root;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerPathHandler", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerPathHandler", "process"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/builtInWebServer/DefaultWebServerPathHandler", "process"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/builtInWebServer/DefaultWebServerPathHandler", "process"));
        }
        if (decodedRawPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decodedRawPath", "org/jetbrains/builtInWebServer/DefaultWebServerPathHandler", "process"));
        }
        Channel channel = context.channel();
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.getInstance(project);
        VirtualFile result = (VirtualFile)pathToFileManager.pathToFileCache.getIfPresent((Object)path);
        boolean indexUsed = false;
        if (result == null || !result.isValid()) {
            result = pathToFileManager.findByRelativePath(project, path);
            if (result == null) {
                if (path.isEmpty()) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request);
                    return true;
                }
                return false;
            }
            if (result.isDirectory()) {
                if ((result = BuiltInWebServer.findIndexFile(result)) == null) {
                    Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, (HttpRequest)request);
                    return true;
                }
                if (!DefaultWebServerPathHandler.endsWithSlash(decodedRawPath)) {
                    DefaultWebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path);
                    return true;
                }
                indexUsed = true;
            }
            pathToFileManager.pathToFileCache.put((Object)path, (Object)result);
        }
        if (NettyUtil.origin((HttpRequest)request) == null && NettyUtil.referrer((HttpRequest)request) == null && NettyUtil.isRegularBrowser((HttpRequest)request) && !BuiltInWebServer.canBeAccessedDirectly(result.getName())) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)request);
            return true;
        }
        if (!indexUsed && !path.endsWith(result.getName())) {
            if (DefaultWebServerPathHandler.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else if (path.endsWith(result.getParent().getName())) {
                DefaultWebServerPathHandler.redirectToDirectory((HttpRequest)request, channel, isCustomHost ? path : projectName + '/' + path);
                return true;
            }
        }
        if (!DefaultWebServerPathHandler.checkAccess(result, (root = WebServerPathToFileManager.getInstance(project).getRoot(result)).getRoot(), channel, (HttpRequest)request)) {
            return true;
        }
        StringBuilder canonicalRequestPath = new StringBuilder();
        canonicalRequestPath.append('/');
        if (!isCustomHost) {
            canonicalRequestPath.append(projectName).append('/');
        }
        canonicalRequestPath.append(path);
        if (indexUsed) {
            canonicalRequestPath.append('/').append(result.getName());
        }
        for (WebServerFileHandler fileHandler : (WebServerFileHandler[])WebServerFileHandler.EP_NAME.getExtensions()) {
            try {
                if (!fileHandler.process(result, canonicalRequestPath, project, request, channel)) continue;
                return true;
            }
            catch (Throwable e) {
                BuiltInWebServer.LOG.error(e);
            }
        }
        return false;
    }

    private static boolean checkAccess(VirtualFile virtualFile, VirtualFile root, Channel channel, HttpRequest request) {
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        if (virtualFile.isInLocalFileSystem()) {
            if (virtualFile.isDirectory()) {
                Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
                return false;
            }
            if (!BuiltInWebServer.StaticFileHandler.checkAccess(channel, ioFile, request, VfsUtilCore.virtualToIoFile((VirtualFile)root))) {
                return false;
            }
        } else if (virtualFile.is(VFileProperty.HIDDEN)) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, channel, request);
            return false;
        }
        return true;
    }
}

