/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.Responses;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

abstract class DelegatingHttpRequestHandlerBase
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    DelegatingHttpRequestHandlerBase() {
    }

    @Override
    protected void messageReceived(ChannelHandlerContext context, FullHttpRequest message) throws Exception {
        if (BuiltInServer.LOG.isDebugEnabled()) {
            BuiltInServer.LOG.debug("IN HTTP: " + message.uri());
        }
        if (!this.process(context, message, new QueryStringDecoder(message.uri()))) {
            Responses.sendStatus(HttpResponseStatus.NOT_FOUND, context.channel(), (HttpRequest)message);
        }
    }

    protected abstract boolean process(ChannelHandlerContext var1, FullHttpRequest var2, QueryStringDecoder var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
        try {
            NettyUtil.log(cause, BuiltInServer.LOG);
        }
        finally {
            context.channel().close();
        }
    }
}

