/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoop;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.resolver.HostsFileEntriesResolver;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.util.Random;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH = 0x6400000;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void log(Throwable throwable, Logger log) {
        if (NettyUtil.isAsWarning(throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    @Nullable
    public static Channel connectClient(@NotNull Bootstrap bootstrap, @NotNull InetSocketAddress remoteAddress, @Nullable ActionCallback asyncResult) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/NettyUtil", "connectClient"));
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteAddress", "org/jetbrains/io/NettyUtil", "connectClient"));
        }
        return NettyUtil.connect(bootstrap, remoteAddress, asyncResult, 20);
    }

    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @NotNull InetSocketAddress remoteAddress, @Nullable ActionCallback asyncResult, int maxAttemptCount) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/NettyUtil", "connect"));
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteAddress", "org/jetbrains/io/NettyUtil", "connect"));
        }
        try {
            Socket socket;
            int attemptCount = 0;
            if (bootstrap.group() instanceof NioEventLoop) {
                ChannelFuture future;
                while (true) {
                    if ((future = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly()).isSuccess()) {
                        return future.channel();
                    }
                    if (++attemptCount >= maxAttemptCount) break;
                    Thread.sleep(attemptCount * 100);
                }
                Throwable cause = future.cause();
                if (asyncResult != null) {
                    asyncResult.reject("Cannot connect: " + (cause == null ? "unknown error" : cause.getMessage()));
                }
                return null;
            }
            while (true) {
                try {
                    socket = new Socket(remoteAddress.getAddress(), remoteAddress.getPort());
                }
                catch (IOException e) {
                    if (++attemptCount < maxAttemptCount) {
                        Thread.sleep(attemptCount * 100);
                        continue;
                    }
                    if (asyncResult != null) {
                        asyncResult.reject("Cannot connect: " + e.getMessage());
                    }
                    return null;
                }
                break;
            }
            OioSocketChannel channel = new OioSocketChannel(socket);
            BootstrapUtil.initAndRegister((Channel)channel, bootstrap).awaitUninterruptibly();
            return channel;
        }
        catch (Throwable e) {
            if (asyncResult != null) {
                asyncResult.reject("Cannot connect: " + e.getMessage());
            }
            return null;
        }
    }

    private static boolean isAsWarning(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        return throwable instanceof IOException && message.equals("An existing connection was forcibly closed by the remote host") || throwable instanceof ChannelException && message.startsWith("Failed to bind to: ") || throwable instanceof BindException || message.startsWith("Connection reset") || message.equals("Operation timed out") || message.equals("Connection timed out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndReleaseFactory(@NotNull Channel channel) {
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/NettyUtil", "closeAndReleaseFactory"));
        }
        EventLoop channelFactory = channel.eventLoop();
        try {
            channel.close().awaitUninterruptibly();
        }
        finally {
            channelFactory.shutdownGracefully();
        }
    }

    public static ServerBootstrap nioServerBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/NettyUtil", "nioServerBootstrap"));
        }
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static Bootstrap nioClientBootstrap() {
        return NettyUtil.nioClientBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
    }

    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/NettyUtil", "nioClientBootstrap"));
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static void addHttpServerCodec(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(0x6400000)});
    }

    public static String host(HttpRequest request) {
        return request.headers().get("Host");
    }

    public static String origin(HttpRequest request) {
        return request.headers().get("Origin");
    }

    public static String referrer(HttpRequest request) {
        return request.headers().get("Referer");
    }

    static String userAgent(HttpRequest request) {
        return request.headers().get("User-Agent");
    }

    private static boolean isLocal(InetAddress address) throws SocketException {
        return address.isAnyLocalAddress() || address.isLoopbackAddress() || NetworkInterface.getByInetAddress(address) != null;
    }

    public static boolean isLocalHost(String host, boolean onlyAnyOrLoopback) {
        return NettyUtil.isLocalHost(host, onlyAnyOrLoopback, false);
    }

    static boolean isLocalHost(String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            if (!NettyUtil.isLocal(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                InetAddress addressFromHosts = HostsFileEntriesResolver.DEFAULT.address(host);
                return addressFromHosts != null && NettyUtil.isLocal(addressFromHosts);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isLocalOrigin(HttpRequest request) {
        return NettyUtil.isLocalOrigin(request, true, false);
    }

    public static boolean isLocalOrigin(HttpRequest request, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        return NettyUtil.parseAndCheckIsLocalHost(NettyUtil.origin(request), onlyAnyOrLoopback, hostsOnly) && NettyUtil.parseAndCheckIsLocalHost(NettyUtil.referrer(request), onlyAnyOrLoopback, hostsOnly);
    }

    private static boolean isTrustedChromeExtension(URI uri) {
        return "chrome-extension".equals(uri.getScheme()) && ("hmhgeddbohgjknpmjagkdomcpobmllji".equals(uri.getHost()) || "offnedcbhjldheanlbojaefbfbllddna".equals(uri.getHost()));
    }

    public static boolean parseAndCheckIsLocalHost(String uri) {
        return NettyUtil.parseAndCheckIsLocalHost(uri, true, false);
    }

    static boolean parseAndCheckIsLocalHost(String uri, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri == null) {
            return true;
        }
        try {
            URI parsedUri = new URI(uri);
            return NettyUtil.isTrustedChromeExtension(parsedUri) || NettyUtil.isLocalHost(parsedUri.getHost(), onlyAnyOrLoopback, hostsOnly);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static boolean isWriteFromBrowserWithoutOrigin(HttpRequest request) {
        if (request == null) {
            return false;
        }
        HttpMethod method = request.getMethod();
        return Strings.isNullOrEmpty((String)NettyUtil.origin(request)) && NettyUtil.isRegularBrowser(request) && (method == HttpMethod.POST || method == HttpMethod.PATCH || method == HttpMethod.PUT || method == HttpMethod.DELETE);
    }

    public static boolean isRegularBrowser(HttpRequest request) {
        String userAgent = NettyUtil.userAgent(request);
        if (request == null) {
            return false;
        }
        return userAgent.startsWith("Mozilla/5.0");
    }

    static {
        if (SystemProperties.getBooleanProperty((String)"io.netty.random.id", (boolean)true)) {
            System.setProperty("io.netty.machineId", "9e43d860");
            System.setProperty("io.netty.processId", Integer.toString(new Random().nextInt(65535)));
        }
    }
}

