/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlNamedElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.references.PrefixReference;
import org.intellij.lang.xpath.xslt.impl.references.XsltReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltReferenceContributor {
    private XsltReferenceContributor() {
    }

    static class SchemaTypeProvider
    extends PsiReferenceProvider {
        static final PsiReferenceProvider INSTANCE = new SchemaTypeProvider();

        SchemaTypeProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiReference[] psiReferenceArray;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeProvider", "getReferencesByElement"));
            }
            SchemaTypeReference reference = SchemaTypeReference.create(element);
            if (reference != null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference;
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }

    public static class SchemaTypeReference
    extends TypeOrElementOrAttributeReference
    implements EmptyResolveMessageProvider {
        private static final Pattern NAME_PATTERN = Pattern.compile("(?:[\\w-]+:)[\\w-]+");

        private SchemaTypeReference(PsiElement element, TextRange range) {
            super(element, range, TypeOrElementOrAttributeReference.ReferenceType.TypeReference);
        }

        @Nullable
        private static TextRange getTextRange(PsiElement element) {
            Matcher matcher = NAME_PATTERN.matcher(element.getText());
            if (matcher.find()) {
                return TextRange.create((int)matcher.start(), (int)matcher.end());
            }
            return null;
        }

        public boolean isSoft() {
            String text = this.getCanonicalText();
            return super.isSoft() || SchemaTypeReference.isType(text, "yearMonthDuration") || SchemaTypeReference.isType(text, "dayTimeDuration");
        }

        private static boolean isType(String text, String name) {
            return name.equals(text) || text.endsWith(":" + name);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Unknown Type" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeReference", "getUnresolvedMessagePattern"));
            }
            return "Unknown Type";
        }

        @Nullable
        public static SchemaTypeReference create(PsiElement element) {
            TextRange range = SchemaTypeReference.getTextRange(element);
            return range != null ? new SchemaTypeReference(element, range) : null;
        }
    }

    static class NamespacePrefixReference
    extends PrefixReference
    implements LocalQuickFixProvider {
        public NamespacePrefixReference(PsiElement element) {
            super((XmlAttribute)element.getParent());
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = XsltNamespaceContext.getPrefixes((XmlElement)this.myAttribute).toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$NamespacePrefixReference", "getVariants"));
            }
            return objectArray;
        }

        @Nullable
        public LocalQuickFix[] getQuickFixes() {
            XmlAttributeValue valueElement = this.myAttribute.getValueElement();
            if (valueElement != null) {
                return new LocalQuickFix[]{new CreateNSDeclarationIntentionFix((PsiElement)valueElement, this.getCanonicalText()){

                    public boolean showHint(@NotNull Editor editor) {
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$NamespacePrefixReference$1", "showHint"));
                        }
                        return false;
                    }
                }};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
    }

    public static class XML
    extends PsiReferenceContributor {
        public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML", "registerReferenceProviders"));
            }
            registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(XmlAttributeValue.class).withParent((ElementPattern)((XmlNamedElementPattern.XmlAttributePattern)XmlPatterns.xmlAttribute().withLocalName(new String[]{"name", "href", "mode", "elements", "exclude-result-prefixes", "extension-element-prefixes", "stylesheet-prefix"})).withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.w3.org/1999/XSL/Transform"))), (PsiReferenceProvider)new XsltReferenceProvider());
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withValue(StandardPatterns.string().matches("[^()]+")).withParent((ElementPattern)XmlPatterns.xmlAttribute((String)"as").withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.w3.org/1999/XSL/Transform"))), SchemaTypeProvider.INSTANCE);
            registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().withParent((ElementPattern)XmlPatterns.xmlAttribute((String)"as").withParent((ElementPattern)XmlPatterns.xmlTag().withNamespace("http://www.w3.org/1999/XSL/Transform")))).withValue(StandardPatterns.string().contains(":")), new PsiReferenceProvider(){

                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML$1", "getReferencesByElement"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML$1", "getReferencesByElement"));
                    }
                    PsiReference[] psiReferenceArray = new PsiReference[]{new NamespacePrefixReference(element)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            });
        }
    }

    public static class XPath
    extends PsiReferenceContributor {
        public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XPath", "registerReferenceProviders"));
            }
            registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(XPath2TypeElement.class), SchemaTypeProvider.INSTANCE);
        }
    }
}

