/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitUIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPullDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitPullDialog.class);
    private JPanel myPanel;
    private JComboBox myGitRoot;
    private JLabel myCurrentBranch;
    private JComboBox myStrategy;
    private JCheckBox myNoCommitCheckBox;
    private JCheckBox mySquashCommitCheckBox;
    private JCheckBox myNoFastForwardCheckBox;
    private JCheckBox myAddLogInformationCheckBox;
    private JComboBox myRemote;
    private ElementsChooser<String> myBranchChooser;
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;

    public GitPullDialog(Project project, List<VirtualFile> roots, VirtualFile defaultRoot) {
        super(project, true);
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.getString("pull.title"));
        this.myProject = project;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        GitUIUtil.setupRootChooser(this.myProject, roots, defaultRoot, this.myGitRoot, this.myCurrentBranch);
        this.myGitRoot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPullDialog.this.updateRemotes();
            }
        });
        this.setOKButtonText(GitBundle.getString("pull.button"));
        this.updateRemotes();
        this.updateBranches();
        this.myRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitPullDialog.this.updateBranches();
            }
        });
        ElementsChooser.ElementsMarkListener<String> listener = new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                GitPullDialog.this.validateDialog();
            }
        };
        this.myBranchChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)listener);
        listener.elementMarkChanged(null, true);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myNoCommitCheckBox, true);
        GitUIUtil.imply(this.mySquashCommitCheckBox, true, this.myAddLogInformationCheckBox, false);
        GitUIUtil.exclusive(this.mySquashCommitCheckBox, true, this.myNoFastForwardCheckBox, true);
        GitMergeUtil.setupStrategies(this.myBranchChooser, this.myStrategy);
        this.init();
    }

    private void validateDialog() {
        String selectedRemote = this.getRemote();
        if (StringUtil.isEmptyOrSpaces((String)selectedRemote)) {
            this.setOKActionEnabled(false);
            return;
        }
        this.setOKActionEnabled(this.myBranchChooser.getMarkedElements().size() != 0);
    }

    public GitLineHandler makeHandler(@NotNull String url) {
        String strategy;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/merge/GitPullDialog", "makeHandler"));
        }
        GitLineHandler h = new GitLineHandler(this.myProject, this.gitRoot(), GitCommand.PULL);
        h.ignoreErrorCode(1);
        h.setUrl(url);
        h.addProgressParameter();
        h.addParameters("--no-stat");
        if (this.myNoCommitCheckBox.isSelected()) {
            h.addParameters("--no-commit");
        } else if (this.myAddLogInformationCheckBox.isSelected()) {
            h.addParameters("--log");
        }
        if (this.mySquashCommitCheckBox.isSelected()) {
            h.addParameters("--squash");
        }
        if (this.myNoFastForwardCheckBox.isSelected()) {
            h.addParameters("--no-ff");
        }
        if (!GitMergeUtil.DEFAULT_STRATEGY.equals(strategy = (String)this.myStrategy.getSelectedItem())) {
            h.addParameters("--strategy", strategy);
        }
        h.addParameters("-v");
        h.addProgressParameter();
        List markedBranches = this.myBranchChooser.getMarkedElements();
        String remote = this.getRemote();
        LOG.assertTrue(remote != null, (Object)"Selected remote can't be null here.");
        h.addParameters(remote);
        for (String branch : markedBranches) {
            h.addParameters(GitPullDialog.removeRemotePrefix(branch, remote));
        }
        return h;
    }

    @NotNull
    private static String removeRemotePrefix(@NotNull String branch, @NotNull String remote) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/merge/GitPullDialog", "removeRemotePrefix"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/merge/GitPullDialog", "removeRemotePrefix"));
        }
        String prefix = remote + "/";
        if (branch.startsWith(prefix)) {
            String string = branch.substring(prefix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/merge/GitPullDialog", "removeRemotePrefix"));
            }
            return string;
        }
        LOG.error(String.format("Remote branch name seems to be invalid. Branch: %s, remote: %s", branch, remote));
        String string = branch;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/merge/GitPullDialog", "removeRemotePrefix"));
        }
        return string;
    }

    private void updateBranches() {
        String selectedRemote = this.getRemote();
        this.myBranchChooser.removeAllElements();
        if (selectedRemote == null) {
            return;
        }
        GitRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        GitBranchTrackInfo trackInfo = GitUtil.getTrackInfoForCurrentBranch(repository);
        String currentRemoteBranch = trackInfo == null ? null : trackInfo.getRemoteBranch().getNameForLocalOperations();
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        for (GitRemoteBranch remoteBranch : remoteBranches) {
            if (!GitPullDialog.belongsToRemote(remoteBranch, selectedRemote)) continue;
            this.myBranchChooser.addElement((Object)remoteBranch.getName(), remoteBranch.getName().equals(currentRemoteBranch));
        }
        this.validateDialog();
    }

    private static boolean belongsToRemote(@NotNull GitBranch branch, @NotNull String remote) {
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/merge/GitPullDialog", "belongsToRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/merge/GitPullDialog", "belongsToRemote"));
        }
        return branch.getName().startsWith(remote + "/");
    }

    private void updateRemotes() {
        GitRepository repository = this.getRepository();
        if (repository == null) {
            return;
        }
        GitRemote currentRemote = GitPullDialog.getCurrentOrDefaultRemote(repository);
        this.myRemote.setRenderer(this.getGitRemoteListCellRenderer(currentRemote != null ? currentRemote.getName() : null));
        this.myRemote.removeAllItems();
        for (GitRemote remote : repository.getRemotes()) {
            this.myRemote.addItem(remote);
        }
        this.myRemote.setSelectedItem(currentRemote);
    }

    @Nullable
    private static GitRemote getCurrentOrDefaultRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/merge/GitPullDialog", "getCurrentOrDefaultRemote"));
        }
        Collection<GitRemote> remotes = repository.getRemotes();
        if (remotes.isEmpty()) {
            return null;
        }
        GitBranchTrackInfo trackInfo = GitUtil.getTrackInfoForCurrentBranch(repository);
        if (trackInfo != null) {
            return trackInfo.getRemote();
        }
        GitRemote origin = GitUtil.getDefaultRemote(remotes);
        if (origin != null) {
            return origin;
        }
        return remotes.iterator().next();
    }

    @Nullable
    private GitRepository getRepository() {
        VirtualFile root = this.gitRoot();
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository is null for " + root);
            return null;
        }
        return repository;
    }

    public ListCellRendererWrapper<GitRemote> getGitRemoteListCellRenderer(final String defaultRemote) {
        return new ListCellRendererWrapper<GitRemote>(){

            public void customize(JList list, GitRemote remote, int index, boolean selected, boolean hasFocus) {
                String text;
                if (remote == null) {
                    text = GitBundle.getString("util.remote.renderer.none");
                } else if (".".equals(remote.getName())) {
                    text = GitBundle.getString("util.remote.renderer.self");
                } else {
                    String key = defaultRemote != null && defaultRemote.equals(remote.getName()) ? "util.remote.renderer.default" : "util.remote.renderer.normal";
                    text = GitBundle.message(key, remote.getName(), remote.getFirstUrl());
                }
                this.setText(text);
            }
        };
    }

    public VirtualFile gitRoot() {
        return (VirtualFile)this.myGitRoot.getSelectedItem();
    }

    private void createUIComponents() {
        this.myBranchChooser = new ElementsChooser(true);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.Pull";
    }

    @Nullable
    public String getRemote() {
        GitRemote remote = (GitRemote)this.myRemote.getSelectedItem();
        return remote == null ? null : remote.getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBranchChooser.getComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JComboBox jComboBox2;
        JLabel jLabel;
        JComboBox jComboBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRoot = jComboBox3 = new JComboBox();
        jComboBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.git.root.tooltip"));
        jPanel.add(jComboBox3, new GridConstraints(0, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentBranch = jLabel = new JLabel();
        jLabel.setText("  ");
        jLabel.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.current.branch.tooltip"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.remote"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.branches"));
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy"));
        jPanel.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myStrategy = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.strategy"));
        jPanel.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNoCommitCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.commit"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySquashCommitCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.squash.commit"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNoFastForwardCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.no.fast.forward"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddLogInformationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information.tooltip"));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("merge.add.log.information"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(2, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myRemote = jComboBox = new JComboBox();
        jComboBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("pull.remote.tooltip"));
        jComboBox.setEditable(false);
        jPanel3.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        ElementsChooser<String> elementsChooser = this.myBranchChooser;
        jPanel.add((Component)elementsChooser, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 7, null, null, null));
        jLabel2.setLabelFor(jComboBox3);
        jLabel4.setLabelFor(jComboBox);
        jLabel6.setLabelFor(jComboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

