/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConfig {
    @Deprecated
    public static final String DOT_REMOTE = ".";
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"");
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"");
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"");
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch");
    @NotNull
    private final Collection<Remote> myRemotes;
    @NotNull
    private final Collection<Url> myUrls;
    @NotNull
    private final Collection<BranchConfig> myTrackedInfos;

    private GitConfig(@NotNull Collection<Remote> remotes, @NotNull Collection<Url> urls, @NotNull Collection<BranchConfig> trackedInfos) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/repo/GitConfig", "<init>"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "git4idea/repo/GitConfig", "<init>"));
        }
        if (trackedInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trackedInfos", "git4idea/repo/GitConfig", "<init>"));
        }
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    @NotNull
    Collection<GitRemote> parseRemotes() {
        List list = ContainerUtil.map(this.myRemotes, (Function)new Function<Remote, GitRemote>(){

            public GitRemote fun(@Nullable Remote remote) {
                assert (remote != null);
                return GitConfig.convertRemoteToGitRemote(GitConfig.this.myUrls, remote);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "parseRemotes"));
        }
        return list;
    }

    @NotNull
    private static GitRemote convertRemoteToGitRemote(@NotNull Collection<Url> urls, @NotNull Remote remote) {
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "git4idea/repo/GitConfig", "convertRemoteToGitRemote"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/repo/GitConfig", "convertRemoteToGitRemote"));
        }
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        GitRemote gitRemote = new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), GitConfig.computePushSpec(remote));
        if (gitRemote == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "convertRemoteToGitRemote"));
        }
        return gitRemote;
    }

    @NotNull
    Collection<GitBranchTrackInfo> parseTrackInfos(final @NotNull Collection<GitLocalBranch> localBranches, final @NotNull Collection<GitRemoteBranch> remoteBranches) {
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/repo/GitConfig", "parseTrackInfos"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranches", "git4idea/repo/GitConfig", "parseTrackInfos"));
        }
        List list = ContainerUtil.mapNotNull(this.myTrackedInfos, (Function)new Function<BranchConfig, GitBranchTrackInfo>(){

            public GitBranchTrackInfo fun(BranchConfig config) {
                if (config != null) {
                    return GitConfig.convertBranchConfig(config, localBranches, remoteBranches);
                }
                return null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "parseTrackInfos"));
        }
        return list;
    }

    @NotNull
    static GitConfig read(@NotNull GitPlatformFacade platformFacade, @NotNull File configFile) {
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/repo/GitConfig", "read"));
        }
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "git4idea/repo/GitConfig", "read"));
        }
        GitConfig emptyConfig = new GitConfig(Collections.<Remote>emptyList(), Collections.<Url>emptyList(), Collections.<BranchConfig>emptyList());
        if (!configFile.exists()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "read"));
            }
            return gitConfig;
        }
        Ini ini = new Ini();
        ini.getConfig().setMultiOption(true);
        ini.getConfig().setTree(false);
        try {
            ini.load(configFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)new RepoStateException("Couldn't load .git/config file at " + configFile.getPath(), (Throwable)e));
            GitConfig gitConfig = emptyConfig;
            if (gitConfig == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "read"));
            }
            return gitConfig;
        }
        IdeaPluginDescriptor plugin = platformFacade.getPluginByClassName(GitConfig.class.getName());
        ClassLoader classLoader = plugin == null ? null : plugin.getPluginClassLoader();
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini, classLoader);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini, classLoader);
        GitConfig gitConfig = new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
        if (gitConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "read"));
        }
        return gitConfig;
    }

    @NotNull
    private static Collection<BranchConfig> parseTrackedInfos(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        if (ini == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ini", "git4idea/repo/GitConfig", "parseTrackedInfos"));
        }
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!sectionName.startsWith("branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section, classLoader)) == null) continue;
            configs.add(branchConfig);
        }
        ArrayList<BranchConfig> arrayList = configs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "parseTrackedInfos"));
        }
        return arrayList;
    }

    @Nullable
    private static GitBranchTrackInfo convertBranchConfig(@Nullable BranchConfig branchConfig, @NotNull Collection<GitLocalBranch> localBranches, @NotNull Collection<GitRemoteBranch> remoteBranches) {
        String remoteBranchName;
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/repo/GitConfig", "convertBranchConfig"));
        }
        if (remoteBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBranches", "git4idea/repo/GitConfig", "convertBranchConfig"));
        }
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getBean().getRemote();
        String mergeName = branchConfig.getBean().getMerge();
        String rebaseName = branchConfig.getBean().getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.info("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.info("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String string = remoteBranchName = merge ? mergeName : rebaseName;
        assert (remoteName != null);
        assert (remoteBranchName != null);
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitBranchUtil.findRemoteBranchByName(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    @Nullable
    private static GitLocalBranch findLocalBranch(@NotNull String branchName, @NotNull Collection<GitLocalBranch> localBranches) {
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/repo/GitConfig", "findLocalBranch"));
        }
        if (localBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localBranches", "git4idea/repo/GitConfig", "findLocalBranch"));
        }
        final String name = GitBranchUtil.stripRefsPrefix(branchName);
        try {
            return (GitLocalBranch)ContainerUtil.find(localBranches, (Condition)new Condition<GitLocalBranch>(){

                public boolean value(@Nullable GitLocalBranch input) {
                    assert (input != null);
                    return input.getName().equals(name);
                }
            });
        }
        catch (NoSuchElementException e) {
            LOG.info("Couldn't find branch with name " + name);
            return null;
        }
    }

    @Nullable
    private static BranchConfig parseBranchSection(String sectionName, Profile.Section section, @Nullable ClassLoader classLoader) {
        BranchBean branchBean = (BranchBean)section.as(BranchBean.class, classLoader);
        Matcher matcher = BRANCH_INFO_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new BranchConfig(matcher.group(1), branchBean);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(@NotNull Ini ini, @Nullable ClassLoader classLoader) {
        if (ini == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ini", "git4idea/repo/GitConfig", "parseRemotes"));
        }
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Url url;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (sectionName.startsWith("remote") || sectionName.startsWith("svn-remote")) {
                Remote remote = GitConfig.parseRemoteSection(sectionName, section, classLoader);
                if (remote == null) continue;
                remotes.add(remote);
                continue;
            }
            if (!sectionName.startsWith("url") || (url = GitConfig.parseUrlSection(sectionName, section, classLoader)) == null) continue;
            urls.add(url);
        }
        Pair pair = Pair.create(remotes, urls);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "parseRemotes"));
        }
        return pair;
    }

    @NotNull
    private static List<String> computePushSpec(@NotNull Remote remote) {
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/repo/GitConfig", "computePushSpec"));
        }
        List pushSpec = remote.getPushSpec();
        List list = pushSpec == null ? remote.getFetchSpecs() : pushSpec;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "computePushSpec"));
        }
        return list;
    }

    @NotNull
    private static UrlsAndPushUrls substituteUrls(@NotNull Collection<Url> urlSections, @NotNull Remote remote) {
        String insteadOf;
        boolean substituted;
        if (urlSections == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlSections", "git4idea/repo/GitConfig", "substituteUrls"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/repo/GitConfig", "substituteUrls"));
        }
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        UrlsAndPushUrls urlsAndPushUrls = new UrlsAndPushUrls(urls, pushUrls);
        if (urlsAndPushUrls == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "substituteUrls"));
        }
        return urlsAndPushUrls;
    }

    @NotNull
    private static String substituteUrl(@NotNull String remoteUrl, @NotNull Url url, @NotNull String insteadOf) {
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "git4idea/repo/GitConfig", "substituteUrl"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "git4idea/repo/GitConfig", "substituteUrl"));
        }
        if (insteadOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insteadOf", "git4idea/repo/GitConfig", "substituteUrl"));
        }
        String string = url.myName + remoteUrl.substring(insteadOf.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "substituteUrl"));
        }
        return string;
    }

    @Nullable
    private static Remote parseRemoteSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        if (sectionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionName", "git4idea/repo/GitConfig", "parseRemoteSection"));
        }
        if (section == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "section", "git4idea/repo/GitConfig", "parseRemoteSection"));
        }
        RemoteBean remoteBean = (RemoteBean)section.as(RemoteBean.class, classLoader);
        Matcher matcher = REMOTE_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new Remote(matcher.group(1), remoteBean);
        }
        LOG.error(String.format("Invalid remote section format in .git/config. sectionName: %s section: %s", sectionName, section));
        return null;
    }

    @Nullable
    private static Url parseUrlSection(@NotNull String sectionName, @NotNull Profile.Section section, @Nullable ClassLoader classLoader) {
        if (sectionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sectionName", "git4idea/repo/GitConfig", "parseUrlSection"));
        }
        if (section == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "section", "git4idea/repo/GitConfig", "parseUrlSection"));
        }
        UrlBean urlBean = (UrlBean)section.as(UrlBean.class, classLoader);
        Matcher matcher = URL_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            return new Url(matcher.group(1), urlBean);
        }
        LOG.error(String.format("Invalid url section format in .git/config. sectionName: %s section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static String[] notNull(@Nullable String[] s) {
        String[] stringArray = s == null ? ArrayUtil.EMPTY_STRING_ARRAY : s;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "notNull"));
        }
        return stringArray;
    }

    @NotNull
    private static Collection<String> nonNullCollection(@Nullable String[] array) {
        ArrayList<String> arrayList = array == null ? Collections.emptyList() : new ArrayList<String>(Arrays.asList(array));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig", "nonNullCollection"));
        }
        return arrayList;
    }

    private static interface BranchBean {
        @Nullable
        public String getRemote();

        @Nullable
        public String getMerge();

        @Nullable
        public String getRebase();
    }

    private static class BranchConfig {
        private final String myName;
        private final BranchBean myBean;

        public BranchConfig(String name, BranchBean bean) {
            this.myName = name;
            this.myBean = bean;
        }

        public String getName() {
            return this.myName;
        }

        public BranchBean getBean() {
            return this.myBean;
        }
    }

    private static interface UrlBean {
        @Nullable
        public String getInsteadOf();

        @Nullable
        public String getPushInsteadOf();
    }

    private static class Url {
        private final String myName;
        private final UrlBean myUrlBean;

        private Url(String name, UrlBean urlBean) {
            this.myUrlBean = urlBean;
            this.myName = name;
        }

        @Nullable
        public String getInsteadOf() {
            return this.myUrlBean.getInsteadOf();
        }

        @Nullable
        public String getPushInsteadOf() {
            return this.myUrlBean.getPushInsteadOf();
        }
    }

    private static interface RemoteBean {
        @Nullable
        public String[] getFetch();

        @Nullable
        public String[] getPush();

        @Nullable
        public String[] getUrl();

        @Nullable
        public String[] getPushUrl();
    }

    private static class Remote {
        private final String myName;
        private final RemoteBean myRemoteBean;

        private Remote(@NotNull String name, @NotNull RemoteBean remoteBean) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/repo/GitConfig$Remote", "<init>"));
            }
            if (remoteBean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteBean", "git4idea/repo/GitConfig$Remote", "<init>"));
            }
            this.myRemoteBean = remoteBean;
            this.myName = name;
        }

        @NotNull
        private Collection<String> getUrls() {
            Collection collection = GitConfig.nonNullCollection(this.myRemoteBean.getUrl());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig$Remote", "getUrls"));
            }
            return collection;
        }

        @NotNull
        private Collection<String> getPushUrls() {
            Collection collection = GitConfig.nonNullCollection(this.myRemoteBean.getPushUrl());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig$Remote", "getPushUrls"));
            }
            return collection;
        }

        @Nullable
        private List<String> getPushSpec() {
            String[] push = this.myRemoteBean.getPush();
            return push == null ? null : Arrays.asList(push);
        }

        @NotNull
        private List<String> getFetchSpecs() {
            List<String> list = Arrays.asList(GitConfig.notNull(this.myRemoteBean.getFetch()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/repo/GitConfig$Remote", "getFetchSpecs"));
            }
            return list;
        }
    }

    private static class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

