/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    private boolean myDestroyRecursively;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(commandLine.createProcess(), commandLine.getCommandLineString(), CharsetToolkit.UTF8_CHARSET);
    }

    public OSProcessHandler(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, @Nullable String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, @Nullable String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        super(process, commandLine, charset);
        this.myDestroyRecursively = true;
    }

    protected OSProcessHandler(@NotNull OSProcessHandler base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/execution/process/OSProcessHandler", "<init>"));
        }
        this(base.myProcess, base.myCommandLine);
    }

    protected Future<?> executeOnPooledThread(Runnable task) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            return application.executeOnPooledThread(task);
        }
        return super.executeOnPooledThread(task);
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected boolean killProcessTree(Process process) {
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
            process.destroy();
        }
        return destroyed;
    }
}

