/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.util.log;

import com.intellij.remoteServer.agent.util.ILogger;
import com.intellij.remoteServer.agent.util.log.LogListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LogPipe {
    private final ILogger myLog;
    private final String myDeploymentName;
    private boolean myClosed;
    private int myTotalLines;
    private int myLines2Skip;

    public LogPipe(String deploymentName, ILogger log) {
        this.myDeploymentName = deploymentName;
        this.myLog = log;
        this.myClosed = false;
    }

    public void open() {
        InputStream inputStream = this.createInputStream(this.myDeploymentName);
        if (inputStream == null) {
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        final BufferedReader bufferedReader = new BufferedReader(streamReader);
        this.myTotalLines = 0;
        this.myLines2Skip = 0;
        new Thread(){

            public void run() {
                try {
                    while (true) {
                        String line = bufferedReader.readLine();
                        if (LogPipe.this.myClosed) {
                            LogPipe.this.myLog.debug("log pipe closed for: " + LogPipe.this.myDeploymentName);
                            break;
                        }
                        if (line == null) {
                            LogPipe.this.myLog.debug("end of log stream for: " + LogPipe.this.myDeploymentName);
                            break;
                        }
                        if (LogPipe.this.myLines2Skip == 0) {
                            LogPipe.this.getLogListener().lineLogged(line);
                            LogPipe.this.myTotalLines++;
                            continue;
                        }
                        LogPipe.this.myLines2Skip--;
                    }
                }
                catch (IOException e) {
                    LogPipe.this.myLog.errorEx(e);
                }
            }
        }.start();
    }

    public void close() {
        this.myClosed = true;
    }

    protected final void cutTail() {
        this.myLines2Skip = this.myTotalLines;
    }

    protected final boolean isClosed() {
        return this.myClosed;
    }

    protected abstract InputStream createInputStream(String var1);

    protected abstract LogListener getLogListener();
}

