/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.RearrangeCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RearrangeCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = "Rearrange code";
    public static final String PROGRESS_TEXT = "Rearranging code...";
    @Nullable
    private Condition<PsiFile> myAcceptCondition;
    private Collection<TextRange> myRangesForFile;

    public RearrangeCodeProcessor(@NotNull AbstractLayoutCodeProcessor previousProcessor, @Nullable Condition<PsiFile> acceptCondition) {
        if (previousProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previousProcessor", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(previousProcessor, COMMAND_NAME, PROGRESS_TEXT);
        this.myRangesForFile = ContainerUtil.newArrayList();
        this.myAcceptCondition = acceptCondition;
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile file, @Nullable Collection<TextRange> ranges) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, file, PROGRESS_TEXT, COMMAND_NAME, false);
        this.myRangesForFile = ContainerUtil.newArrayList();
        if (ranges != null) {
            this.myRangesForFile.addAll(ranges);
        }
    }

    public RearrangeCodeProcessor(@NotNull Project project, @NotNull PsiFile[] files, @NotNull String commandName, @Nullable Runnable postRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        if (commandName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "<init>"));
        }
        super(project, files, PROGRESS_TEXT, commandName, postRunnable, false);
        this.myRangesForFile = ContainerUtil.newArrayList();
    }

    public boolean shouldRearrangeFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "shouldRearrangeFile"));
        }
        return this.myAcceptCondition == null || this.myAcceptCondition.value((Object)file);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(final @NotNull PsiFile file, boolean processChangedTextOnly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    if (!RearrangeCodeProcessor.this.shouldRearrangeFile(file)) {
                        Boolean bl = true;
                        return bl;
                    }
                    Collection<TextRange> ranges = RearrangeCodeProcessor.this.getRangesToFormat(file);
                    RearrangeCommand rearranger = new RearrangeCommand(RearrangeCodeProcessor.this.myProject, file, RearrangeCodeProcessor.COMMAND_NAME, ranges);
                    if (rearranger.couldRearrange()) {
                        rearranger.run();
                    }
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    RearrangeCodeProcessor.this.myRangesForFile.clear();
                }
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    public Collection<TextRange> getRangesToFormat(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/RearrangeCodeProcessor", "getRangesToFormat"));
        }
        return this.myRangesForFile.isEmpty() ? ContainerUtil.newArrayList((Object[])new TextRange[]{file.getTextRange()}) : this.myRangesForFile;
    }
}

