/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableUtil {
    public static final int MAKE_STATEMENT = 1;
    public static final int DELETE_ALL = 2;
    public static final int CANCEL = 0;
    private static final Set<String> ourSideEffectFreeClasses = new THashSet();

    static boolean isSideEffectFreeConstructor(PsiNewExpression newExpression) {
        PsiClass throwableClass;
        String packageName;
        String qualifiedName;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        PsiClass aClass = classReference == null ? null : (PsiClass)classReference.resolve();
        String string = qualifiedName = aClass == null ? null : aClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        if (ourSideEffectFreeClasses.contains(qualifiedName)) {
            return true;
        }
        PsiFile file = aClass.getContainingFile();
        PsiDirectory directory = file.getContainingDirectory();
        PsiPackage classPackage = JavaDirectoryService.getInstance().getPackage(directory);
        String string2 = packageName = classPackage == null ? null : classPackage.getQualifiedName();
        return ("java.lang".equals(packageName) || "java.io".equals(packageName)) && (throwableClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.lang.Throwable", aClass.getResolveScope())) != null && InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)throwableClass, (boolean)true);
    }

    public static boolean checkSideEffects(PsiElement element, PsiVariable variable, List<PsiElement> sideEffects) {
        PsiElement[] children;
        PsiNewExpression newExpression;
        PsiMethod psiMethod;
        if (sideEffects == null || element == null) {
            return false;
        }
        if (element instanceof PsiMethodCallExpression && ((psiMethod = ((PsiMethodCallExpression)element).resolveMethod()) == null || !PropertyUtil.isSimpleGetter((PsiMethod)psiMethod) && !PropertyUtil.isSimpleSetter((PsiMethod)psiMethod))) {
            sideEffects.add(element);
            return true;
        }
        if (element instanceof PsiNewExpression && (newExpression = (PsiNewExpression)element).getArrayDimensions().length == 0 && newExpression.getArrayInitializer() == null && !RemoveUnusedVariableUtil.isSideEffectFreeConstructor(newExpression)) {
            sideEffects.add(element);
            return true;
        }
        if (element instanceof PsiAssignmentExpression && (!(((PsiAssignmentExpression)element).getLExpression() instanceof PsiReferenceExpression) || ((PsiReferenceExpression)((PsiAssignmentExpression)element).getLExpression()).resolve() != variable)) {
            sideEffects.add(element);
            return true;
        }
        for (PsiElement child : children = element.getChildren()) {
            RemoveUnusedVariableUtil.checkSideEffects(child, variable, sideEffects);
        }
        return !sideEffects.isEmpty();
    }

    static PsiElement replaceElementWithExpression(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression;
        if (element.getParent() instanceof PsiExpressionStatement) {
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
        }
        return elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    static PsiElement createStatementIfNeeded(PsiExpression expression, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        if (!(element.getParent() instanceof PsiExpressionStatement) && !(element.getParent() instanceof PsiDeclarationStatement)) {
            return expression;
        }
        return factory.createStatementFromText((expression == null ? "" : expression.getText()) + ";", null);
    }

    static void deleteWholeStatement(PsiElement element, PsiElementFactory factory) throws IncorrectOperationException {
        if (element.getParent() instanceof PsiExpressionStatement) {
            PsiExpressionStatement parent = (PsiExpressionStatement)element.getParent();
            if (parent.getParent() instanceof PsiCodeBlock) {
                parent.delete();
            } else {
                parent.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(null, factory, element));
            }
        } else {
            element.delete();
        }
    }

    static void deleteReferences(PsiVariable variable, List<PsiElement> references, int mode) throws IncorrectOperationException {
        for (PsiElement expression : references) {
            RemoveUnusedVariableUtil.processUsage(expression, variable, null, mode);
        }
    }

    static void collectReferences(@NotNull PsiElement context, final PsiVariable variable, final List<PsiElement> references) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedVariableUtil", "collectReferences"));
        }
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                if (expression.resolve() == variable) {
                    references.add(expression);
                }
                super.visitReferenceExpression(expression);
            }
        });
    }

    static Boolean processUsage(PsiElement element, PsiVariable variable, List<PsiElement> sideEffects, int deleteMode) throws IncorrectOperationException {
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)variable.getProject()).getElementFactory();
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression.getRExpression();
                if ((rExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableUtil.checkSideEffects((PsiElement)rExpression, variable, sideEffects);
                if (!(element.getParent() instanceof PsiExpressionStatement) || PsiUtil.isStatement((PsiElement)rExpression)) {
                    if (deleteMode == 1 || deleteMode == 2 && !(element.getParent() instanceof PsiExpressionStatement)) {
                        element = RemoveUnusedVariableUtil.replaceElementWithExpression(rExpression, factory, element);
                        while (element.getParent() instanceof PsiParenthesizedExpression) {
                            element = element.getParent().replace(element);
                        }
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == 2) {
                        RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                    }
                    return true;
                }
                if (deleteMode != 0) {
                    RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != 0) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == element) {
                    element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(";", element));
                    break;
                }
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable) {
                PsiExpression expression = variable.getInitializer();
                if (expression != null) {
                    expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
                }
                boolean sideEffectsFound = RemoveUnusedVariableUtil.checkSideEffects((PsiElement)expression, variable, sideEffects);
                if (expression != null && PsiUtil.isStatement((PsiElement)expression) && variable instanceof PsiLocalVariable && (!(variable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == 1) {
                        element = element.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(expression, factory, element));
                        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == 2) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != 0) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    static {
        ourSideEffectFreeClasses.add(Object.class.getName());
        ourSideEffectFreeClasses.add(Short.class.getName());
        ourSideEffectFreeClasses.add(Character.class.getName());
        ourSideEffectFreeClasses.add(Byte.class.getName());
        ourSideEffectFreeClasses.add(Integer.class.getName());
        ourSideEffectFreeClasses.add(Long.class.getName());
        ourSideEffectFreeClasses.add(Float.class.getName());
        ourSideEffectFreeClasses.add(Double.class.getName());
        ourSideEffectFreeClasses.add(String.class.getName());
        ourSideEffectFreeClasses.add(StringBuffer.class.getName());
        ourSideEffectFreeClasses.add(Boolean.class.getName());
        ourSideEffectFreeClasses.add(ArrayList.class.getName());
        ourSideEffectFreeClasses.add(Date.class.getName());
        ourSideEffectFreeClasses.add(HashMap.class.getName());
        ourSideEffectFreeClasses.add(HashSet.class.getName());
        ourSideEffectFreeClasses.add(Hashtable.class.getName());
        ourSideEffectFreeClasses.add(LinkedHashMap.class.getName());
        ourSideEffectFreeClasses.add(LinkedHashSet.class.getName());
        ourSideEffectFreeClasses.add(LinkedList.class.getName());
        ourSideEffectFreeClasses.add(Stack.class.getName());
        ourSideEffectFreeClasses.add(TreeMap.class.getName());
        ourSideEffectFreeClasses.add(TreeSet.class.getName());
        ourSideEffectFreeClasses.add(Vector.class.getName());
        ourSideEffectFreeClasses.add(WeakHashMap.class.getName());
    }
}

