/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowModulePropertiesFix
extends IntentionAndQuickFixAction {
    private final String myModuleName;

    public ShowModulePropertiesFix(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix", "<init>"));
        }
        this(ModuleUtilCore.findModuleForPsiElement((PsiElement)context));
    }

    public ShowModulePropertiesFix(@Nullable Module module) {
        this.myModuleName = module == null ? null : module.getName();
    }

    @NotNull
    public String getName() {
        AnAction action = ActionManager.getInstance().getAction("ModuleSettings");
        String string = action.getTemplatePresentation().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix", "isAvailable"));
        }
        return this.myModuleName != null;
    }

    public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix", "applyFix"));
        }
        ProjectSettingsService.getInstance(project).showModuleConfigurationDialog(this.myModuleName, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

