/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class BytecodeAnalysisIndex
extends FileBasedIndexExtension<Bytes, HEquations> {
    public static final ID<Bytes, HEquations> NAME = ID.create((String)"bytecodeAnalysis");
    private final HEquationsExternalizer myExternalizer = new HEquationsExternalizer();
    private static final ClassDataIndexer INDEXER = new ClassDataIndexer();
    private static final HKeyDescriptor KEY_DESCRIPTOR = new HKeyDescriptor();
    private static final int ourInternalVersion = 3;
    private static boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.bytecode.contract.inference", (boolean)true);

    @NotNull
    public ID<Bytes, HEquations> getName() {
        ID<Bytes, HEquations> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Bytes, HEquations, FileContent> getIndexer() {
        ClassDataIndexer classDataIndexer = INDEXER;
        if (classDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getIndexer"));
        }
        return classDataIndexer;
    }

    @NotNull
    public KeyDescriptor<Bytes> getKeyDescriptor() {
        HKeyDescriptor hKeyDescriptor = KEY_DESCRIPTOR;
        if (hKeyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getKeyDescriptor"));
        }
        return hKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<HEquations> getValueExternalizer() {
        HEquationsExternalizer hEquationsExternalizer = this.myExternalizer;
        if (hEquationsExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getValueExternalizer"));
        }
        return hEquationsExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$1", "acceptInput"));
                }
                return ourEnabled && super.acceptInput(file);
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3 + (ourEnabled ? 255 : 0);
    }

    public static class HEquationsExternalizer
    implements DataExternalizer<HEquations>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        public void save(@NotNull DataOutput out, HEquations eqs) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "save"));
            }
            out.writeBoolean(eqs.stable);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)eqs.results.size());
            for (DirectionResultPair pair : eqs.results) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)pair.directionKey);
                HResult rhs = pair.hResult;
                if (rhs instanceof HFinal) {
                    HFinal finalResult = (HFinal)rhs;
                    out.writeBoolean(true);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)finalResult.value.ordinal());
                    continue;
                }
                HPending pendResult = (HPending)rhs;
                out.writeBoolean(false);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)pendResult.delta.length);
                for (HComponent component : pendResult.delta) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)component.value.ordinal());
                    HKey[] ids = component.ids;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)ids.length);
                    for (HKey hKey : ids) {
                        out.write(hKey.key);
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)hKey.dirKey);
                        out.writeBoolean(hKey.stable);
                    }
                }
            }
        }

        public HEquations read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HEquationsExternalizer", "read"));
            }
            boolean stable = in.readBoolean();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            ArrayList<DirectionResultPair> results = new ArrayList<DirectionResultPair>(size);
            for (int k = 0; k < size; ++k) {
                int directionKey = DataInputOutputUtil.readINT((DataInput)in);
                boolean isFinal = in.readBoolean();
                if (isFinal) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value = Value.values()[ordinal];
                    results.add(new DirectionResultPair(directionKey, new HFinal(value)));
                    continue;
                }
                int sumLength = DataInputOutputUtil.readINT((DataInput)in);
                HComponent[] components = new HComponent[sumLength];
                for (int i = 0; i < sumLength; ++i) {
                    int ordinal = DataInputOutputUtil.readINT((DataInput)in);
                    Value value = Value.values()[ordinal];
                    int componentSize = DataInputOutputUtil.readINT((DataInput)in);
                    HKey[] ids = new HKey[componentSize];
                    for (int j = 0; j < componentSize; ++j) {
                        byte[] bytes = new byte[14];
                        for (int bi = 0; bi < bytes.length; ++bi) {
                            bytes[bi] = in.readByte();
                        }
                        ids[j] = new HKey(bytes, DataInputOutputUtil.readINT((DataInput)in), in.readBoolean());
                    }
                    components[i] = new HComponent(value, ids);
                }
                results.add(new DirectionResultPair(directionKey, new HPending(components)));
            }
            return new HEquations(results, stable);
        }
    }

    private static class HKeyDescriptor
    implements KeyDescriptor<Bytes>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private HKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Bytes value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "save"));
            }
            out.write(value.bytes);
        }

        public Bytes read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/codeInspection/bytecodeAnalysis/BytecodeAnalysisIndex$HKeyDescriptor", "read"));
            }
            byte[] bytes = new byte[14];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = in.readByte();
            }
            return new Bytes(bytes);
        }

        public int getHashCode(Bytes value) {
            return Arrays.hashCode(value.bytes);
        }

        public boolean isEqual(Bytes val1, Bytes val2) {
            return Arrays.equals(val1.bytes, val2.bytes);
        }
    }
}

