/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.ValuableDataFlowRunner;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    public static Collection<PsiExpression> getCachedVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        Collection concatenations;
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> value = DfaUtil.getCachedPlaceResults(codeBlock);
        if (value == null) {
            return null;
        }
        ValuableInstructionVisitor.PlaceResult placeResult = value.get(context);
        Collection collection = concatenations = placeResult == null ? null : placeResult.myValues.get((Object)variable);
        if (concatenations != null) {
            return ContainerUtil.map((Collection)concatenations, (Function)new Function<FList<PsiExpression>, PsiExpression>(){

                public PsiExpression fun(FList<PsiExpression> expressions) {
                    return DfaUtil.concatenateExpressions((FList<PsiExpression>)expressions);
                }
            });
        }
        return Collections.emptyList();
    }

    @Nullable(value="null means DFA analysis has failed (too complex to analyze)")
    private static Map<PsiElement, ValuableInstructionVisitor.PlaceResult> getCachedPlaceResults(final @NotNull PsiElement codeBlock) {
        if (codeBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBlock", "com/intellij/codeInspection/dataFlow/DfaUtil", "getCachedPlaceResults"));
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)codeBlock, (CachedValueProvider)new CachedValueProvider<Map<PsiElement, ValuableInstructionVisitor.PlaceResult>>(){

            public CachedValueProvider.Result<Map<PsiElement, ValuableInstructionVisitor.PlaceResult>> compute() {
                ValuableInstructionVisitor visitor = new ValuableInstructionVisitor();
                RunnerResult runnerResult = new ValuableDataFlowRunner(codeBlock).analyzeMethod(codeBlock, visitor);
                return CachedValueProvider.Result.create(runnerResult == RunnerResult.OK ? visitor.myResults : null, (Object[])new Object[]{codeBlock});
            }
        });
    }

    @NotNull
    public static Nullness checkNullness(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        ValuableInstructionVisitor.PlaceResult placeResult;
        if (variable == null || context == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        PsiElement codeBlock = DfaPsiUtil.getEnclosingCodeBlock(variable, context);
        Map<PsiElement, ValuableInstructionVisitor.PlaceResult> results = codeBlock == null ? null : DfaUtil.getCachedPlaceResults(codeBlock);
        ValuableInstructionVisitor.PlaceResult placeResult2 = placeResult = results == null ? null : results.get(context);
        if (placeResult == null) {
            Nullness nullness = Nullness.UNKNOWN;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (placeResult.myNulls.contains(variable) && !placeResult.myNotNulls.contains(variable)) {
            Nullness nullness = Nullness.NULLABLE;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        if (placeResult.myNotNulls.contains(variable) && !placeResult.myNulls.contains(variable)) {
            Nullness nullness = Nullness.NOT_NULL;
            if (nullness == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
            }
            return nullness;
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "checkNullness"));
        }
        return nullness;
    }

    @NotNull
    public static Collection<? extends PsiElement> getPossibleInitializationElements(PsiElement qualifierExpression) {
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            List<PsiElement> list = Collections.singletonList(qualifierExpression);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list;
        }
        if (qualifierExpression instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return list;
            }
            Collection<PsiExpression> variableValues = DfaUtil.getCachedVariableValues((PsiVariable)targetElement, qualifierExpression);
            if (variableValues == null || variableValues.isEmpty()) {
                Collection<PsiExpression> collection = DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
                }
                return collection;
            }
            Collection<PsiExpression> collection = variableValues;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return collection;
        }
        if (qualifierExpression instanceof PsiLiteralExpression) {
            List<PsiElement> list = Collections.singletonList(qualifierExpression);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaUtil", "getPossibleInitializationElements"));
        }
        return list;
    }

    private static PsiExpression concatenateExpressions(FList<PsiExpression> concatenation) {
        if (concatenation.size() == 1) {
            return (PsiExpression)concatenation.getHead();
        }
        String text = StringUtil.join((Collection)ContainerUtil.reverse(new ArrayList<PsiExpression>((Collection<PsiExpression>)concatenation)), (Function)new Function<PsiExpression, String>(){

            public String fun(PsiExpression expression) {
                return expression.getText();
            }
        }, (String)"+");
        try {
            return JavaPsiFacade.getElementFactory((Project)((PsiExpression)concatenation.getHead()).getProject()).createExpressionFromText(text, (PsiElement)concatenation.getHead());
        }
        catch (IncorrectOperationException e) {
            return (PsiExpression)concatenation.getHead();
        }
    }

    private static class ValuableInstructionVisitor
    extends StandardInstructionVisitor {
        final Map<PsiElement, PlaceResult> myResults = ContainerUtil.newHashMap();

        private ValuableInstructionVisitor() {
        }

        @Override
        public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiExpression place = instruction.getPlace();
            if (place != null) {
                PsiModifierListOwner element;
                PlaceResult result = this.myResults.get(place);
                if (result == null) {
                    result = new PlaceResult();
                    this.myResults.put((PsiElement)place, result);
                }
                Map<DfaVariableValue, DfaVariableState> map = ((ValuableDataFlowRunner.MyDfaMemoryState)memState).getVariableStates();
                for (Map.Entry<DfaVariableValue, DfaVariableState> entry : map.entrySet()) {
                    PsiModifierListOwner element2;
                    ValuableDataFlowRunner.ValuableDfaVariableState state = (ValuableDataFlowRunner.ValuableDfaVariableState)entry.getValue();
                    DfaVariableValue variableValue = entry.getKey();
                    FList<PsiExpression> concatenation = state.myConcatenation;
                    if (concatenation.isEmpty() || variableValue.getQualifier() != null || !((element2 = variableValue.getPsiVariable()) instanceof PsiVariable)) continue;
                    result.myValues.put((Object)((PsiVariable)element2), concatenation);
                }
                DfaValue value = instruction.getValue();
                if (value instanceof DfaVariableValue && ((DfaVariableValue)value).getQualifier() == null && (element = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiVariable) {
                    if (memState.isNotNull(value)) {
                        result.myNotNulls.add((PsiVariable)element);
                    }
                    if (memState.isNull(value)) {
                        result.myNulls.add((PsiVariable)element);
                    }
                }
            }
            return super.visitPush(instruction, runner, memState);
        }

        @Override
        public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState _memState) {
            Instruction nextInstruction = runner.getInstruction(instruction.getIndex() + 1);
            ValuableDataFlowRunner.MyDfaMemoryState memState = (ValuableDataFlowRunner.MyDfaMemoryState)_memState;
            DfaValue dfaSource = memState.pop();
            DfaValue dfaDest = memState.pop();
            if (dfaDest instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)dfaDest;
                PsiExpression rightValue = instruction.getRExpression();
                PsiElement parent = rightValue == null ? null : rightValue.getParent();
                IElementType type = parent instanceof PsiAssignmentExpression ? ((PsiAssignmentExpression)parent).getOperationTokenType() : JavaTokenType.EQ;
                FList<PsiExpression> prevValue = ((ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState((DfaVariableValue)var)).myConcatenation;
                memState.setVarValue(var, dfaSource);
                ValuableDataFlowRunner.ValuableDfaVariableState curState = (ValuableDataFlowRunner.ValuableDfaVariableState)memState.getVariableState(var);
                FList curValue = curState.myConcatenation;
                FList nextValue = type == JavaTokenType.PLUSEQ && !prevValue.isEmpty() ? prevValue.prepend((Object)rightValue) : (curValue.isEmpty() ? curValue.prepend((Object)rightValue) : curValue);
                memState.setVariableState(var, curState.withExpression((FList<PsiExpression>)nextValue));
            }
            memState.push(dfaDest);
            return new DfaInstructionState[]{new DfaInstructionState(nextInstruction, memState)};
        }

        static class PlaceResult {
            final MultiValuesMap<PsiVariable, FList<PsiExpression>> myValues = new MultiValuesMap(true);
            final Set<PsiVariable> myNulls = new THashSet();
            final Set<PsiVariable> myNotNulls = new THashSet();

            PlaceResult() {
            }
        }
    }
}

